/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.nfunk.jep.JEP;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionConfigWrapper
extends BaseThresholdDefConfigWrapper {
    private Expression m_expression;
    private Collection<String> m_datasources;
    private JEP m_parser;

    public ExpressionConfigWrapper(Expression expression) throws ThresholdExpressionException {
        super((Basethresholddef)expression);
        this.m_expression = expression;
        this.m_datasources = new ArrayList<String>();
        this.m_parser = new JEP();
        this.m_parser.setAllowUndeclared(true);
        this.m_parser.parseExpression(this.m_expression.getExpression());
        if (this.m_parser.hasError()) {
            throw new ThresholdExpressionException("Could not parse threshold expression:" + this.m_parser.getErrorInfo());
        }
        this.m_datasources.addAll(this.m_parser.getSymbolTable().keySet());
    }

    @Override
    public String getDatasourceExpression() {
        return this.m_expression.getExpression();
    }

    @Override
    public Collection<String> getRequiredDatasources() {
        return this.m_datasources;
    }

    @Override
    public double evaluate(Map<String, Double> values) throws ThresholdExpressionException {
        for (String valueName : values.keySet()) {
            this.m_parser.addVariable(valueName, (Object)values.get(valueName));
        }
        double result = this.m_parser.getValue();
        if (this.m_parser.hasError()) {
            throw new ThresholdExpressionException("Error while evaluating expression " + this.m_expression.getExpression() + ": " + this.m_parser.getErrorInfo());
        }
        return result;
    }
}

