/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.text.ParseException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.opennms.netmgt.statsd.ReportDefinitionBuilder;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.netmgt.statsd.ReportPersister;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.CronTriggerBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class Statsd
implements SpringServiceDaemon {
    private ResourceDao m_resourceDao;
    private RrdDao m_rrdDao;
    private FilterDao m_filterDao;
    private TransactionTemplate m_transactionTemplate;
    private ReportPersister m_reportPersister;
    private Scheduler m_scheduler;
    private ReportDefinitionBuilder m_reportDefinitionBuilder;

    public void start() throws InterruptedException, ParseException, SchedulerException, ClassNotFoundException, NoSuchMethodException {
        for (ReportDefinition reportDef : this.m_reportDefinitionBuilder.buildReportDefinitions()) {
            this.scheduleReport(reportDef);
        }
    }

    private void scheduleReport(ReportDefinition reportDef) throws ClassNotFoundException, NoSuchMethodException, ParseException, SchedulerException {
        MethodInvokingJobDetailFactoryBean jobFactory = new MethodInvokingJobDetailFactoryBean();
        jobFactory.setTargetObject((Object)this);
        jobFactory.setTargetMethod("runReport");
        jobFactory.setArguments(new Object[]{reportDef});
        jobFactory.setConcurrent(false);
        jobFactory.setBeanName(reportDef.getDescription());
        jobFactory.afterPropertiesSet();
        JobDetail jobDetail = (JobDetail)jobFactory.getObject();
        CronTriggerBean cronReportTrigger = new CronTriggerBean();
        cronReportTrigger.setBeanName(reportDef.getDescription());
        cronReportTrigger.setJobDetail(jobDetail);
        cronReportTrigger.setCronExpression(reportDef.getCronExpression());
        cronReportTrigger.afterPropertiesSet();
        this.m_scheduler.scheduleJob(cronReportTrigger.getJobDetail(), (Trigger)cronReportTrigger);
        this.log().debug((Object)("Schedule report " + cronReportTrigger));
    }

    public void runReport(ReportDefinition reportDef) throws Throwable {
        ReportInstance report;
        try {
            report = reportDef.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        }
        catch (Throwable t) {
            this.log().error((Object)("Could not create a report instance for report definition " + reportDef + ": " + t), t);
            throw t;
        }
        this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Statsd.this.log().debug((Object)("Starting report " + report));
                report.walk();
                Statsd.this.log().debug((Object)("Completed report " + report));
                Statsd.this.m_reportPersister.persist(report);
                Statsd.this.log().debug((Object)("Report " + report + " persisted"));
            }
        });
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"property rrdDao must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_transactionTemplate != null ? 1 : 0) != 0, (String)"property transactionTemplate must be set to a non-null value");
        Assert.state((this.m_reportPersister != null ? 1 : 0) != 0, (String)"property reportPersister must be set to a non-null value");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"property scheduler must be set to a non-null value");
        Assert.state((this.m_reportDefinitionBuilder != null ? 1 : 0) != 0, (String)"property reportDefinitionBuilder must be set to a non-null value");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.m_transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.m_transactionTemplate = transactionTemplate;
    }

    public ReportPersister getReportPersister() {
        return this.m_reportPersister;
    }

    public void setReportPersister(ReportPersister reportPersister) {
        this.m_reportPersister = reportPersister;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public ReportDefinitionBuilder getReportDefinitionBuilder() {
        return this.m_reportDefinitionBuilder;
    }

    public void setReportDefinitionBuilder(ReportDefinitionBuilder reportDefinitionBuilder) {
        this.m_reportDefinitionBuilder = reportDefinitionBuilder;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }
}

