/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollConfig;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.scheduler.PostponeNecessary;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.xml.event.Event;

public class PollableService
extends PollableElement
implements ReadyRunnable,
MonitoredService {
    private String m_svcName;
    private PollConfig m_pollConfig;
    private IPv4NetworkInterface m_netInterface;
    private PollStatus m_oldStatus;
    private Schedule m_schedule;
    private long m_statusChangeTime = 0L;

    public PollableService(PollableInterface iface, String svcName) {
        super(iface);
        this.m_svcName = svcName;
        this.m_netInterface = new IPv4NetworkInterface(iface.getAddress());
    }

    public PollableInterface getInterface() {
        return (PollableInterface)this.getParent();
    }

    public PollableNode getNode() {
        return this.getInterface().getNode();
    }

    public PollableNetwork getNetwork() {
        return this.getInterface().getNetwork();
    }

    public PollContext getContext() {
        return this.getInterface().getContext();
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public String getIpAddr() {
        return this.getInterface().getIpAddr();
    }

    public int getNodeId() {
        return this.getInterface().getNodeId();
    }

    public String getNodeLabel() {
        return this.getInterface().getNodeLabel();
    }

    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitService(this);
    }

    public void setPollConfig(PollableServiceConfig pollConfig) {
        this.m_pollConfig = pollConfig;
    }

    public PollStatus poll() {
        PollStatus newStatus = this.m_pollConfig.poll();
        this.updateStatus(newStatus);
        return this.getStatus();
    }

    public NetworkInterface getNetInterface() {
        return this.m_netInterface;
    }

    public InetAddress getAddress() {
        return this.getInterface().getAddress();
    }

    public PollStatus doPoll() {
        if (this.getContext().isNodeProcessingEnabled()) {
            return this.getParent().doPoll(this);
        }
        this.resetStatusChanged();
        return this.poll();
    }

    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeLostService", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeRegainedService", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public Event createUnresponsiveEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/serviceUnresponsive", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public Event createResponsiveEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/serviceResponsive", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public void createOutage(PollEvent cause) {
        super.createOutage(cause);
        this.getContext().openOutage(this, cause);
    }

    protected void resolveOutage(PollEvent resolution) {
        super.resolveOutage(resolution);
        this.getContext().resolveOutage(this, resolution);
    }

    public String toString() {
        return this.getInterface() + ":" + this.getSvcName();
    }

    public void processStatusChange(Date date) {
        if (this.getContext().isServiceUnresponsiveEnabled()) {
            if (this.isStatusChanged() && this.getStatus().equals((Object)PollStatus.unresponsive())) {
                this.getContext().sendEvent(this.createUnresponsiveEvent(date));
                if (this.m_oldStatus.equals((Object)PollStatus.up())) {
                    this.resetStatusChanged();
                }
            } else if (this.isStatusChanged() && this.m_oldStatus.equals((Object)PollStatus.unresponsive())) {
                this.getContext().sendEvent(this.createResponsiveEvent(date));
                if (this.getStatus().equals((Object)PollStatus.up())) {
                    this.resetStatusChanged();
                }
            }
        }
        super.processStatusChange(date);
    }

    public void updateStatus(PollStatus newStatus) {
        PollStatus currentStatus;
        if (!this.getContext().isServiceUnresponsiveEnabled() && newStatus.equals((Object)PollStatus.unresponsive())) {
            newStatus = PollStatus.down();
        }
        if (!(currentStatus = this.getStatus()).equals((Object)newStatus)) {
            this.m_oldStatus = this.getStatus();
            this.setStatusChangeTime(this.m_pollConfig.getCurrentTime());
        }
        super.updateStatus(newStatus);
        if (!currentStatus.equals((Object)newStatus)) {
            this.getSchedule().adjustSchedule();
        }
    }

    public synchronized void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    public synchronized Schedule getSchedule() {
        return this.m_schedule;
    }

    public long getStatusChangeTime() {
        return this.m_statusChangeTime;
    }

    private void setStatusChangeTime(long statusChangeTime) {
        this.m_statusChangeTime = statusChangeTime;
    }

    public boolean isReady() {
        return true;
    }

    public void run() {
        this.doRun(500);
    }

    public PollStatus doRun() {
        return this.doRun(0);
    }

    private PollStatus doRun(int timeout) {
        PollStatus status;
        long startDate = System.currentTimeMillis();
        this.log().debug((Object)("Start Scheduled Poll of service " + this));
        if (this.getContext().isNodeProcessingEnabled()) {
            PollRunner r = new PollRunner();
            try {
                this.withTreeLock(r, timeout);
            }
            catch (LockUnavailable e) {
                this.log().info((Object)("Postponing poll for " + this + " because " + e));
                throw new PostponeNecessary("LockUnavailable postpone poll");
            }
            status = r.getPollStatus();
        } else {
            this.doPoll();
            this.processStatusChange(new Date());
            status = this.getStatus();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Finish Scheduled Poll of service " + this + ", started at " + new Date(startDate)));
        }
        return status;
    }

    private Category log() {
        return ThreadCategory.getInstance(PollableService.class);
    }

    public void delete() {
        Runnable r = new Runnable(){

            public void run() {
                PollableService.super.delete();
                PollableService.this.m_schedule.unschedule();
            }
        };
        this.withTreeLock(r);
    }

    public void schedule() {
        if (this.m_schedule == null) {
            throw new IllegalStateException("Cannot schedule a service whose schedule is set to null");
        }
        this.m_schedule.schedule();
    }

    public void sendDeleteEvent() {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/deleteService", this.getNodeId(), this.getAddress(), this.getSvcName(), new Date(), this.getStatus().getReason()));
    }

    public void refreshConfig() {
        this.m_pollConfig.refresh();
    }

    private final class PollRunner
    implements Runnable {
        private PollStatus m_pollStatus;

        private PollRunner() {
        }

        public void run() {
            PollableService.this.doPoll();
            PollableService.this.getNode().processStatusChange(new Date());
            this.m_pollStatus = PollableService.this.getStatus();
        }

        public PollStatus getPollStatus() {
            return this.m_pollStatus;
        }
    }
}

