/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public class SnmpMonitor
extends SnmpMonitorStrategy {
    private static final String SERVICE_NAME = "SNMP";
    private static final String DEFAULT_OBJECT_IDENTIFIER = ".1.3.6.1.2.1.1.2.0";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(SNMP_AGENTCONFIG_KEY, agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(SNMP_AGENTCONFIG_KEY);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String oid = ParameterMap.getKeyedString(parameters, "oid", DEFAULT_OBJECT_IDENTIFIER);
        String operator = ParameterMap.getKeyedString(parameters, "operator", null);
        String operand = ParameterMap.getKeyedString(parameters, "operand", null);
        String walkstr = ParameterMap.getKeyedString(parameters, "walk", "false");
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, "timeout", agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, "retries", agentConfig.getRetries()));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, "port", agentConfig.getPort()));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: service= SNMP address= " + agentConfig));
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("SnmpMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            SnmpObjId snmpObjectId = SnmpObjId.get((String)oid);
            if ("true".equals(walkstr)) {
                List results = SnmpUtils.getColumns((SnmpAgentConfig)agentConfig, (String)"snmpPoller", (SnmpObjId)snmpObjectId);
                for (SnmpValue result : results) {
                    if (result != null) {
                        this.log().debug((Object)("poll: SNMPwalk poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + oid + " value=" + result));
                        if (!this.meetsCriteria(result, operator, operand)) continue;
                        status = PollStatus.available();
                        continue;
                    }
                    status = this.logDown(Level.DEBUG, "SNMP poll failed, addr=" + ipaddr.getHostAddress() + " oid=" + oid);
                    return status;
                }
            } else {
                SnmpValue result = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId);
                if (result != null) {
                    this.log().debug((Object)("poll: SNMP poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + oid + " value=" + result));
                    status = this.meetsCriteria(result, operator, operand) ? PollStatus.available() : PollStatus.unavailable();
                } else {
                    status = this.logDown(Level.DEBUG, "SNMP poll failed, addr=" + ipaddr.getHostAddress() + " oid=" + oid);
                }
            }
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }
}

