/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.MailTransportParameters;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.JavaMailer;
import org.opennms.netmgt.utils.JavaMailerException;

@Distributable
public class MailTransportMonitor
extends IPv4Monitor {
    public PollStatus poll(MonitoredService svc, Map parameters) {
        Category log = ThreadCategory.getInstance();
        PollStatus status = null;
        try {
            MailTransportParameters mailParms = MailTransportParameters.get(parameters);
            if ("${ipaddr}".equals(mailParms.getReadTestHost())) {
                mailParms.setReadTestHost(svc.getIpAddr());
            }
            if ("${ipaddr}".equals(mailParms.getSendTestHost())) {
                mailParms.setSendTestHost(svc.getIpAddr());
            }
            this.parseJavaMailProperties(mailParms);
            status = this.doMailTest(mailParms);
        }
        catch (Exception e) {
            log.error((Object)"poll, Exception from mailer: ", (Throwable)e);
            status = PollStatus.down((String)("Exception from mailer: " + e.getLocalizedMessage()));
        }
        return status;
    }

    private void parseJavaMailProperties(MailTransportParameters mailParms) {
        List propertyList = mailParms.getReadTest().getJavamailPropertyCollection();
        propertyList.addAll(mailParms.getSendTest().getJavamailPropertyCollection());
        Properties props = mailParms.getJavamailProperties();
        for (JavamailProperty property : propertyList) {
            props.setProperty(property.getName(), property.getValue());
        }
        mailParms.setJavamailProperties(props);
    }

    private PollStatus doMailTest(MailTransportParameters mailParms) {
        long beginPoll = System.currentTimeMillis();
        PollStatus status = PollStatus.unknown((String)"Beginning poll.");
        if (mailParms.getSendTest() != null && mailParms.getReadTest() != null) {
            mailParms.setEnd2EndTestInProgress(true);
            mailParms.setTestSubjectSuffix(String.valueOf(beginPoll));
            status = this.sendTestMessage(mailParms);
            if (status.isAvailable()) {
                status = this.readTestMessage(mailParms);
            }
        } else if (mailParms.getReadTest() != null) {
            status = this.readTestMessage(mailParms);
        } else if (mailParms.getSendTest() != null) {
            status = this.sendTestMessage(mailParms);
        } else {
            throw new IllegalArgumentException("MailTransportMonitor requires either send-host or read-host parameters");
        }
        if (status.isAvailable()) {
            status.setResponseTime(Double.valueOf(String.valueOf(System.currentTimeMillis() - beginPoll)));
        }
        return status;
    }

    private PollStatus readTestMessage(MailTransportParameters mailParms) {
        this.log().debug((Object)"readTestMessage: Beginning read mail test.");
        PollStatus status = PollStatus.unavailable((String)"Test not completed.");
        long interval = mailParms.getReadTestAttemptInterval();
        if (mailParms.isEnd2EndTestInProgress()) {
            this.log().debug((Object)("Initially delaying read test: " + mailParms.getReadTestAttemptInterval() + " because end to end test is in progress."));
            if (this.delayTest(status, interval).getStatusCode() == 0) {
                return status;
            }
        }
        try {
            JavaMailer readMailer = new JavaMailer(mailParms.getJavamailProperties());
            this.setReadMailProperties(mailParms, readMailer);
            Store mailStore = null;
            Folder mailFolder = null;
            TimeoutTracker tracker = new TimeoutTracker(mailParms.getParameterMap(), mailParms.getRetries(), mailParms.getTimeout());
            tracker.reset();
            while (tracker.shouldRetry()) {
                block9: {
                    tracker.startAttempt();
                    this.log().debug((Object)("readTestMessage: reading mail attempt: " + tracker.getAttempt() + ", elapsed time:" + tracker.elapsedTimeInMillis() + "ms."));
                    try {
                        mailStore = readMailer.getSession().getStore();
                        mailFolder = this.retrieveMailFolder(mailParms, mailStore);
                        mailFolder.open(2);
                    }
                    catch (MessagingException e) {
                        if (tracker.shouldRetry()) {
                            this.log().warn((Object)("readTestMessage: error reading inbox: " + (Object)((Object)e)));
                            this.closeStore(mailStore, mailFolder);
                            break block9;
                        }
                        this.log().warn((Object)("readTestMessage: error reading inbox: " + (Object)((Object)e)));
                        return PollStatus.down((String)e.getLocalizedMessage());
                    }
                    if (!mailFolder.isOpen() || mailParms.getReadTest().getSubjectMatch() == null && !mailParms.isEnd2EndTestInProgress()) break;
                    status = this.searchMailSubject(mailParms, mailFolder);
                    break;
                }
                tracker.nextAttempt();
            }
            if (tracker.shouldRetry()) {
                status = this.delayTest(status, interval);
            }
            this.closeStore(mailStore, mailFolder);
        }
        catch (JavaMailerException e) {
            status = PollStatus.down((String)e.getLocalizedMessage());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(Store mailStore, Folder mailFolder) {
        try {
            if (mailFolder != null && mailFolder.isOpen()) {
                mailFolder.close(true);
            }
        }
        catch (MessagingException e) {
        }
        finally {
            try {
                if (mailStore != null && mailStore.isConnected()) {
                    mailStore.close();
                }
            }
            catch (MessagingException e1) {}
        }
    }

    private PollStatus searchMailSubject(MailTransportParameters mailParms, Folder mailFolder) {
        PollStatus status = PollStatus.unknown();
        try {
            String subject = this.computeMatchingSubject(mailParms);
            if (mailFolder.isOpen() && subject != null) {
                Message[] mailMessages = mailFolder.getMessages();
                SubjectTerm searchTerm = new SubjectTerm(subject);
                this.log().debug((Object)("searchMailSubject: searching " + mailMessages.length + " messages for subject: " + subject));
                boolean found = false;
                for (int i = 1; i <= mailMessages.length; ++i) {
                    Message mailMessage = mailFolder.getMessage(i);
                    this.log().debug((Object)("searchMailSubject: retrieved message subject:" + mailMessage.getSubject()));
                    if (found || !mailMessage.match((SearchTerm)searchTerm)) continue;
                    this.log().debug((Object)("searchMailSubject: message with subject: '" + subject + "' found."));
                    if (mailParms.isEnd2EndTestInProgress()) {
                        mailMessage.setFlag(Flags.Flag.DELETED, true);
                        this.log().debug((Object)("searchMailSubject: flagging message: " + subject + " for deletion for end2end test."));
                    }
                    if ((found = true) && !mailParms.getReadTest().isDeleteAllMail()) break;
                    mailMessage.setFlag(Flags.Flag.DELETED, true);
                }
                if (!found) {
                    this.log().debug((Object)("searchMailSubject: message with subject: '" + subject + "' NOT found."));
                    status = PollStatus.down((String)("searchMailSubject: matching test message: '" + subject + "', not found."));
                } else {
                    status = PollStatus.available();
                }
            }
        }
        catch (MessagingException e) {
            return PollStatus.down((String)e.getLocalizedMessage());
        }
        return status;
    }

    private String computeMatchingSubject(MailTransportParameters mailParms) {
        String subject = null;
        subject = mailParms.isEnd2EndTestInProgress() ? mailParms.getComputedTestSubject() : mailParms.getReadTest().getSubjectMatch();
        return subject;
    }

    private void setReadMailProperties(MailTransportParameters mailParms, JavaMailer readMailer) {
        Properties sendMailProps = readMailer.getSession().getProperties();
        String protocol = mailParms.getReadTestProtocol();
        sendMailProps.put("mail." + protocol + ".host", mailParms.getReadTestHost());
        sendMailProps.put("mail." + protocol + ".user", mailParms.getReadTestUserName());
        sendMailProps.put("mail." + protocol + ".port", (Object)mailParms.getReadTestPort());
        sendMailProps.put("mail." + protocol + ".starttls.enable", (Object)mailParms.isReadTestStartTlsEnabled());
        sendMailProps.put("mail.smtp.auth", "true");
        if (mailParms.isReadTestSslEnabled()) {
            sendMailProps.put("mail." + protocol + ".socketFactory.port", (Object)mailParms.getReadTestPort());
            sendMailProps.put("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            sendMailProps.put("mail." + protocol + ".socketFactory.fallback", "false");
        }
        sendMailProps.put("mail." + protocol + ".connectiontimeout", (Object)mailParms.getTimeout());
        sendMailProps.put("mail." + protocol + ".timeout", (Object)mailParms.getTimeout());
        sendMailProps.put("mail.store.protocol", protocol);
    }

    private Folder retrieveMailFolder(MailTransportParameters mailParms, Store mailStore) throws MessagingException {
        mailStore.connect(mailParms.getReadTestHost(), mailParms.getReadTestPort(), mailParms.getReadTestUserName(), mailParms.getReadTestPassword());
        Folder mailFolder = mailStore.getDefaultFolder();
        mailFolder = mailFolder.getFolder(mailParms.getReadTestFolder());
        return mailFolder;
    }

    private PollStatus sendTestMessage(MailTransportParameters mailParms) {
        PollStatus status = PollStatus.unavailable((String)"Test not completed.");
        long interval = mailParms.getSendTestAttemptInterval();
        TimeoutTracker tracker = new TimeoutTracker(mailParms.getParameterMap(), mailParms.getRetries(), mailParms.getTimeout());
        tracker.reset();
        while (tracker.shouldRetry()) {
            tracker.startAttempt();
            this.log().debug((Object)("sendTestMessage: sending mail attempt: " + tracker.getAttempt() + ", elapsed time:" + tracker.elapsedTimeInMillis() + "ms."));
            try {
                JavaMailer sendMailer = this.createMailer(mailParms);
                this.overRideDefaultProperties(mailParms, sendMailer);
                sendMailer.mailSend();
                status = PollStatus.available();
                break;
            }
            catch (JavaMailerException e) {
                status = PollStatus.unavailable((String)e.getLocalizedMessage());
                if (tracker.shouldRetry()) {
                    status = this.delayTest(status, interval);
                }
                tracker.nextAttempt();
            }
        }
        return status;
    }

    private PollStatus delayTest(PollStatus status, long interval) {
        this.log().debug((Object)("delayTest: delaying test for: " + interval + "ms. per configuration."));
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            this.log().error((Object)"delayTest: An exception occurred while delaying mail test: ", (Throwable)e);
            status = PollStatus.unknown((String)e.getLocalizedMessage());
        }
        return status;
    }

    private void overRideDefaultProperties(MailTransportParameters mailParms, JavaMailer sendMailer) {
        sendMailer.setFrom(mailParms.getSendTestFrom());
        sendMailer.getSession().setDebug(mailParms.isSendTestDebug());
        sendMailer.setDebug(mailParms.isSendTestDebug());
        sendMailer.setEncoding(mailParms.getSendTestMessageEncoding());
        sendMailer.setMailer(mailParms.getSendTestMailer());
        sendMailer.setMailHost(mailParms.getSendTestHost());
        sendMailer.setMessageText(mailParms.getSendTestMessageBody());
        sendMailer.setCharSet(mailParms.getSendTestCharSet());
        sendMailer.setContentType(mailParms.getSendTestMessageContentType());
        sendMailer.setSmtpSsl(mailParms.isSendTestIsSslEnable());
        sendMailer.setSubject(mailParms.getComputedTestSubject());
        sendMailer.setTo(mailParms.getSendTestRecipeint());
        sendMailer.setTransport(mailParms.getSendTestTransport());
        sendMailer.setUseJMTA(mailParms.isSendTestUseJmta());
    }

    private JavaMailer createMailer(MailTransportParameters mailParms) throws JavaMailerException {
        JavaMailer sendMailer = new JavaMailer(mailParms.getJavamailProperties());
        String mailPropsPrefix = "mail." + mailParms.getSendTestTransport() + '.';
        Properties props = sendMailer.getSession().getProperties();
        props.setProperty(mailPropsPrefix + "user", mailParms.getSendTestUserName());
        sendMailer.setUser(mailParms.getSendTestUserName());
        sendMailer.setPassword(mailParms.getSendTestPassword());
        props.setProperty(mailPropsPrefix + "host", mailParms.getSendTestHost());
        sendMailer.setMailHost(mailParms.getSendTestHost());
        props.setProperty(mailPropsPrefix + "port", String.valueOf(mailParms.getSendTestPort()));
        sendMailer.setSmtpPort(mailParms.getSendTestPort());
        if (!props.containsKey(mailPropsPrefix + "connectiontimeout")) {
            props.setProperty(mailPropsPrefix + "connectiontimeout", String.valueOf(mailParms.getTimeout()));
        }
        if (!props.containsKey(mailPropsPrefix + "timeout")) {
            props.setProperty(mailPropsPrefix + "timeout", String.valueOf(mailParms.getTimeout()));
        }
        props.setProperty(mailPropsPrefix + "from", mailParms.getSendTestFrom());
        sendMailer.setFrom(mailParms.getSendTestFrom());
        props.setProperty(mailPropsPrefix + "auth", String.valueOf(mailParms.isSendTestUseAuth()));
        sendMailer.setAuthenticate(mailParms.isSendTestUseAuth());
        props.setProperty(mailPropsPrefix + "quitwait", String.valueOf(mailParms.isSendTestIsQuitWait()));
        sendMailer.setQuitWait(mailParms.isSendTestIsQuitWait());
        if (mailParms.isSendTestIsSslEnable()) {
            if (!props.containsKey(mailPropsPrefix + "socketFactory.class")) {
                props.setProperty(mailPropsPrefix + "socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.setProperty(mailPropsPrefix + "socketFactory.port", String.valueOf(mailParms.getSendTestPort()));
            sendMailer.setSmtpPort(mailParms.getSendTestPort());
        }
        sendMailer.setSmtpSsl(mailParms.isSendTestIsSslEnable());
        props.setProperty(mailPropsPrefix + "starttls.enable", String.valueOf(mailParms.isSendTestStartTls()));
        sendMailer.setStartTlsEnabled(mailParms.isSendTestStartTls());
        sendMailer.setSession(Session.getInstance((Properties)props, (Authenticator)sendMailer.createAuthenticator()));
        return sendMailer;
    }
}

