/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.pollables.PendingPollEvent;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.xml.event.Event;

public class DefaultPollContext
implements PollContext,
EventListener {
    private Poller m_poller;
    private boolean m_listenerAdded = false;
    private List m_pendingPollEvents = new LinkedList();

    public DefaultPollContext(Poller poller) {
        this.m_poller = poller;
    }

    public String getCriticalServiceName() {
        return this.m_poller.getPollerConfig().getCriticalService();
    }

    public boolean isNodeProcessingEnabled() {
        return this.m_poller.getPollerConfig().nodeOutageProcessingEnabled();
    }

    public boolean isPollingAllIfCritServiceUndefined() {
        return this.m_poller.getPollerConfig().pollAllIfNoCriticalServiceDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollEvent sendEvent(Event event) {
        if (!this.m_listenerAdded) {
            this.m_poller.getEventManager().addEventListener(this);
            this.m_listenerAdded = true;
        }
        PendingPollEvent pollEvent = new PendingPollEvent(event);
        List list = this.m_pendingPollEvents;
        synchronized (list) {
            this.m_pendingPollEvents.add(pollEvent);
        }
        ThreadCategory.getInstance(this.getClass()).info((Object)("Sending " + event.getUei() + " for element " + event.getNodeid() + ":" + event.getInterface() + ":" + event.getService()));
        this.m_poller.getEventManager().sendNow(event);
        return pollEvent;
    }

    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        return this.m_poller.createEvent(uei, nodeId, address, svcName, date, reason);
    }

    public void openOutage(PollableService svc, final PollEvent svcLostEvent) {
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            public void run() {
                DefaultPollContext.this.m_poller.getQueryMgr().openOutage(DefaultPollContext.this.m_poller.getPollerConfig().getNextOutageIdSql(), nodeId, ipAddr, svcName, svcLostEvent.getEventId(), EventConstants.formatToString(svcLostEvent.getDate()));
            }
        };
        if (svcLostEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcLostEvent).addPending(r);
        } else {
            r.run();
        }
    }

    public void resolveOutage(PollableService svc, final PollEvent svcRegainEvent) {
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            public void run() {
                DefaultPollContext.this.m_poller.getQueryMgr().resolveOutage(nodeId, ipAddr, svcName, svcRegainEvent.getEventId(), EventConstants.formatToString(svcRegainEvent.getDate()));
            }
        };
        if (svcRegainEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcRegainEvent).addPending(r);
        } else {
            r.run();
        }
    }

    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        this.m_poller.getQueryMgr().reparentOutages(ipAddr, oldNodeId, newNodeId);
    }

    public boolean isServiceUnresponsiveEnabled() {
        return this.m_poller.getPollerConfig().serviceUnresponsiveEnabled();
    }

    public String getName() {
        return this.m_poller.getName() + ".DefaultPollContext";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event e) {
        List list = this.m_pendingPollEvents;
        synchronized (list) {
            for (PendingPollEvent pollEvent : this.m_pendingPollEvents) {
                if (!e.equals(pollEvent.getEvent())) continue;
                pollEvent.complete(e);
            }
            Iterator it = this.m_pendingPollEvents.iterator();
            while (it.hasNext()) {
                PendingPollEvent pollEvent;
                pollEvent = (PendingPollEvent)it.next();
                if (pollEvent.isPending()) continue;
                pollEvent.processPending();
                it.remove();
            }
        }
    }
}

