/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.notificationCommands.Argument;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.notifd.ClassExecutor;
import org.opennms.netmgt.notifd.CommandExecutor;
import org.opennms.netmgt.notifd.ExecutorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationTask
extends Thread {
    private User m_user;
    private String m_autoNotify;
    private int m_notifyId;
    private Command[] m_commands;
    private Map<String, String> m_params;
    private long m_sendTime;
    private boolean m_started = false;
    private NotificationManager m_notificationManager;
    private UserManager m_userManager;

    public NotificationTask(NotificationManager notificationManager, UserManager userManager, long sendTime, Map<String, String> someParams, List siblings, String autoNotify) {
        this.m_notificationManager = notificationManager;
        this.m_userManager = userManager;
        this.m_sendTime = sendTime;
        this.m_params = new HashMap<String, String>(someParams);
        this.m_autoNotify = autoNotify;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("Send ");
        for (Command command : this.m_commands) {
            buffer.append(command.getName() + "/");
        }
        buffer.append(" to " + this.m_user.getUserId() + " at " + new Date(this.m_sendTime));
        return buffer.toString();
    }

    public long getSendTime() {
        return this.m_sendTime;
    }

    public int getNotifyId() {
        return this.m_notifyId;
    }

    public void setUser(User aUser) {
        this.m_user = aUser;
    }

    public User getUser() {
        return this.m_user;
    }

    public void setAutoNotify(String autoNotify) {
        this.m_autoNotify = autoNotify;
    }

    public void setNoticeId(int anId) {
        this.m_notifyId = anId;
    }

    public void setCommands(Command[] commands) {
        this.m_commands = commands;
    }

    public Command[] getCommands() {
        return (Command[])this.m_commands.clone();
    }

    @Override
    public void run() {
        block14: {
            boolean outstanding = false;
            try {
                outstanding = this.getNotificationManager().noticeOutstanding(this.m_notifyId);
            }
            catch (Exception e) {
                this.log().error((Object)("Unable to get response status on notice #" + this.m_notifyId), (Throwable)e);
            }
            if (outstanding) {
                try {
                    if (this.getUserManager().isUserOnDuty(this.m_user.getUserId(), Calendar.getInstance())) {
                        ExecutorStrategy command = null;
                        String cntct = "";
                        for (int i = 0; i < this.m_commands.length; ++i) {
                            cntct = this.getContactInfo(this.m_commands[i].getName());
                            try {
                                this.getNotificationManager().updateNoticeWithUserInfo(this.m_user.getUserId(), this.m_notifyId, this.m_commands[i].getName(), cntct, this.m_autoNotify);
                            }
                            catch (Exception e) {
                                this.log().error((Object)"Could not insert notice info into database, aborting send notice", (Throwable)e);
                                continue;
                            }
                            String binaryCommand = this.m_commands[i].getBinary();
                            if (binaryCommand == null) {
                                this.log().error((Object)("binary flag not set for command: " + this.m_commands[i].getExecute() + ".  Guessing false."));
                                binaryCommand = "false";
                            }
                            command = binaryCommand.equals("true") ? new CommandExecutor() : new ClassExecutor();
                            if (this.log().isDebugEnabled()) {
                                this.log().debug((Object)("Class created is: " + command.getClass()));
                            }
                            int returnCode = command.execute(this.m_commands[i].getExecute(), this.getArgumentList(this.m_commands[i]));
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("command " + this.m_commands[i].getName() + " return code = " + returnCode));
                        }
                        break block14;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("User " + this.m_user.getUserId() + " is not on duty, skipping"));
                    }
                }
                catch (IOException e) {
                    this.log().warn((Object)"Could not get user duty schedule information: ", (Throwable)e);
                }
                catch (MarshalException e) {
                    this.log().warn((Object)"Could not get user duty schedule information: ", (Throwable)e);
                }
                catch (ValidationException e) {
                    this.log().warn((Object)"Could not get user duty schedule information: ", (Throwable)e);
                }
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    private UserManager getUserManager() {
        return this.m_userManager;
    }

    private String getContactInfo(String cmdName) throws IOException, MarshalException, ValidationException {
        return this.getUserManager().getContactInfo(this.m_user, cmdName);
    }

    private List<org.opennms.core.utils.Argument> getArgumentList(Command command) {
        List<Argument> notifArgs = this.getArgumentsForCommand(command);
        ArrayList<org.opennms.core.utils.Argument> commandArgs = new ArrayList<org.opennms.core.utils.Argument>();
        for (Argument curArg : notifArgs) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("argument: " + curArg.getSwitch() + " " + curArg.getSubstitution() + " '" + this.getArgumentValue(curArg.getSwitch()) + "' " + Boolean.valueOf(curArg.getStreamed())));
            }
            commandArgs.add(new org.opennms.core.utils.Argument(curArg.getSwitch(), curArg.getSubstitution(), this.getArgumentValue(curArg.getSwitch()), Boolean.valueOf(curArg.getStreamed()).booleanValue()));
        }
        return commandArgs;
    }

    private List<Argument> getArgumentsForCommand(Command command) {
        return command.getArgumentCollection();
    }

    private String getArgumentValue(String aSwitch) {
        String value = "";
        try {
            if ("-d".equals(aSwitch)) {
                value = this.m_user.getUserId();
            } else if ("-email".equals(aSwitch)) {
                value = this.getEmail();
            } else if ("-pemail".equals(aSwitch)) {
                value = this.getUserManager().getPagerEmail(this.m_user.getUserId());
            } else if ("-xmpp".equals(aSwitch)) {
                value = this.getUserManager().getXMPPAddress(this.m_user.getUserId());
            } else if ("-tp".equals(aSwitch)) {
                value = this.getUserManager().getTextPin(this.m_user.getUserId());
            } else if ("-np".equals(aSwitch)) {
                value = this.getUserManager().getNumericPin(this.m_user.getUserId());
            } else if (this.m_params.containsKey(aSwitch)) {
                value = this.m_params.get(aSwitch);
            }
        }
        catch (Exception e) {
            this.log().error((Object)("unable to get value for parameter " + aSwitch));
        }
        return value;
    }

    public String getEmail() throws IOException, MarshalException, ValidationException {
        return this.getContactInfo("email");
    }

    @Override
    public synchronized void start() {
        this.m_started = true;
        super.start();
    }

    public boolean isStarted() {
        return this.m_started;
    }
}

