/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.snmp.VlanCollectorEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class CiscoVlanTableEntry
extends SnmpTableEntry
implements VlanCollectorEntry {
    public static final String VLAN_MTU = "vtpVlanMtu";
    public static final String VLAN_D10S = "vtpVlanDot10Said";
    public static final String VLAN_RINGN = "vtpVlanRingNumber";
    public static final String VLAN_BRIDGEN = "vtpVlanBridgeNumber";
    public static final String VLAN_STPTYPE = "vtpVlanStpType";
    public static final String VLAN_PARV = "vtpVlanParentVlan";
    public static final String VLAN_TRV1 = "vtpVlanTranslationalVlan1";
    public static final String VLAN_TRV2 = "vtpVlanTranslationalVlan2";
    public static final String VLAN_BRIDGETYPE = "vtpVlanBridgeType";
    public static final String VLAN_AREHC = "vtpVlanAreHopCount";
    public static final String VLAN_STEHC = "vtpVlanSteHopCount";
    public static final String VLAN_ISCRFBACHUP = "vtpVlanIsCRFBackup";
    public static final String VLAN_TYPEEXT = "vtpVlanTypeExt";
    public static final String VLAN_IFINDEX = "vtpVlanIfIndex";
    private static String VLAN_INDEX_OID = ".1.3.6.1.4.1.9.9.46.1.3.1.1.1";
    private static String VLAN_NAME_OID = ".1.3.6.1.4.1.9.9.46.1.3.1.1.4";
    private boolean hasVlanIndex = false;
    public static NamedSnmpVar[] ciscoVlan_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.4.1.9.9.46.1.3.1.1";

    public CiscoVlanTableEntry() {
        super(ciscoVlan_elemList);
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (!this.hasVlanIndex) {
            int vlanid = inst.getLastSubId();
            super.storeResult(SnmpObjId.get((String)VLAN_INDEX_OID), inst, SnmpUtils.getValueFactory().getInt32(vlanid));
            super.storeResult(SnmpObjId.get((String)VLAN_NAME_OID), inst, SnmpUtils.getValueFactory().getOctetString("default".getBytes()));
            this.hasVlanIndex = true;
        }
        super.storeResult(base, inst, val);
    }

    static {
        ciscoVlan_elemList = new NamedSnmpVar[18];
        int ndx = 0;
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanIndex", VLAN_INDEX_OID, 1);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanStatus", ".1.3.6.1.4.1.9.9.46.1.3.1.1.2", 2);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanType", ".1.3.6.1.4.1.9.9.46.1.3.1.1.3", 3);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "vtpVlanName", ".1.3.6.1.4.1.9.9.46.1.3.1.1.4", 4);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_MTU, ".1.3.6.1.4.1.9.9.46.1.3.1.1.5", 5);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_D10S, ".1.3.6.1.4.1.9.9.46.1.3.1.1.6", 6);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_RINGN, ".1.3.6.1.4.1.9.9.46.1.3.1.1.7", 7);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_BRIDGEN, ".1.3.6.1.4.1.9.9.46.1.3.1.1.8", 8);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_STPTYPE, ".1.3.6.1.4.1.9.9.46.1.3.1.1.9", 9);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_PARV, ".1.3.6.1.4.1.9.9.46.1.3.1.1.10", 10);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_TRV1, ".1.3.6.1.4.1.9.9.46.1.3.1.1.11", 11);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_TRV2, ".1.3.6.1.4.1.9.9.46.1.3.1.1.12", 12);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_BRIDGETYPE, ".1.3.6.1.4.1.9.9.46.1.3.1.1.13", 13);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_AREHC, ".1.3.6.1.4.1.9.9.46.1.3.1.1.14", 14);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_STEHC, ".1.3.6.1.4.1.9.9.46.1.3.1.1.15", 15);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_ISCRFBACHUP, ".1.3.6.1.4.1.9.9.46.1.3.1.1.16", 16);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_TYPEEXT, ".1.3.6.1.4.1.9.9.46.1.3.1.1.17", 17);
        CiscoVlanTableEntry.ciscoVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_IFINDEX, ".1.3.6.1.4.1.9.9.46.1.3.1.1.18", 18);
    }
}

