/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.LinkdEventProcessor;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linkd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Linkd";
    private static Linkd m_singleton;
    private Scheduler m_scheduler;
    private LinkdEventProcessor m_eventListener;
    private QueryManager m_queryMgr;
    private LinkdConfig m_linkdConfig;
    private List<LinkableNode> nodes;
    private List<String> activepackages;
    private List<String> newSuspenctEventsIpAddr = null;

    public Linkd() {
        super(LOG4J_CATEGORY);
    }

    public static Linkd getInstance() {
        return m_singleton;
    }

    @Override
    public Category log() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return ThreadCategory.getInstance();
    }

    @Override
    protected void onInit() {
        Assert.state((this.m_queryMgr != null ? 1 : 0) != 0, (String)"must set the queryManager property");
        Assert.state((this.m_linkdConfig != null ? 1 : 0) != 0, (String)"must set the linkdConfig property");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"must set the scheduler property");
        Assert.state((this.m_eventListener != null ? 1 : 0) != 0, (String)"must be set the event receiver");
        if (this.log().isInfoEnabled()) {
            this.log().info((Object)("init: Category Level Set to " + this.log().getLevel().toString()));
        }
        this.nodes = new ArrayList<LinkableNode>();
        this.activepackages = new ArrayList<String>();
        this.newSuspenctEventsIpAddr = new ArrayList<String>();
        this.newSuspenctEventsIpAddr.add("127.0.0.1");
        this.newSuspenctEventsIpAddr.add("0.0.0.0");
        try {
            this.nodes = this.m_queryMgr.getSnmpNodeList();
            this.m_queryMgr.updateDeletedNodes();
        }
        catch (SQLException e) {
            this.log().fatal((Object)"SQL exception executing on database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        this.scheduleCollection();
        m_singleton = this;
        if (this.log().isInfoEnabled()) {
            this.log().info((Object)"init: LINKD CONFIGURATION INITIALIZED");
        }
    }

    private void scheduleCollection() {
        Iterator<LinkableNode> ite = this.nodes.iterator();
        while (ite.hasNext()) {
            this.scheduleCollectionForNode(ite.next());
        }
    }

    private void scheduleCollectionForNode(LinkableNode node) {
        List<SnmpCollection> snmpcollOnNode = this.m_linkdConfig.getSnmpCollections(node.getSnmpPrimaryIpAddr(), node.getSysoid());
        for (SnmpCollection snmpcoll : snmpcollOnNode) {
            if (this.activepackages.contains(snmpcoll.getPackageName())) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("ScheduleCollectionForNode: package active: " + snmpcoll.getPackageName()));
                }
            } else {
                DiscoveryLink discovery;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("ScheduleCollectionForNode: Schedulink Discovery Link for Active Package: " + snmpcoll.getPackageName()));
                }
                if ((discovery = this.m_linkdConfig.getDiscoveryLink(snmpcoll.getPackageName())).getScheduler() == null) {
                    discovery.setScheduler(this.m_scheduler);
                }
                discovery.schedule();
                this.activepackages.add(snmpcoll.getPackageName());
            }
            if (snmpcoll.getScheduler() == null) {
                snmpcoll.setScheduler(this.m_scheduler);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("ScheduleCollectionForNode: Schedulink Snmp Collection for Package/Nodeid: " + snmpcoll.getPackageName() + "/" + node.getNodeId() + "/" + snmpcoll.getInfo()));
            }
            snmpcoll.schedule();
        }
    }

    @Override
    public synchronized void onStart() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Starting linkd scheduler");
        }
        this.m_scheduler.start();
    }

    @Override
    public synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_eventListener.close();
        this.m_scheduler = null;
    }

    @Override
    public synchronized void onPause() {
        this.m_scheduler.pause();
    }

    @Override
    public synchronized void onResume() {
        this.m_scheduler.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableNode> getLinkableNodes() {
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            return this.nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableNode> getLinkableNodesOnPackage(String pkg) {
        ArrayList<LinkableNode> nodesOnPkg = new ArrayList<LinkableNode>();
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            for (LinkableNode node : this.nodes) {
                if (!this.isInterfaceInPackage(node.getSnmpPrimaryIpAddr(), pkg)) continue;
                nodesOnPkg.add(node);
            }
            return nodesOnPkg;
        }
    }

    public boolean isInterfaceInPackage(String ipaddr, String pkg) {
        return this.m_linkdConfig.interfaceInPackage(ipaddr, this.m_linkdConfig.getPackage(pkg));
    }

    public boolean isInterfaceInPackageRange(String ipaddr, String pkg) {
        return this.m_linkdConfig.interfaceInPackageRange(ipaddr, this.m_linkdConfig.getPackage(pkg));
    }

    void scheduleNodeCollection(int nodeid) {
        LinkableNode node = null;
        this.m_linkdConfig.createPackageIpListMap();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("scheduleNodeCollection: Loading node " + nodeid + " from database"));
        }
        try {
            node = this.m_queryMgr.getSnmpNode(nodeid);
            if (node == null) {
                this.log().warn((Object)"scheduleNodeCollection: Failed to get Linkable node from DataBase. Exiting");
                return;
            }
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"scheduleNodeCollection: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            return;
        }
        this.nodes.add(node);
        this.scheduleCollectionForNode(node);
    }

    void wakeUpNodeCollection(int nodeid) {
        LinkableNode node = this.getNode(nodeid);
        if (node == null) {
            this.log().warn((Object)("wakeUpNodeCollection: schedulink a node not found: " + nodeid));
            this.scheduleNodeCollection(nodeid);
        } else {
            Iterator<SnmpCollection> ite = this.m_linkdConfig.getSnmpCollections(node.getSnmpPrimaryIpAddr(), node.getSysoid()).iterator();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"wakeUpNodeCollection: get Snmp Collection from Scratch! Iterating on found.");
            }
            while (ite.hasNext()) {
                ReadyRunnable rr = this.getReadyRunnable(ite.next());
                if (rr == null) {
                    this.log().warn((Object)"wakeUpNodeCollection: found null ReadyRunnable");
                    return;
                }
                rr.wakeUp();
            }
        }
    }

    void deleteNode(int nodeid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("deleteNode: deleting LinkableNode for node " + nodeid));
        }
        try {
            this.m_queryMgr.update(nodeid, 'D');
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"scheduleNodeCollection: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
        }
        LinkableNode node = this.removeNode(nodeid);
        if (node == null) {
            this.log().warn((Object)("deleteNode: node not found: " + nodeid));
        } else {
            Iterator<SnmpCollection> ite = this.m_linkdConfig.getSnmpCollections(node.getSnmpPrimaryIpAddr(), node.getSysoid()).iterator();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"deleteNode: get Snmp Collection from Scratch! Iterating on found.");
            }
            while (ite.hasNext()) {
                ReadyRunnable rr = this.getReadyRunnable(ite.next());
                if (rr == null) {
                    this.log().warn((Object)"deleteNode: found null ReadyRunnable");
                    return;
                }
                rr.unschedule();
            }
        }
        this.m_linkdConfig.createPackageIpListMap();
    }

    void suspendNodeCollection(int nodeid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("suspendNodeCollection: suspend collection LinkableNode for node " + nodeid));
        }
        try {
            this.m_queryMgr.update(nodeid, 'N');
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"suspendNodeCollection: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
        }
        LinkableNode node = this.getNode(nodeid);
        if (node == null) {
            this.log().warn((Object)"suspendNodeCollection: found null ReadyRunnable");
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"suspendNodeCollection: get Snmp Collection from Scratch! Iterating on found.");
            }
            Iterator<SnmpCollection> ite = this.m_linkdConfig.getSnmpCollections(node.getSnmpPrimaryIpAddr(), node.getSysoid()).iterator();
            while (ite.hasNext()) {
                ReadyRunnable rr = this.getReadyRunnable(ite.next());
                if (rr == null) {
                    this.log().warn((Object)("suspendNodeCollection: suspend: node not found: " + nodeid));
                    return;
                }
                rr.suspend();
            }
        }
    }

    private ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getReadyRunnable: get ReadyRunnable from scheduler: " + runnable.getInfo()));
        }
        return this.m_scheduler.getReadyRunnable(runnable);
    }

    void updateNodeSnmpCollection(SnmpCollection snmpcoll) {
        LinkableNode node = this.removeNode(snmpcoll.getTarget().getHostAddress());
        if (node == null) {
            this.log().error((Object)("No node found for snmp collection: " + snmpcoll.getInfo() + " unscheduling!"));
            this.m_scheduler.unschedule(snmpcoll);
            return;
        }
        try {
            node = this.m_queryMgr.storeSnmpCollection(node, snmpcoll);
        }
        catch (SQLException e) {
            this.log().error((Object)("Failed to save on db snmpcollection/package: " + snmpcoll.getPackageName() + "/" + snmpcoll.getInfo() + " " + e));
            return;
        }
        this.nodes.add(node);
    }

    void updateDiscoveryLinkCollection(DiscoveryLink discover) {
        try {
            this.m_queryMgr.storeDiscoveryLink(discover);
        }
        catch (SQLException e) {
            this.log().error((Object)("Failed to save discoverylink on database for package:" + discover.getPackageName()));
        }
    }

    void sendNewSuspectEvent(String ipaddress, String ipowner, String pkgName) {
        if (this.newSuspenctEventsIpAddr.contains(ipaddress)) {
            this.log().info((Object)("sendNewSuspectEvent: nothing to send suspect event previously sent for ip address: " + ipaddress));
            return;
        }
        if (!this.isInterfaceInPackageRange(ipaddress, pkgName)) {
            this.log().info((Object)("sendNewSuspectEvent: nothing to send for ip address: " + ipaddress + " not in package: " + pkgName));
            return;
        }
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        boolean autodiscovery = false;
        autodiscovery = pkg.hasAutoDiscovery() ? pkg.getAutoDiscovery() : this.m_linkdConfig.autoDiscovery();
        if (autodiscovery) {
            Event event = new Event();
            event.setSource("linkd");
            event.setUei("uei.opennms.org/internal/discovery/newSuspect");
            event.setHost(ipowner);
            event.setInterface(ipaddress);
            event.setTime(EventConstants.formatToString(new Date()));
            this.m_eventListener.getEventMgr().sendNow(event);
            this.newSuspenctEventsIpAddr.add(ipaddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkableNode getNode(int nodeid) {
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            for (LinkableNode node : this.nodes) {
                if (node.getNodeId() != nodeid) continue;
                return node;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkableNode getNode(String ipaddr) {
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            for (LinkableNode node : this.nodes) {
                if (!node.getSnmpPrimaryIpAddr().equals(ipaddr)) continue;
                return node;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableNode removeNode(int nodeid) {
        ArrayList<LinkableNode> nodeses = new ArrayList<LinkableNode>();
        LinkableNode node = null;
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            for (LinkableNode curNode : this.nodes) {
                if (curNode.getNodeId() == nodeid) {
                    node = curNode;
                    continue;
                }
                nodeses.add(curNode);
            }
            this.nodes = nodeses;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableNode removeNode(String ipaddr) {
        ArrayList<LinkableNode> nodeses = new ArrayList<LinkableNode>();
        LinkableNode node = null;
        if (this.nodes == null) {
            this.log().debug((Object)"removeNode: nodes is null");
            return null;
        }
        List<LinkableNode> list = this.nodes;
        synchronized (list) {
            for (LinkableNode curNode : this.nodes) {
                if (curNode.getSnmpPrimaryIpAddr().equals(ipaddr)) {
                    node = curNode;
                    continue;
                }
                nodeses.add(curNode);
            }
            this.nodes = nodeses;
        }
        return node;
    }

    public void setQueryManager(QueryManager queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public LinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(LinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public LinkdEventProcessor getEventListener() {
        return this.m_eventListener;
    }

    public void setEventListener(LinkdEventProcessor eventListener) {
        this.m_eventListener = eventListener;
    }
}

