/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TcpServer
implements Runnable {
    static final int TCP_PORT = 5817;
    static final String DEFAULT_IP_ADDRESS = "127.0.0.1";
    private int m_tcpPort;
    private ServerSocket m_tcpSock;
    private volatile boolean m_stop;
    private LinkedList<TcpStreamHandler> m_receivers;
    private Thread m_context;
    private Fiber m_parent;
    private List<EventHandler> m_handlers;
    private String m_logPrefix;
    private int m_recsPerConn;
    private InetAddress m_ipAddress;

    public TcpServer(Fiber parent, List<EventHandler> handlers) throws IOException {
        this(parent, handlers, 5817, InetAddress.getByName(DEFAULT_IP_ADDRESS));
    }

    public TcpServer(Fiber parent, List<EventHandler> handlers, int port, InetAddress address) throws IOException {
        this.m_parent = parent;
        this.m_tcpPort = port;
        this.m_ipAddress = address;
        this.m_receivers = new LinkedList();
        this.m_stop = false;
        this.m_context = null;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
        this.m_recsPerConn = -1;
        try {
            this.m_tcpSock = new ServerSocket(this.m_tcpPort, 0, this.m_ipAddress);
        }
        catch (IOException e) {
            IOException n = new IOException("Could not create listening TCP socket on " + this.m_ipAddress + ":" + this.m_tcpPort + ": " + e);
            n.initCause(e);
            throw n;
        }
    }

    public void stop() throws InterruptedException {
        this.log().debug((Object)"stop method invoked");
        this.m_stop = true;
        if (this.m_context != null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Interrupting and joining context thread " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Thread context stopped and joined " + this.m_context.getName()));
            }
            this.m_context = null;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Attempting to stop and join all stream handlers");
            this.log().debug((Object)("There are " + this.m_receivers.size() + " receivers"));
        }
        int ndx = 0;
        Iterator i = this.m_receivers.iterator();
        while (i.hasNext()) {
            TcpStreamHandler t = (TcpStreamHandler)i.next();
            if (t.isAlive()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Calling stop on handler index " + ndx));
                }
                t.stop();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Stopped handler index " + ndx));
                }
            }
            ++ndx;
            i.remove();
        }
        this.log().debug((Object)"All TCP Handlers are stopped and removed");
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = this.m_context = Thread.currentThread();
        synchronized (thread) {
            this.m_context.notifyAll();
        }
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            this.log().debug((Object)"Stop flag set on thread startup");
            try {
                if (this.m_tcpSock != null) {
                    this.m_tcpSock.close();
                }
                this.log().debug((Object)"The socket has been closed");
            }
            catch (Exception e) {
                this.log().warn((Object)("An exception occured closing the socket: " + e), (Throwable)e);
            }
            this.log().debug((Object)"Thread exiting");
            return;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Server connection processor started on " + this.m_ipAddress + ":" + this.m_tcpPort));
        }
        try {
            this.m_tcpSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            if (!this.m_stop) {
                this.log().warn((Object)("An I/O exception occured setting the socket timeout: " + e), (Throwable)e);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Thread exiting due to socket error: " + e), (Throwable)e);
            }
            return;
        }
        boolean ioInterrupted = false;
        while (this.m_parent.getStatus() != 4 && this.m_parent.getStatus() != 3 && !this.m_stop) {
            try {
                Thread processor;
                if (this.log().isDebugEnabled() && !ioInterrupted) {
                    this.log().debug((Object)"Waiting for new connection");
                }
                Socket newbie = this.m_tcpSock.accept();
                ioInterrupted = false;
                StringBuffer connection = new StringBuffer(newbie.getInetAddress().getHostAddress());
                connection.append(":").append(newbie.getPort());
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("New connection accepted from " + connection));
                }
                TcpStreamHandler handler = new TcpStreamHandler(this.m_parent, newbie, this.m_handlers, this.m_recsPerConn);
                Thread thread2 = processor = new Thread((Runnable)handler, this.m_parent.getName() + "[" + connection + "]");
                synchronized (thread2) {
                    processor.start();
                    try {
                        processor.wait();
                    }
                    catch (InterruptedException e) {
                        this.log().warn((Object)("The thread was interrupted: " + e), (Throwable)e);
                    }
                }
                this.log().debug((Object)"A new stream handler thread has been started");
                this.m_receivers.add(handler);
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (IOException e) {
                this.log().error((Object)("Server Socket I/O Error: " + e), (Throwable)e);
                break;
            }
            Iterator i = this.m_receivers.iterator();
            while (i.hasNext()) {
                TcpStreamHandler t = (TcpStreamHandler)i.next();
                if (t.isAlive()) continue;
                i.remove();
            }
        }
        try {
            this.log().debug((Object)"closing the server socket connection");
            this.m_tcpSock.close();
        }
        catch (Throwable t) {
            this.log().error((Object)("An I/O Error Occcured Closing the Server Socket: " + t), t);
        }
        this.log().debug((Object)"TCP Server Shutdown");
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    public void setEventsPerConnection(int number) {
        this.m_recsPerConn = number;
    }
}

