/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.config.users.Userinfo;
import org.opennms.netmgt.config.users.Users;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserManager {
    protected GroupManager m_groupManager;
    protected HashMap<String, User> m_users;
    protected HashMap<String, List<DutySchedule>> m_dutySchedules;
    private Header oldHeader;

    protected UserManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    public void parseXML(Reader reader) throws MarshalException, ValidationException {
        Userinfo userinfo = (Userinfo)Unmarshaller.unmarshal(Userinfo.class, (Reader)reader);
        Users users = userinfo.getUsers();
        this.oldHeader = userinfo.getHeader();
        List usersList = users.getUserCollection();
        this.m_users = new HashMap();
        for (User curUser : usersList) {
            this.m_users.put(curUser.getUserId(), curUser);
        }
        this.buildDutySchedules(this.m_users);
    }

    public synchronized void saveUser(String name, User details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("UserFactory:saveUser  null");
        }
        this.m_users.put(name, details);
        this.saveCurrent();
    }

    private void buildDutySchedules(Map<String, User> users) {
        this.m_dutySchedules = new HashMap();
        for (String key : users.keySet()) {
            User curUser = users.get(key);
            if (curUser.getDutyScheduleCount() <= 0) continue;
            ArrayList<DutySchedule> dutyList = new ArrayList<DutySchedule>();
            for (String duty : curUser.getDutyScheduleCollection()) {
                dutyList.add(new DutySchedule(duty));
            }
            this.m_dutySchedules.put(key, dutyList);
        }
    }

    public boolean isUserOnDuty(String user, Calendar time) throws IOException, MarshalException, ValidationException {
        this.update();
        if (!this.m_dutySchedules.containsKey(user)) {
            return true;
        }
        for (DutySchedule curSchedule : this.m_dutySchedules.get(user)) {
            if (!curSchedule.isInSchedule(time)) continue;
            return true;
        }
        return false;
    }

    public Map<String, User> getUsers() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_users;
    }

    public boolean hasUser(String userName) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_users.containsKey(userName);
    }

    public List<String> getUserNames() throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<String> userNames = new ArrayList<String>();
        for (String key : this.m_users.keySet()) {
            userNames.add(key);
        }
        return userNames;
    }

    public User getUser(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_users.get(name);
    }

    public String getContactInfo(String userID, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        User user = this.m_users.get(userID);
        return this.getContactInfo(user, command);
    }

    public String getContactInfo(User user, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals(command)) continue;
            return contact.getInfo();
        }
        return "";
    }

    public String getContactServiceProvider(String userID, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        User user = this.m_users.get(userID);
        return this.getContactServiceProvider(user, command);
    }

    public String getContactServiceProvider(User user, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals(command)) continue;
            return contact.getServiceProvider();
        }
        return "";
    }

    public String getEmail(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, "email");
    }

    public String getPagerEmail(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, "pagerEmail");
    }

    public String getNumericPin(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, "numericPage");
    }

    public String getXMPPAddress(String userID) throws IOException, MarshalException, ValidationException {
        this.update();
        User user = this.m_users.get(userID);
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals("xmppAddress")) continue;
            return contact.getInfo();
        }
        return "";
    }

    public String getNumericPage(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(userID, "numericPage");
    }

    public String getTextPin(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, "textPage");
    }

    public String getTextPage(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(userID, "textPage");
    }

    public synchronized void saveUsers(Collection<User> usersList) throws Exception {
        this.m_users.clear();
        for (User curUser : usersList) {
            this.m_users.put(curUser.getUserId(), curUser);
        }
    }

    public synchronized void deleteUser(String name) throws Exception {
        if (!this.m_users.containsKey(name)) {
            throw new Exception("UserFactory:delete The old user name " + name + " is not found");
        }
        this.m_users.remove(name);
        this.m_groupManager.deleteUser(name);
        this.saveCurrent();
    }

    private synchronized void saveCurrent() throws Exception {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString(new Date()));
        Users users = new Users();
        Collection<User> collUsers = this.m_users.values();
        Iterator<User> iter = collUsers.iterator();
        while (iter != null && iter.hasNext()) {
            User tmpUser = iter.next();
            users.addUser(tmpUser);
        }
        Userinfo userinfo = new Userinfo();
        userinfo.setUsers(users);
        userinfo.setHeader(header);
        this.oldHeader = header;
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)userinfo, (Writer)stringWriter);
        String writerString = stringWriter.toString();
        this.saveXML(writerString);
    }

    protected abstract void saveXML(String var1) throws IOException;

    public synchronized void renameUser(String oldName, String newName) throws Exception {
        User data;
        if (this.m_users.containsKey(oldName)) {
            data = this.m_users.get(oldName);
            if (data == null) {
                this.m_users.remove(oldName);
                throw new Exception("UserFactory:rename the data contained for old user " + oldName + " is null");
            }
        } else {
            throw new Exception("UserFactory:rename the old user name " + oldName + " is not found");
        }
        this.m_users.remove(oldName);
        data.setUserId(newName);
        this.m_users.put(newName, data);
        this.m_groupManager.renameUser(oldName, newName);
        this.saveCurrent();
    }

    public void setEncryptedPassword(String userID, String aPassword) throws Exception {
        User user = this.m_users.get(userID);
        if (user != null) {
            user.setPassword(aPassword);
        }
        this.saveCurrent();
    }

    public void setUnencryptedPassword(String userID, String aPassword) throws Exception {
        User user = this.m_users.get(userID);
        if (user != null) {
            user.setPassword(this.encryptedPassword(aPassword));
        }
        this.saveCurrent();
    }

    public String encryptedPassword(String aPassword) {
        String encryptedPassword = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            encryptedPassword = this.hexToString(digest.digest(aPassword.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.toString());
        }
        return encryptedPassword;
    }

    private String hexToString(byte[] data) {
        char[] hexadecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (data.length % 2 != 0) {
            return null;
        }
        char[] buffer = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int low = data[i] & 0xF;
            int high = (data[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimals[high];
            buffer[i * 2 + 1] = hexadecimals[low];
        }
        return new String(buffer);
    }

    public boolean comparePasswords(String userID, String aPassword) {
        User user = this.m_users.get(userID);
        if (user == null) {
            return false;
        }
        return user.getPassword().equals(this.encryptedPassword(aPassword));
    }

    protected abstract void update() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    public String[] getUsersWithRole(String roleid) throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<String> usersWithRole = new ArrayList<String>();
        for (User user : this.m_users.values()) {
            if (!this.userHasRole(user, roleid)) continue;
            usersWithRole.add(user.getUserId());
        }
        return usersWithRole.toArray(new String[usersWithRole.size()]);
    }

    public boolean userHasRole(User user, String roleid) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        this.update();
        if (roleid == null) {
            throw new NullPointerException("roleid is null");
        }
        return this.m_groupManager.userHasRole(user.getUserId(), roleid);
    }

    public boolean isUserScheduledForRole(User user, String roleid, Date time) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        this.update();
        if (roleid == null) {
            throw new NullPointerException("roleid is null");
        }
        return this.m_groupManager.isUserScheduledForRole(user.getUserId(), roleid, time);
    }

    public String[] getUsersScheduledForRole(String roleid, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        ArrayList<String> usersScheduledForRole = new ArrayList<String>();
        for (User user : this.m_users.values()) {
            if (!this.isUserScheduledForRole(user, roleid, time)) continue;
            usersScheduledForRole.add(user.getUserId());
        }
        return usersScheduledForRole.toArray(new String[usersScheduledForRole.size()]);
    }

    public boolean hasRole(String roleid) throws MarshalException, ValidationException, IOException {
        return this.m_groupManager.getRole(roleid) != null;
    }

    public int countUsersWithRole(String roleid) throws MarshalException, ValidationException, IOException {
        String[] users = this.getUsersWithRole(roleid);
        if (users == null) {
            return 0;
        }
        return users.length;
    }

    public abstract boolean isUpdateNeeded();
}

