/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;

public class PeerFactory {
    protected static long toLong(InetAddress addr) {
        byte[] baddr = addr.getAddress();
        long result = ((long)baddr[0] & 0xFFL) << 24 | ((long)baddr[1] & 0xFFL) << 16 | ((long)baddr[2] & 0xFFL) << 8 | (long)baddr[3] & 0xFFL;
        return result;
    }

    public static boolean verifyIpMatch(String hostAddress, String ipMatch) {
        String[] hostOctets = hostAddress.split("\\.", 0);
        String[] matchOctets = ipMatch.split("\\.", 0);
        for (int i = 0; i < 4; ++i) {
            if (PeerFactory.matchNumericListOrRange(hostOctets[i], matchOctets[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNumericListOrRange(String value, String patterns) {
        String[] patternList = patterns.split(",", 0);
        for (int i = 0; i < patternList.length; ++i) {
            if (!PeerFactory.matchRange(value, patternList[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean matchRange(String value, String pattern) {
        int dashCount = PeerFactory.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return value.equals(pattern);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            int rangeBegin = Integer.parseInt(ar[0]);
            int rangeEnd = Integer.parseInt(ar[1]);
            int ip = Integer.parseInt(value);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static int countChar(char charIn, String stingIn) {
        int charCount = 0;
        int charIndex = 0;
        for (int i = 0; i < stingIn.length(); ++i) {
            charIndex = stingIn.indexOf(charIn, i);
            if (charIndex == -1) continue;
            ++charCount;
            i = charIndex + 1;
        }
        return charCount;
    }
}

