/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.IpManagement;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.SmbAuth;
import org.opennms.netmgt.config.capsd.SmbConfig;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CapsdConfigManager
implements CapsdConfig {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';
    private CapsdConfiguration m_config;
    private Map<String, List<String>> m_urlMap;

    public CapsdConfigManager() {
    }

    public CapsdConfigManager(Reader rdr) throws MarshalException, ValidationException {
        this.loadXml(rdr);
    }

    protected abstract void saveXml(String var1) throws IOException;

    protected abstract void update() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    protected void loadXml(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (CapsdConfiguration)CastorUtils.unmarshal(CapsdConfiguration.class, (Reader)rdr);
        this.loadIncludeUrls();
    }

    private void loadIncludeUrls() {
        this.m_urlMap = new HashMap<String, List<String>>();
        for (IpManagement mgt : this.getIpManagements()) {
            for (String url : this.getIncludeUrls(mgt)) {
                if (this.m_urlMap.containsKey(url)) continue;
                this.m_urlMap.put(url, this.getAddressesFromURL(url));
            }
        }
    }

    @Override
    public synchronized void save() throws MarshalException, IOException, ValidationException {
        this.log().debug((Object)"Saving capsd configuration");
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.log().info((Object)"Saved capsd configuration");
        this.update();
    }

    @Override
    public CapsdConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public ProtocolPlugin getProtocolPlugin(String svcName) {
        for (ProtocolPlugin plugin : this.getProtocolPlugins()) {
            if (!plugin.getProtocol().equals(svcName)) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void addProtocolPlugin(ProtocolPlugin plugin) {
        this.m_config.addProtocolPlugin(plugin);
    }

    @Override
    public SmbAuth getSmbAuth(String target) {
        SmbConfig cfg = this.m_config.getSmbConfig();
        if (cfg == null) {
            return null;
        }
        List<SmbAuth> smbAuths = this.getSmbAuths(cfg);
        for (SmbAuth a : smbAuths) {
            if (!target.equalsIgnoreCase(a.getContent())) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean isAddressUnmanaged(InetAddress target) {
        boolean result;
        String managementPolicy = this.m_config.getManagementPolicy();
        boolean managedByDefault = managementPolicy == null || managementPolicy.equalsIgnoreCase("managed");
        boolean found_denial = false;
        boolean found_accept = false;
        List<IpManagement> ipManagements = this.getIpManagements();
        Iterator<IpManagement> ipIter = ipManagements.iterator();
        while (ipIter.hasNext() && !found_denial) {
            IpManagement mgt = ipIter.next();
            for (String saddr : this.getSpecifics(mgt)) {
                InetAddress addr;
                try {
                    addr = InetAddress.getByName(saddr);
                }
                catch (UnknownHostException e) {
                    this.log().info((Object)("Failed to convert specific address '" + saddr + "' to an InetAddress: " + e), (Throwable)e);
                    continue;
                }
                if (!addr.equals(target)) continue;
                if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                    found_accept = true;
                    break;
                }
                found_denial = true;
                break;
            }
            List<Range> ranges = this.getRanges(mgt);
            Iterator<Range> rangeIter = ranges.iterator();
            while (!found_denial && rangeIter.hasNext()) {
                InetAddress eaddr;
                InetAddress saddr;
                Range range = rangeIter.next();
                try {
                    saddr = InetAddress.getByName(range.getBegin());
                }
                catch (UnknownHostException e) {
                    this.log().info((Object)("Failed to convert begin address '" + range.getBegin() + "' to an InetAddress: " + e), (Throwable)e);
                    continue;
                }
                try {
                    eaddr = InetAddress.getByName(range.getEnd());
                }
                catch (UnknownHostException e) {
                    this.log().info((Object)("Failed to convert end address '" + range.getEnd() + "' to an InetAddress: " + e), (Throwable)e);
                    continue;
                }
                long start = this.toLong(saddr);
                long stop = this.toLong(eaddr);
                long tgt = this.toLong(target);
                if (start > tgt || tgt > stop) continue;
                if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                    found_accept = true;
                    break;
                }
                found_denial = true;
                break;
            }
            List<String> includeUrls = this.getIncludeUrls(mgt);
            Iterator<String> includeUrlIter = includeUrls.iterator();
            boolean match = false;
            block11: while (!found_denial && !match && includeUrlIter.hasNext()) {
                String url = includeUrlIter.next();
                for (String saddr : this.m_urlMap.get(url)) {
                    InetAddress addr;
                    try {
                        addr = InetAddress.getByName(saddr);
                    }
                    catch (UnknownHostException e) {
                        this.log().info((Object)("Failed to convert address '" + saddr + "' from include URL '" + url + "' to an InetAddress: " + e), (Throwable)e);
                        continue;
                    }
                    if (!addr.equals(target)) continue;
                    if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                        found_accept = true;
                    } else {
                        found_denial = true;
                    }
                    match = true;
                    continue block11;
                }
            }
        }
        boolean bl = result = !managedByDefault;
        if (found_denial) {
            result = true;
        } else if (found_accept) {
            result = false;
        }
        return result;
    }

    private List<String> getAddressesFromURL(String url) {
        ArrayList<String> addrList = new ArrayList<String>();
        try {
            URL fileURL = new URL(url);
            InputStream file = fileURL.openStream();
            if (file != null) {
                BufferedReader buffer = new BufferedReader(new InputStreamReader(file));
                String ipLine = null;
                String specIP = null;
                while ((ipLine = buffer.readLine()) != null) {
                    if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                    int comIndex = ipLine.indexOf(COMMENT_STR);
                    if (comIndex == -1) {
                        specIP = ipLine;
                    } else {
                        specIP = ipLine.substring(0, comIndex);
                        ipLine = ipLine.trim();
                    }
                    addrList.add(specIP);
                    specIP = null;
                }
                buffer.close();
            } else {
                this.log().warn((Object)("URL does not exist: " + url.toString()));
            }
        }
        catch (MalformedURLException e) {
            this.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (FileNotFoundException e) {
            this.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            this.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        return addrList;
    }

    @Override
    public long getRescanFrequency() {
        long frequency = -1L;
        if (this.m_config.hasRescanFrequency()) {
            frequency = this.m_config.getRescanFrequency();
        } else {
            this.log().warn((Object)"Capsd configuration file is missing rescan interval, defaulting to 24 hour interval.");
            frequency = 86400000L;
        }
        return frequency;
    }

    @Override
    public long getInitialSleepTime() {
        long sleep = -1L;
        if (this.m_config.hasInitialSleepTime()) {
            sleep = this.m_config.getInitialSleepTime();
        } else {
            this.log().warn((Object)"Capsd configuration file is missing rescan interval, defaulting to 24 hour interval.");
            sleep = 300000L;
        }
        return sleep;
    }

    @Override
    public int getMaxSuspectThreadPoolSize() {
        return this.m_config.getMaxSuspectThreadPoolSize();
    }

    @Override
    public int getMaxRescanThreadPoolSize() {
        return this.m_config.getMaxRescanThreadPoolSize();
    }

    @Override
    public boolean getAbortProtocolScansFlag() {
        boolean abortFlag = false;
        String abortProperty = this.m_config.getAbortProtocolScansIfNoRoute();
        if (abortProperty != null && abortProperty.equals("true")) {
            abortFlag = true;
        }
        return abortFlag;
    }

    @Override
    public boolean getDeletePropagationEnabled() {
        boolean propagationEnabled = true;
        String propagationProperty = this.m_config.getDeletePropagationEnabled();
        if (propagationProperty != null && propagationProperty.equals("false")) {
            propagationEnabled = false;
        }
        return propagationEnabled;
    }

    @Override
    public String getXmlrpc() {
        return this.m_config.getXmlrpc();
    }

    @Override
    public boolean isXmlRpcEnabled() {
        return "true".equalsIgnoreCase(this.getXmlrpc());
    }

    private InetAddress compareAndSelectPrimaryCollectionInterface(String svcName, InetAddress currentIf, InetAddress oldPrimary, String method, boolean strict) {
        InetAddress newPrimary = null;
        CollectdConfigFactory factory = CollectdConfigFactory.getInstance();
        if (oldPrimary == null && strict) {
            if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                return currentIf;
            }
            return oldPrimary;
        }
        if (oldPrimary == null) {
            return currentIf;
        }
        long current = IPSorter.convertToLong((byte[])currentIf.getAddress());
        long primary = IPSorter.convertToLong((byte[])oldPrimary.getAddress());
        if (method.equals("min")) {
            if (current < primary) {
                if (strict) {
                    if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                        newPrimary = currentIf;
                    }
                } else {
                    newPrimary = currentIf;
                }
            }
        } else if (current > primary) {
            if (strict) {
                if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                    newPrimary = currentIf;
                }
            } else {
                newPrimary = currentIf;
            }
        }
        if (newPrimary != null) {
            return newPrimary;
        }
        return oldPrimary;
    }

    @Override
    public InetAddress determinePrimarySnmpInterface(List<InetAddress> addressList, boolean strict) {
        InetAddress primaryIf = null;
        String method = "min";
        for (InetAddress ipAddr : addressList) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("determinePrimarySnmpIf: checking interface " + ipAddr.getHostAddress()));
            }
            primaryIf = this.compareAndSelectPrimaryCollectionInterface("SNMP", ipAddr, primaryIf, method, strict);
        }
        if (this.log().isDebugEnabled()) {
            if (primaryIf != null) {
                this.log().debug((Object)("determinePrimarySnmpInterface: candidate primary SNMP interface: " + primaryIf.getHostAddress()));
            } else {
                this.log().debug((Object)"determinePrimarySnmpInterface: no candidate primary SNMP interface found");
            }
        }
        return primaryIf;
    }

    @Override
    public long toLong(InetAddress addr) {
        byte[] baddr = addr.getAddress();
        return ((long)baddr[0] & 0xFFL) << 24 | ((long)baddr[1] & 0xFFL) << 16 | ((long)baddr[2] & 0xFFL) << 8 | (long)baddr[3] & 0xFFL;
    }

    @Override
    public List<String> getConfiguredProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        for (ProtocolPlugin plugin : this.getProtocolPlugins()) {
            protocols.add(plugin.getProtocol());
        }
        return protocols;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public List<ProtocolPlugin> getProtocolPlugins() {
        return this.m_config.getProtocolPluginCollection();
    }

    private List<IpManagement> getIpManagements() {
        return this.m_config.getIpManagementCollection();
    }

    private List<Range> getRanges(IpManagement mgt) {
        return mgt.getRangeCollection();
    }

    private List<String> getSpecifics(IpManagement mgt) {
        return mgt.getSpecificCollection();
    }

    private List<String> getIncludeUrls(IpManagement mgt) {
        return mgt.getIncludeUrlCollection();
    }

    @Override
    public List<ProtocolConfiguration> getProtocolConfigurations(ProtocolPlugin plugin) {
        return plugin.getProtocolConfigurationCollection();
    }

    @Override
    public List<Property> getPluginProperties(ProtocolPlugin plugin) {
        return plugin.getPropertyCollection();
    }

    @Override
    public List<Property> getProtocolConfigurationProperties(ProtocolConfiguration pluginConf) {
        return pluginConf.getPropertyCollection();
    }

    @Override
    public List<Range> getRanges(ProtocolConfiguration pluginConf) {
        return pluginConf.getRangeCollection();
    }

    @Override
    public List<String> getSpecifics(ProtocolConfiguration pluginConf) {
        return pluginConf.getSpecificCollection();
    }

    private List<SmbAuth> getSmbAuths(SmbConfig cfg) {
        return cfg.getSmbAuthCollection();
    }
}

