/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfNumberTracker;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ResourceVisitor;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpIfCollector;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.collectd.SysUpTimeTracker;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpCollectionSet
implements Collectable,
CollectionSet {
    private CollectionAgent m_agent;
    private OnmsSnmpCollection m_snmpCollection;
    private SnmpIfCollector m_ifCollector;
    private IfNumberTracker m_ifNumber;
    private SysUpTimeTracker m_sysUpTime;
    private SnmpNodeCollector m_nodeCollector;
    private int m_status = 2;
    private boolean m_ignorePersist;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CollectionAgent: ");
        buffer.append(this.m_agent);
        buffer.append("\n");
        buffer.append("OnmsSnmpCollection: ");
        buffer.append(this.m_snmpCollection);
        buffer.append("\n");
        buffer.append("SnmpIfCollector: ");
        buffer.append((Object)this.m_ifCollector);
        buffer.append("\n");
        buffer.append("IfNumberTracker: ");
        buffer.append((Object)this.m_ifNumber);
        buffer.append("\n");
        buffer.append("SysUpTimeTracker: ");
        buffer.append((Object)this.m_sysUpTime);
        buffer.append("\n");
        buffer.append("SnmpNodeCollector: ");
        buffer.append((Object)this.m_nodeCollector);
        buffer.append("\n");
        return buffer.toString();
    }

    public SnmpCollectionSet(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public SnmpIfCollector getIfCollector() {
        if (this.m_ifCollector == null) {
            this.m_ifCollector = this.createIfCollector();
        }
        return this.m_ifCollector;
    }

    public IfNumberTracker getIfNumber() {
        if (this.m_ifNumber == null) {
            this.m_ifNumber = this.createIfNumberTracker();
        }
        return this.m_ifNumber;
    }

    public SysUpTimeTracker getSysUpTime() {
        if (this.m_sysUpTime == null) {
            this.m_sysUpTime = this.createSysUpTimeTracker();
        }
        return this.m_sysUpTime;
    }

    public SnmpNodeCollector getNodeCollector() {
        if (this.m_nodeCollector == null) {
            this.m_nodeCollector = this.createNodeCollector();
        }
        return this.m_nodeCollector;
    }

    private SnmpNodeCollector createNodeCollector() {
        SnmpNodeCollector nodeCollector = null;
        if (!this.getAttributeList().isEmpty()) {
            nodeCollector = new SnmpNodeCollector(this.m_agent.getInetAddress(), this.getAttributeList(), this);
        }
        return nodeCollector;
    }

    private IfNumberTracker createIfNumberTracker() {
        IfNumberTracker ifNumber = null;
        if (this.hasInterfaceDataToCollect()) {
            ifNumber = new IfNumberTracker();
        }
        return ifNumber;
    }

    private SysUpTimeTracker createSysUpTimeTracker() {
        SysUpTimeTracker sysUpTime = null;
        if (this.hasInterfaceDataToCollect()) {
            sysUpTime = new SysUpTimeTracker();
        }
        return sysUpTime;
    }

    private SnmpIfCollector createIfCollector() {
        SnmpIfCollector ifCollector = null;
        if (this.hasInterfaceDataToCollect()) {
            ifCollector = new SnmpIfCollector(this.m_agent.getInetAddress(), this.getCombinedIndexedAttributes(), this);
        }
        return ifCollector;
    }

    public NodeInfo getNodeInfo() {
        return this.getNodeResourceType().getNodeInfo();
    }

    boolean hasDataToCollect() {
        return this.getNodeResourceType().hasDataToCollect() || this.getIfResourceType().hasDataToCollect();
    }

    boolean hasInterfaceDataToCollect() {
        return this.getIfResourceType().hasDataToCollect();
    }

    public CollectionAgent getCollectionAgent() {
        return this.m_agent;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    Collection<SnmpAttributeType> getAttributeList() {
        return this.m_snmpCollection.getNodeResourceType(this.m_agent).getAttributeTypes();
    }

    List<SnmpAttributeType> getCombinedIndexedAttributes() {
        LinkedList<SnmpAttributeType> attributes = new LinkedList<SnmpAttributeType>();
        attributes.addAll(this.getIfResourceType().getAttributeTypes());
        attributes.addAll(this.getIfAliasResourceType().getAttributeTypes());
        attributes.addAll(this.getGenericIndexAttributeTypes());
        return attributes;
    }

    protected Collection<SnmpAttributeType> getGenericIndexAttributeTypes() {
        LinkedList<SnmpAttributeType> attributeTypes = new LinkedList<SnmpAttributeType>();
        Collection<ResourceType> resourceTypes = this.getGenericIndexResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            attributeTypes.addAll(resourceType.getAttributeTypes());
        }
        return attributeTypes;
    }

    private Collection<ResourceType> getGenericIndexResourceTypes() {
        return this.m_snmpCollection.getGenericIndexResourceTypes(this.m_agent);
    }

    public CollectionTracker getCollectionTracker() {
        return new AggregateTracker(SnmpAttributeType.getCollectionTrackers(this.getAttributeTypes()));
    }

    private Collection<SnmpAttributeType> getAttributeTypes() {
        return this.m_snmpCollection.getAttributeTypes(this.m_agent);
    }

    public Collection<? extends CollectionResource> getResources() {
        return this.m_snmpCollection.getResources(this.m_agent);
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet(this);
        for (CollectionResource collectionResource : this.getResources()) {
            collectionResource.visit(visitor);
        }
        visitor.completeCollectionSet(this);
    }

    CollectionTracker getTracker() {
        ArrayList<Object> trackers = new ArrayList<Object>(4);
        if (this.getIfNumber() != null) {
            trackers.add((Object)this.getIfNumber());
        }
        if (this.getSysUpTime() != null) {
            trackers.add((Object)this.getSysUpTime());
        }
        if (this.getNodeCollector() != null) {
            trackers.add((Object)this.getNodeCollector());
        }
        if (this.getIfCollector() != null) {
            trackers.add((Object)this.getIfCollector());
        }
        return new AggregateTracker(trackers);
    }

    protected SnmpWalker createWalker() {
        CollectionAgent agent = this.getCollectionAgent();
        return SnmpUtils.createWalker((SnmpAgentConfig)this.getAgentConfig(), (String)("SnmpCollectors for " + agent.getHostAddress()), (CollectionTracker)this.getTracker());
    }

    void logStartedWalker() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("collect: successfully instantiated SnmpNodeCollector() for " + this.getCollectionAgent().getHostAddress()));
        }
    }

    void logFinishedWalker() {
        this.log().info((Object)("collect: node SNMP query for address " + this.getCollectionAgent().getHostAddress() + " complete."));
    }

    void verifySuccessfulWalk(SnmpWalker walker) throws CollectionWarning {
        if (walker.failed()) {
            throw new CollectionWarning("collect: collection failed for " + this.getCollectionAgent().getHostAddress());
        }
    }

    void collect() throws CollectionWarning {
        try {
            SnmpWalker walker = this.createWalker();
            walker.start();
            this.logStartedWalker();
            walker.waitFor();
            this.logFinishedWalker();
            this.verifySuccessfulWalk(walker);
            this.m_status = 1;
            this.getCollectionAgent().setMaxVarsPerPdu(walker.getMaxVarsPerPdu());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionWarning("collect: Collection of node SNMP data for interface " + this.getCollectionAgent().getHostAddress() + " interrupted!", e);
        }
    }

    void checkForNewInterfaces(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        this.logIfCounts();
        if (this.getIfNumber().isChanged(this.getCollectionAgent().getSavedIfCount())) {
            this.log().info((Object)("Sending rescan event because the number of interfaces on primary SNMP interface " + this.getCollectionAgent().getHostAddress() + " has changed, generating 'ForceRescan' event."));
            rescanNeeded.rescanIndicated();
        }
        this.getCollectionAgent().setSavedIfCount(this.getIfNumber().getIntValue());
    }

    void checkForSystemRestart(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        this.logSysUpTime();
        this.m_ignorePersist = false;
        if (this.getSysUpTime().isChanged(this.getCollectionAgent().getSavedSysUpTime())) {
            this.log().info((Object)("Sending rescan event because sysUpTime has changed on primary SNMP interface " + this.getCollectionAgent().getHostAddress() + ", generating 'ForceRescan' event."));
            rescanNeeded.rescanIndicated();
            this.m_ignorePersist = true;
            this.getCollectionAgent().setSavedSysUpTime(-1L);
        } else {
            this.getCollectionAgent().setSavedSysUpTime(this.getSysUpTime().getLongValue());
        }
    }

    private void logIfCounts() {
        CollectionAgent agent = this.getCollectionAgent();
        this.log().debug((Object)("collect: nodeId: " + agent.getNodeId() + " interface: " + agent.getHostAddress() + " ifCount: " + this.getIfNumber().getIntValue() + " savedIfCount: " + agent.getSavedIfCount()));
    }

    private void logSysUpTime() {
        CollectionAgent agent = this.getCollectionAgent();
        this.log().debug((Object)("collect: nodeId: " + agent.getNodeId() + " interface: " + agent.getHostAddress() + " sysUpTime: " + this.getSysUpTime().getLongValue() + " savedSysUpTime: " + agent.getSavedSysUpTime()));
    }

    public boolean rescanNeeded() {
        final RescanNeeded rescanNeeded = new RescanNeeded();
        this.visit(new ResourceVisitor(){

            public void visitResource(CollectionResource resource) {
                SnmpCollectionSet.this.log().debug((Object)("rescanNeeded: Visiting resource " + resource));
                if (resource.rescanNeeded()) {
                    SnmpCollectionSet.this.log().debug((Object)("Sending rescan event for " + SnmpCollectionSet.this.getCollectionAgent() + " because resource " + resource + " indicated it was needed"));
                    rescanNeeded.rescanIndicated();
                }
            }
        });
        this.checkForNewInterfaces(rescanNeeded);
        this.checkForSystemRestart(rescanNeeded);
        return rescanNeeded.rescanIsNeeded();
    }

    public SnmpAgentConfig getAgentConfig() {
        SnmpAgentConfig agentConfig = this.getCollectionAgent().getAgentConfig();
        agentConfig.setMaxVarsPerPdu(this.computeMaxVarsPerPdu(agentConfig));
        agentConfig.setReadCommunity(this.m_snmpCollection.getReadCommunity(agentConfig.getReadCommunity()));
        agentConfig.setMaxRepetitions(this.m_snmpCollection.getMaxRepetitions(agentConfig.getMaxRepetitions()));
        int snmpPort = this.m_snmpCollection.getSnmpPort();
        if (snmpPort > -1) {
            agentConfig.setPort(snmpPort);
        }
        return agentConfig;
    }

    private int computeMaxVarsPerPdu(SnmpAgentConfig agentConfig) {
        int maxVarsPerPdu = this.getCollectionAgent().getMaxVarsPerPdu();
        if (maxVarsPerPdu < 1) {
            maxVarsPerPdu = this.m_snmpCollection.getMaxVarsPerPdu();
            this.log().info((Object)"using maxVarsPerPdu from dataCollectionConfig");
        }
        if (maxVarsPerPdu < 1) {
            maxVarsPerPdu = agentConfig.getMaxVarsPerPdu();
            this.log().info((Object)"using maxVarsPerPdu from snmpconfig");
        }
        if (maxVarsPerPdu < 1) {
            this.log().warn((Object)"maxVarsPerPdu CANNOT BE LESS THAN 1.  Using 10");
            return 10;
        }
        return maxVarsPerPdu;
    }

    public void notifyIfNotFound(AttributeDefinition attrType, SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        this.log().info((Object)("Unable to locate resource for agent " + this.getCollectionAgent() + " with instance id " + inst + " while collecting attribute " + attrType));
    }

    private NodeResourceType getNodeResourceType() {
        return this.m_snmpCollection.getNodeResourceType(this.getCollectionAgent());
    }

    private IfResourceType getIfResourceType() {
        return this.m_snmpCollection.getIfResourceType(this.getCollectionAgent());
    }

    private IfAliasResourceType getIfAliasResourceType() {
        return this.m_snmpCollection.getIfAliasResourceType(this.getCollectionAgent());
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public boolean ignorePersist() {
        return this.m_ignorePersist;
    }

    public static class RescanNeeded {
        boolean rescanNeeded = false;

        public void rescanIndicated() {
            this.rescanNeeded = true;
        }

        public boolean rescanIsNeeded() {
            return this.rescanNeeded;
        }
    }
}

