/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceParameters {
    Map<String, String> m_parameters;

    public ServiceParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    String getDomain() {
        return ParameterMap.getKeyedString(this.getParameters(), "domain", "default");
    }

    String getStoreByNodeID() {
        return ParameterMap.getKeyedString(this.getParameters(), "storeByNodeID", "normal");
    }

    String getStoreByIfAlias() {
        return ParameterMap.getKeyedString(this.getParameters(), "storeByIfAlias", "false");
    }

    String getStorFlagOverride() {
        return ParameterMap.getKeyedString(this.getParameters(), "storFlagOverride", "false");
    }

    String getIfAliasComment() {
        return ParameterMap.getKeyedString(this.getParameters(), "ifAliasComment", null);
    }

    boolean aliasesEnabled() {
        return this.getStoreByIfAlias().equals("true");
    }

    boolean overrideStorageFlag() {
        return !this.getStorFlagOverride().equals("false");
    }

    void logIfAliasConfig() {
        this.log().info((Object)("domain: " + this.getDomain() + ", " + "storeByNodeID: " + this.getStoreByNodeID() + ", " + "storeByIfAlias: " + this.getStoreByIfAlias() + ", " + "storFlagOverride: " + this.getStorFlagOverride() + ", " + "ifAliasComment: " + this.getIfAliasComment()));
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    boolean forceStoreByAlias(String alias) {
        return this.overrideStorageFlag() && alias != null && !alias.equals("");
    }

    String getCollectionName() {
        if (this.m_parameters.containsKey("collection")) {
            return this.m_parameters.get("collection");
        }
        if (this.m_parameters.containsKey("http-collection")) {
            return this.m_parameters.get("http-collection");
        }
        if (this.m_parameters.containsKey("nsclient-collection")) {
            return this.m_parameters.get("nsclient-collection");
        }
        return "default";
    }

    public String getReadCommunity(String current) {
        String readCommunity = ParameterMap.getKeyedString(this.m_parameters, "read-community", null);
        if (readCommunity == null) {
            readCommunity = ParameterMap.getKeyedString(this.m_parameters, "readCommunity", current);
        }
        return readCommunity;
    }

    public int getSnmpPort() {
        return ParameterMap.getKeyedInteger(this.getParameters(), "port", -1);
    }

    public int getMaxRepetitions(int current) {
        int maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, "max-repetitions", -1);
        if (maxRepetitions == -1) {
            maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, "maxRepetitons", current);
        }
        return maxRepetitions;
    }
}

