/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.snmp.AbstractSnmpStore;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SNMPCollectorEntry
extends AbstractSnmpStore {
    private Collection<SnmpAttributeType> m_attrList;
    private SnmpCollectionSet m_collectionSet;

    public SNMPCollectorEntry(Collection<SnmpAttributeType> attrList, SnmpCollectionSet collectionSet) {
        if (attrList == null) {
            throw new NullPointerException("attrList is null!");
        }
        this.m_attrList = attrList;
        this.m_collectionSet = collectionSet;
    }

    private Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    private List<SnmpAttributeType> findAttributeTypeForOid(SnmpObjId base, SnmpInstId inst) {
        LinkedList<SnmpAttributeType> matching = new LinkedList<SnmpAttributeType>();
        for (SnmpAttributeType attrType : this.m_attrList) {
            if (!attrType.matches(base, inst)) continue;
            matching.add(attrType);
        }
        return matching;
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        String key = base.append((SnmpObjId)inst).toString();
        this.putValue(key, val);
        List<SnmpAttributeType> attrTypes = this.findAttributeTypeForOid(base, inst);
        if (attrTypes.isEmpty()) {
            throw new IllegalArgumentException("Received result for unexpected oid [" + base + "].[" + inst + "]");
        }
        for (SnmpAttributeType attrType : attrTypes) {
            if (attrType.getInstance().equals("ifIndex")) {
                this.putIfIndex(inst.toInt());
            }
            attrType.storeResult(this.m_collectionSet, this, base, inst, val);
            this.log().debug((Object)("storeResult: added value for " + attrType.getAlias() + ": [" + base + "].[" + inst + "] = " + val));
        }
    }

    String getValueForBase(String baseOid) {
        String instance = String.valueOf(this.getIfIndex());
        if (instance == null || instance.equals("")) {
            return null;
        }
        String fullOid = baseOid + "." + instance;
        String snmpVar = this.getDisplayString(fullOid);
        if (snmpVar == null) {
            return null;
        }
        snmpVar.trim();
        if (snmpVar.equals("")) {
            return null;
        }
        return snmpVar;
    }
}

