/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.config.MibObject;

public class NumericAttributeType
extends SnmpAttributeType {
    private static String[] s_supportedTypes = new String[]{"counter", "gauge", "timeticks", "integer", "octetstring"};
    static final String DST_COUNTER = "COUNTER";

    public static boolean supportsType(String rawType) {
        String type = rawType.toLowerCase();
        for (int i = 0; i < s_supportedTypes.length; ++i) {
            String supportedType = s_supportedTypes[i];
            if (!type.startsWith(supportedType)) continue;
            return true;
        }
        return false;
    }

    public NumericAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        super(resourceType, collectionName, mibObj, groupType);
        String alias;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("buildDataSourceList: ds_name: " + this.getName() + " ds_oid: " + this.getOid() + "." + this.getInstance()));
        }
        if ((alias = this.getAlias()).length() > 19) {
            this.logNameTooLong();
        }
    }

    public void storeAttribute(CollectionAttribute attribute, Persister persister) {
        persister.persistNumericAttribute(attribute);
    }

    void logNameTooLong() {
        this.log().warn((Object)("buildDataSourceList: Mib object name/alias '" + this.getAlias() + "' exceeds 19 char maximum for RRD data source names, truncating."));
    }
}

