/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgentService;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCollectionAgentService
implements CollectionAgentService {
    private static final long serialVersionUID = 6694654071513990997L;
    private Integer m_ifaceId;
    private IpInterfaceDao m_ifaceDao;

    public static CollectionAgentService create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        DefaultCollectionAgentService agent = new DefaultCollectionAgentService(ifaceId, ifaceDao);
        TransactionProxyFactoryBean bean = new TransactionProxyFactoryBean();
        bean.setTransactionManager(transMgr);
        bean.setTarget((Object)agent);
        Properties props = new Properties();
        props.put("*", "PROPAGATION_REQUIRED,readOnly");
        bean.setTransactionAttributes(props);
        bean.afterPropertiesSet();
        return (CollectionAgentService)bean.getObject();
    }

    private DefaultCollectionAgentService(Integer ifaceId, IpInterfaceDao ifaceDao) {
        this.m_ifaceId = ifaceId;
        this.m_ifaceDao = ifaceDao;
    }

    OnmsIpInterface getIpInterface() {
        return (OnmsIpInterface)this.m_ifaceDao.load((Serializable)this.m_ifaceId);
    }

    private OnmsNode getNode() {
        return this.getIpInterface().getNode();
    }

    @Override
    public String getHostAddress() {
        return this.getInetAddress().getHostAddress();
    }

    @Override
    public int getNodeId() {
        return this.getIpInterface().getNode().getId() == null ? -1 : this.getIpInterface().getNode().getId();
    }

    @Override
    public int getIfIndex() {
        return this.getIpInterface().getIfIndex() == null ? -1 : this.getIpInterface().getIfIndex();
    }

    @Override
    public String getSysObjectId() {
        return this.getIpInterface().getNode().getSysObjectId();
    }

    @Override
    public OnmsIpInterface.CollectionType getCollectionType() {
        return this.getIpInterface().getIsSnmpPrimary();
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    @Override
    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getInetAddress());
    }

    @Override
    public Set<SnmpIfData> getSnmpInterfaceData() {
        Set<OnmsSnmpInterface> snmpIfs = this.getSnmpInterfaces();
        LinkedHashSet<SnmpIfData> ifData = new LinkedHashSet<SnmpIfData>(snmpIfs.size());
        for (OnmsSnmpInterface snmpIface : snmpIfs) {
            this.logInitializeSnmpIf(snmpIface);
            SnmpIfData snmpIfData = new SnmpIfData(snmpIface);
            ifData.add(snmpIfData);
        }
        return ifData;
    }

    private Set<OnmsSnmpInterface> getSnmpInterfaces() {
        OnmsNode node = this.getNode();
        Set snmpIfs = node.getSnmpInterfaces();
        if (snmpIfs.size() == 0) {
            this.log().debug((Object)("no known SNMP interfaces for node " + node));
        }
        return snmpIfs;
    }

    private void logInitializeSnmpIf(OnmsSnmpInterface snmpIface) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: snmpifindex = " + snmpIface.getIfIndex() + ", snmpifname = " + snmpIface.getIfName() + ", snmpifdescr = " + snmpIface.getIfDescr() + ", snmpphysaddr = -" + snmpIface.getPhysAddr() + "-"));
            this.log().debug((Object)("initialize: ifLabel = '" + snmpIface.computeLabelForRRD() + "'"));
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getIpInterface().getInetAddress();
    }
}

