/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.AbstractSnmpStore;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueType;

public class SnmpStore
extends AbstractSnmpStore {
    protected NamedSnmpVar[] ms_elemList = null;

    public SnmpStore(NamedSnmpVar[] list) {
        this.ms_elemList = list;
    }

    public int getElementListSize() {
        return this.ms_elemList.length;
    }

    public NamedSnmpVar[] getElements() {
        return this.ms_elemList;
    }

    protected Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        this.putValue(base.toString(), val);
        for (int i = 0; i < this.ms_elemList.length; ++i) {
            NamedSnmpVar var = this.ms_elemList[i];
            if (!base.equals((Object)var.getSnmpObjId())) continue;
            if (val.isError()) {
                this.log().error((Object)("storeResult: got an error for alias " + var.getAlias() + " [" + base + "].[" + inst + "], but we should only be getting non-errors: " + val));
                continue;
            }
            if (val.isEndOfMib()) {
                this.log().debug((Object)("storeResult: got endOfMib for alias " + var.getAlias() + " [" + base + "].[" + inst + "], not storing"));
                continue;
            }
            SnmpValueType type = SnmpValueType.valueOf((int)val.getType());
            this.log().debug((Object)("Storing Result: alias: " + var.getAlias() + " [" + base + "].[" + inst + "] = " + (type == null ? "Unknown" : type.getDisplayString()) + ": " + this.toLogString(val)));
            this.putValue(var.getAlias(), val);
        }
    }

    private String toLogString(SnmpValue val) {
        if (val.getType() == 4) {
            return val.toDisplayString() + " (" + val.toHexString() + ")";
        }
        return val.toString();
    }
}

