/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pop3Plugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "POP3";
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("Pop3Plugin: connected to host: " + host + " on port: " + port));
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringTokenizer t = new StringTokenizer(lineRdr.readLine());
                if (!t.nextToken().equals("+OK")) continue;
                String cmd = "QUIT\r\n";
                socket.getOutputStream().write(cmd.getBytes());
                t = new StringTokenizer(lineRdr.readLine());
                if (!t.nextToken().equals("+OK")) continue;
                isAServer = true;
                continue;
            }
            catch (ConnectException cE) {
                log.debug((Object)("Pop3Plugin: Connection refused to " + host.getHostAddress() + ":" + port));
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info((Object)("Pop3Plugin: No route to host " + host.getHostAddress() + " was available"), (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug((Object)("Pop3Plugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                isAServer = false;
                log.info((Object)("Pop3Plugin: An unexpected I/O exception occured contacting host " + host.getHostAddress()), (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                log.error((Object)("Pop3Plugin: An undeclared throwable exception was caught contacting host " + host.getHostAddress()), t);
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 110, 0, 5000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int retries = 0;
        int timeout = 5000;
        int port = 110;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 5000);
            port = ParameterMap.getKeyedInteger(qualifiers, "port", 110);
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", new Integer(port));
        }
        return result;
    }
}

