/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.capsd.IfCollector;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RescanProcessor
implements Runnable {
    static final String SQL_DB_RETRIEVE_NODE_TYPE = "SELECT nodetype FROM node WHERE nodeID=?";
    static final String SQL_DB_RETRIEVE_OTHER_NODES = "SELECT nodeid FROM ipinterface WHERE ismanaged != 'D' AND ipaddr = ? AND nodeid !=? ";
    static final String SQL_DB_RETRIEVE_DUPLICATE_NODEIDS = "SELECT nodeid FROM ipinterface WHERE ismanaged != 'D' AND ipaddr = ? AND nodeid !=? ";
    static final String SQL_DB_REPARENT_IP_INTERFACE_LOOKUP = "SELECT ipaddr, ifindex FROM ipinterface WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_IP_INTERFACE_DELETE = "DELETE FROM ipinterface WHERE nodeID=? AND ipaddr=?";
    static final String SQL_DB_REPARENT_IP_INTERFACE = "UPDATE ipinterface SET nodeID=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_SNMP_IF_LOOKUP = "SELECT ipaddr FROM snmpinterface WHERE nodeID=? AND ipaddr=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_IF_DELETE = "DELETE FROM snmpinterface WHERE nodeID=? AND ipaddr = ? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_INTERFACE = "UPDATE snmpinterface SET nodeID=? WHERE nodeID=? AND ipaddr=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_IF_SERVICES_LOOKUP = "SELECT serviceid FROM ifservices WHERE nodeID=? AND ipaddr=? AND ifindex = ? AND status!='D'";
    static final String SQL_DB_REPARENT_IF_SERVICES_DELETE = "DELETE FROM ifservices WHERE nodeID=? AND ipaddr=? ";
    static final String SQL_DB_REPARENT_IF_SERVICES = "UPDATE ifservices SET nodeID=? WHERE nodeID=? AND ipaddr=? AND status!='D'";
    static final String SQL_DB_DELETE_DUP_INTERFACE = "DELETE FROM ipinterface WHERE nodeID=?";
    static final String SQL_DB_DELETE_DUP_SERVICES = "DELETE FROM ifservices WHERE nodeid=?";
    static final String SQL_DB_DELETE_DUP_SNMPINTERFACE = "DELETE FROM snmpinterface WHERE nodeid =?";
    private static final String SQL_RETRIEVE_SERVICE_IDS = "SELECT serviceid,servicename  FROM service";
    private static final String SQL_DB_UPDATE_ISMANAGED = "UPDATE ipinterface SET ismanaged=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    private boolean m_forceRescan;
    private List<Event> m_eventList = new ArrayList<Event>();
    private boolean m_ifIndexOnNodeChangedFlag;
    private boolean m_snmpIfTableChangedFlag;
    private CapsdDbSyncer m_capsdDbSyncer;
    private PluginManager m_pluginManager;
    private int m_nodeId;

    RescanProcessor(Scheduler.NodeInfo nodeInfo, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this(nodeInfo.getNodeId(), forceRescan, capsdDbSyncer, pluginManager);
    }

    public RescanProcessor(int nodeId, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this.m_nodeId = nodeId;
        this.m_forceRescan = forceRescan;
        this.m_capsdDbSyncer = capsdDbSyncer;
        this.m_pluginManager = pluginManager;
    }

    private DbNodeEntry updateNode(Connection dbc, Date now, DbNodeEntry dbNodeEntry, InetAddress currPrimarySnmpIf, DbIpInterfaceEntry[] dbIpInterfaces, Map<String, IfCollector> collectorMap) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNode: updating node id " + dbNodeEntry.getNodeId()));
        }
        DbNodeEntry originalDbNodeEntry = DbNodeEntry.clone(dbNodeEntry);
        DbNodeEntry currNodeEntry = DbNodeEntry.create();
        currNodeEntry.setNodeType('A');
        this.setNodeLabelAndSmbInfo(collectorMap, dbNodeEntry, currNodeEntry, currPrimarySnmpIf);
        if (currPrimarySnmpIf != null) {
            IfCollector primaryIfc = collectorMap.get(currPrimarySnmpIf.getHostAddress());
            if (primaryIfc == null) {
                for (IfCollector tmp : collectorMap.values()) {
                    if (tmp.getSnmpCollector() == null) continue;
                    primaryIfc = tmp;
                    break;
                }
            }
            if (primaryIfc == null) {
                RescanProcessor.log().error((Object)("updateNode: failed to determine primary interface collector for node " + dbNodeEntry.getNodeId()));
                throw new RuntimeException("Update node failed for node " + dbNodeEntry.getNodeId() + ", unable to determine primary interface collector.");
            }
            IfSnmpCollector snmpc = primaryIfc.getSnmpCollector();
            if (snmpc != null && snmpc.hasSystemGroup()) {
                String sysContact;
                String sysLocation;
                String sysDescr;
                SystemGroup sysgrp = snmpc.getSystemGroup();
                currNodeEntry.setSystemOID(sysgrp.getSysObjectID());
                String sysName = sysgrp.getSysName();
                if (sysName != null && sysName.length() > 0) {
                    currNodeEntry.setSystemName(sysName);
                }
                if ((sysDescr = sysgrp.getSysDescr()) != null && sysDescr.length() > 0) {
                    currNodeEntry.setSystemDescription(sysDescr);
                }
                if ((sysLocation = sysgrp.getSysLocation()) != null && sysLocation.length() > 0) {
                    currNodeEntry.setSystemLocation(sysLocation);
                }
                if ((sysContact = sysgrp.getSysContact()) != null && sysContact.length() > 0) {
                    currNodeEntry.setSystemContact(sysContact);
                }
            }
        }
        currNodeEntry.updateParentId(dbNodeEntry.getParentId());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNode: -------dumping old node-------: " + dbNodeEntry));
            RescanProcessor.log().debug((Object)("updateNode: -------dumping new node-------: " + currNodeEntry));
        }
        dbNodeEntry.updateParentId(currNodeEntry.getParentId());
        dbNodeEntry.updateNodeType(currNodeEntry.getNodeType());
        dbNodeEntry.updateSystemOID(currNodeEntry.getSystemOID());
        dbNodeEntry.updateSystemName(currNodeEntry.getSystemName());
        dbNodeEntry.updateSystemDescription(currNodeEntry.getSystemDescription());
        dbNodeEntry.updateSystemLocation(currNodeEntry.getSystemLocation());
        dbNodeEntry.updateSystemContact(currNodeEntry.getSystemContact());
        dbNodeEntry.updateNetBIOSName(currNodeEntry.getNetBIOSName());
        dbNodeEntry.updateDomainName(currNodeEntry.getDomainName());
        dbNodeEntry.updateOS(currNodeEntry.getOS());
        dbNodeEntry.setLastPoll(now);
        if (dbNodeEntry.getLabelSource() != 'U') {
            dbNodeEntry.updateLabel(currNodeEntry.getLabel());
            dbNodeEntry.updateLabelSource(currNodeEntry.getLabelSource());
        }
        boolean nodeLabelChangedFlag = false;
        boolean nodeInfoChangedFlag = false;
        if (dbNodeEntry.hasLabelChanged() || dbNodeEntry.hasLabelSourceChanged()) {
            nodeLabelChangedFlag = true;
        }
        if (dbNodeEntry.hasSystemOIDChanged() || dbNodeEntry.hasSystemNameChanged() || dbNodeEntry.hasSystemDescriptionChanged() || dbNodeEntry.hasSystemLocationChanged() || dbNodeEntry.hasSystemContactChanged() || dbNodeEntry.hasNetBIOSNameChanged() || dbNodeEntry.hasDomainNameChanged() || dbNodeEntry.hasOSChanged()) {
            nodeInfoChangedFlag = true;
        }
        dbNodeEntry.store(dbc);
        if (nodeLabelChangedFlag) {
            this.createNodeLabelChangedEvent(dbNodeEntry, originalDbNodeEntry);
        }
        if (nodeInfoChangedFlag) {
            this.createNodeInfoChangedEvent(dbNodeEntry, originalDbNodeEntry);
        }
        return dbNodeEntry;
    }

    private void updateInterfaces(Connection dbc, Date now, DbNodeEntry node, Map<String, IfCollector> collectorMap, boolean doesSnmp) throws SQLException {
        RescanProcessor.log().debug((Object)"updateInterfaces: Rebuilding PackageIpListMap");
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        pollerCfgFactory.rebuildPackageIpListMap();
        ArrayList<InetAddress> updatedIfList = new ArrayList<InetAddress>();
        IfSnmpCollector snmpCollector = null;
        if (doesSnmp) {
            this.m_ifIndexOnNodeChangedFlag = false;
            this.m_snmpIfTableChangedFlag = false;
            IfCollector collectorWithSnmp = null;
            for (IfCollector tmp : collectorMap.values()) {
                if (tmp.getSnmpCollector() == null) continue;
                collectorWithSnmp = tmp;
                break;
            }
            if (collectorWithSnmp != null) {
                snmpCollector = collectorWithSnmp.getSnmpCollector();
                this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), collectorWithSnmp.getTarget(), collectorWithSnmp.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(collectorWithSnmp.getTarget());
                if (collectorWithSnmp.hasAdditionalTargets()) {
                    Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = collectorWithSnmp.getAdditionalTargets();
                    for (InetAddress subIf : subTargets.keySet()) {
                        this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), subIf, subTargets.get(subIf), snmpCollector, doesSnmp);
                        updatedIfList.add(subIf);
                    }
                }
                if (collectorWithSnmp.hasNonIpInterfaces()) {
                    for (Integer ifIndex : collectorWithSnmp.getNonIpInterfaces()) {
                        this.updateNonIpInterface(dbc, now, node, ifIndex, snmpCollector);
                    }
                }
            }
        }
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress ifaddr = ifc.getTarget();
            if (!updatedIfList.contains(ifaddr)) {
                this.updateInterface(dbc, now, node, ifc.getTarget(), ifaddr, ifc.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress subIf : subTargets.keySet()) {
                if (updatedIfList.contains(subIf)) continue;
                this.updateInterface(dbc, now, node, ifc.getTarget(), subIf, subTargets.get(subIf), snmpCollector, doesSnmp);
                updatedIfList.add(subIf);
            }
        }
    }

    private void updateNonIpInterface(Connection dbc, Date now, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNonIpInterface: node= " + node.getNodeId() + " ifIndex= " + ifIndex));
        }
        if (snmpc == null || snmpc.failed()) {
            return;
        }
        InetAddress ifAddr = null;
        try {
            ifAddr = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            RescanProcessor.log().error((Object)"Failed to update non-IP interfaces, unable to construct '0.0.0.0' InetAddress", (Throwable)e);
            return;
        }
        this.updateSnmpInfoForNonIpInterface(dbc, node, ifIndex, snmpc, ifAddr);
        this.updateIpInfoForNonIpInterface(dbc, now, node, ifIndex, snmpc, ifAddr);
    }

    private void updateIpInfoForNonIpInterface(Connection dbc, Date now, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc, InetAddress ifAddr) throws SQLException {
        DbIpInterfaceEntry dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifAddr, ifIndex);
        if (dbIpIfEntry == null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateNonIpInterface: non-IP interface with ifIndex " + ifIndex + " not in database, creating new interface object."));
            }
            dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifAddr);
        }
        dbIpIfEntry.setLastPoll(now);
        dbIpIfEntry.setIfIndex(ifIndex);
        dbIpIfEntry.setManagedState('U');
        int status = snmpc.getAdminStatus(ifIndex);
        if (status != -1) {
            dbIpIfEntry.setStatus(status);
        }
        dbIpIfEntry.store(dbc);
    }

    private void updateSnmpInfoForNonIpInterface(Connection dbc, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc, InetAddress ifAddr) throws SQLException {
        IfTableEntry ifte;
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNonIpInterface: updating non-IP snmp interface with nodeId=" + node.getNodeId() + " and ifIndex=" + ifIndex));
        }
        boolean newSnmpIfTableEntry = false;
        DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
        if (dbSnmpIfEntry == null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateNonIpInterface: non-IP SNMP interface with ifIndex " + ifIndex + " not in database, creating " + "new snmpInterface object."));
            }
            dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            newSnmpIfTableEntry = true;
        }
        if ((ifte = this.findEntryByIfIndex(ifIndex, snmpc)) != null) {
            dbSnmpIfEntry.updateIfAddress(ifAddr);
            this.updateType(ifte, dbSnmpIfEntry);
            this.updateDescription(ifIndex, ifte, dbSnmpIfEntry);
            this.updatePhysicalAddress(ifIndex, ifte, dbSnmpIfEntry);
            this.updateSpeed(ifIndex, ifte, dbSnmpIfEntry);
            this.updateAdminStatus(ifte, dbSnmpIfEntry);
            this.updateOperationalStatus(ifte, dbSnmpIfEntry);
            this.updateName(ifIndex, snmpc, dbSnmpIfEntry);
            this.updateAlias(ifIndex, snmpc, dbSnmpIfEntry);
        }
        if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasIfAddressChanged() || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
            this.m_snmpIfTableChangedFlag = true;
        }
        dbSnmpIfEntry.store(dbc);
    }

    private IfTableEntry findEntryByIfIndex(int ifIndex, IfSnmpCollector snmpc) {
        for (IfTableEntry entry : snmpc.getIfTable().getEntries()) {
            Integer entryIfIndex = entry.getIfIndex();
            if (entryIfIndex == null || ifIndex != entryIfIndex) continue;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateNonIpInterface: found match for ifIndex: " + ifIndex));
            }
            return entry;
        }
        return null;
    }

    private void updateAlias(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifAlias = snmpc.getIfAlias(ifIndex);
        if (ifAlias != null) {
            dbSnmpIfEntry.updateAlias(ifAlias);
        } else {
            dbSnmpIfEntry.updateAlias("");
        }
    }

    private void updateName(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifName = snmpc.getIfName(ifIndex);
        if (ifName != null && ifName.length() > 0) {
            dbSnmpIfEntry.updateName(ifName);
        }
    }

    private void updateOperationalStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfOperStatus();
        if (sint == null) {
            dbSnmpIfEntry.updateOperationalStatus(0);
        } else {
            dbSnmpIfEntry.updateOperationalStatus(sint);
        }
    }

    private void updateAdminStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfAdminStatus();
        if (sint == null) {
            dbSnmpIfEntry.updateAdminStatus(0);
        } else {
            dbSnmpIfEntry.updateAdminStatus(sint);
        }
    }

    private void updateType(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfType();
        if (sint == null) {
            dbSnmpIfEntry.updateType(0);
        } else {
            dbSnmpIfEntry.updateType(sint);
        }
    }

    private void updateDescription(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String str = ifte.getIfDescr();
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNonIpInterface: ifIndex: " + ifIndex + " has ifDescription: " + str));
        }
        if (str != null && str.length() > 0) {
            dbSnmpIfEntry.updateDescription(str);
        }
    }

    private void updatePhysicalAddress(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String physAddr = ifte.getPhysAddr();
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateNonIpInterface: ifIndex: " + ifIndex + " has physical address '" + physAddr + "'"));
        }
        if (physAddr != null && physAddr.length() == 12) {
            dbSnmpIfEntry.updatePhysicalAddress(physAddr);
        }
    }

    void updateSpeed(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Long uint;
        try {
            uint = ifte.getIfSpeed();
        }
        catch (Exception e) {
            RescanProcessor.log().warn((Object)("updateNonIpInterface: ifSpeed '" + ifte.getDisplayString("ifSpeed") + "' for ifIndex " + ifIndex + " is invalid, inserting 0: " + e), (Throwable)e);
            uint = null;
        }
        if (uint == null) {
            dbSnmpIfEntry.updateSpeed(0L);
        } else {
            dbSnmpIfEntry.updateSpeed(uint);
        }
    }

    private static Category log() {
        return ThreadCategory.getInstance(RescanProcessor.class);
    }

    private void updateInterface(Connection dbc, Date now, DbNodeEntry node, InetAddress target, InetAddress ifaddr, List<IfCollector.SupportedProtocol> protocols, IfSnmpCollector snmpc, boolean doesSnmp) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateInterface: updating interface " + ifaddr.getHostAddress() + "(targetIf=" + target.getHostAddress() + ")"));
            if (doesSnmp) {
                RescanProcessor.log().debug((Object)("updateInterface: the snmp collection passed in is collected via" + (snmpc == null ? "No SnmpCollection passed in (snmpc == null)" : snmpc.getCollectorTargetAddress().getHostAddress())));
            }
        }
        boolean reparentFlag = false;
        boolean newIpIfEntry = false;
        int ifIndex = -1;
        DbIpInterfaceEntry dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            ifIndex = snmpc.getIfIndex(ifaddr);
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateInterface: interface = " + ifaddr.getHostAddress() + " ifIndex = " + ifIndex + ". Checking for this address on other nodes."));
            }
            IpAddrTable ipAddrTable = null;
            ipAddrTable = snmpc.getIpAddrTable();
            if (ipAddrTable == null) {
                RescanProcessor.log().error((Object)"updateInterface: null ipAddrTable in the snmp collection");
            } else if (ifaddr.getHostAddress().equals("0.0.0.0") || ifaddr.getHostAddress().startsWith("127.")) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateInterface: Skipping address from snmpc ipAddrTable " + ifaddr.getHostAddress()));
                }
            } else {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateInterface: Checking address from snmpc ipAddrTable " + ifaddr.getHostAddress()));
                }
                PreparedStatement stmt = null;
                try {
                    stmt = dbc.prepareStatement("SELECT nodeid FROM ipinterface WHERE ismanaged != 'D' AND ipaddr = ? AND nodeid !=? ");
                    stmt.setString(1, ifaddr.getHostAddress());
                    stmt.setInt(2, node.getNodeId());
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        DbIpInterfaceEntry[] tmpIfArray;
                        DbNodeEntry suspectNodeEntry;
                        int existingNodeId = rs.getInt(1);
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("updateInterface: ckecking for " + ifaddr.getHostAddress() + " on existing nodeid  " + existingNodeId));
                        }
                        if ((suspectNodeEntry = DbNodeEntry.get(dbc, existingNodeId)) == null || !this.areDbInterfacesInSnmpCollection(tmpIfArray = suspectNodeEntry.getInterfaces(dbc), snmpc)) continue;
                        for (int i = 0; i < tmpIfArray.length; ++i) {
                            InetAddress addr = tmpIfArray[i].getIfAddress();
                            int index = snmpc.getIfIndex(addr);
                            if (addr.getHostAddress().equals("0.0.0.0") || addr.getHostAddress().startsWith("127.")) continue;
                            if (RescanProcessor.log().isDebugEnabled()) {
                                RescanProcessor.log().debug((Object)("updateInterface: reparenting interface " + addr.getHostAddress() + " under node: " + node.getNodeId() + " from existing node: " + existingNodeId));
                            }
                            this.reparentInterface(dbc, addr, index, node.getNodeId(), existingNodeId);
                            this.createInterfaceReparentedEvent(node, existingNodeId, addr);
                        }
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("updateInterface: interface " + ifaddr.getHostAddress() + " is added to node: " + node.getNodeId() + " by reparenting from existing " + "node: " + existingNodeId));
                        }
                        dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
                        reparentFlag = true;
                        this.deleteDuplicateNode(dbc, suspectNodeEntry);
                        this.createDuplicateNodeDeletedEvent(suspectNodeEntry);
                    }
                }
                catch (SQLException e) {
                    RescanProcessor.log().error((Object)("SQLException while updating interface: " + ifaddr.getHostAddress() + " on nodeid: " + node.getNodeId()));
                    throw e;
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        if (dbIpIfEntry == null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateInterface: interface " + ifaddr + " ifIndex " + ifIndex + " not in database under nodeid " + node.getNodeId() + ", creating new interface object."));
            }
            if (ifIndex == -1 && !doesSnmp) {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
            } else {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
                dbIpIfEntry.setIfIndex(ifIndex);
            }
            if (this.isDuplicateInterface(dbc, ifaddr, node.getNodeId())) {
                this.createDuplicateIpAddressEvent(dbIpIfEntry);
            }
            newIpIfEntry = true;
        }
        DbIpInterfaceEntry currIpIfEntry = this.getNewDbIpInterfaceEntry(node, snmpc, doesSnmp, ifaddr);
        if (doesSnmp && snmpc != null) {
            this.updateSnmpInfo(dbc, node, snmpc, currIpIfEntry.getIfAddress(), currIpIfEntry.getIfIndex());
        }
        this.updateInterfaceInfo(dbc, now, node, dbIpIfEntry, currIpIfEntry, newIpIfEntry, reparentFlag);
        this.updateServiceInfo(dbc, node, dbIpIfEntry, newIpIfEntry, protocols);
    }

    private void deleteDuplicateNode(Connection dbc, DbNodeEntry duplicateNode) throws SQLException {
        PreparedStatement ifStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_INTERFACE);
        PreparedStatement svcStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SERVICES);
        PreparedStatement snmpStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SNMPINTERFACE);
        try {
            ifStmt.setInt(1, duplicateNode.getNodeId());
            svcStmt.setInt(1, duplicateNode.getNodeId());
            snmpStmt.setInt(1, duplicateNode.getNodeId());
            ifStmt.executeUpdate();
            svcStmt.executeUpdate();
            snmpStmt.executeUpdate();
            duplicateNode.setNodeType('D');
            duplicateNode.store(dbc);
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error((Object)("deleteDuplicateNode  SQLException while deleting duplicate node: " + duplicateNode.getNodeId()));
            throw sqlE;
        }
        finally {
            try {
                ifStmt.close();
                svcStmt.close();
                snmpStmt.close();
            }
            catch (SQLException e) {}
        }
    }

    private boolean isDuplicateInterface(Connection dbc, InetAddress ifaddr, int nodeId) throws SQLException {
        boolean duplicate = false;
        PreparedStatement stmt = null;
        try {
            stmt = dbc.prepareStatement("SELECT nodeid FROM ipinterface WHERE ismanaged != 'D' AND ipaddr = ? AND nodeid !=? ");
            stmt.setString(1, ifaddr.getHostAddress());
            stmt.setInt(2, nodeId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                duplicate = true;
            }
            boolean bl = duplicate;
            return bl;
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error((Object)("isDuplicateInterface: SQLException while updating interface: " + ifaddr.getHostAddress() + " on nodeid: " + nodeId));
            throw sqlE;
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
    }

    private void updateInterfaceInfo(Connection dbc, Date now, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIpInterfaceEntry currIpIfEntry, boolean isNewIpEntry, boolean isReparented) throws SQLException {
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIpInterfaceEntry originalIpIfEntry = DbIpInterfaceEntry.clone(dbIpIfEntry);
        dbIpIfEntry.setLastPoll(now);
        dbIpIfEntry.updateHostname(currIpIfEntry.getHostname());
        dbIpIfEntry.updateManagedState(currIpIfEntry.getManagedState());
        dbIpIfEntry.updateStatus(currIpIfEntry.getStatus());
        dbIpIfEntry.updatePrimaryState(currIpIfEntry.getPrimaryState());
        dbIpIfEntry.updateIfIndex(currIpIfEntry.getIfIndex());
        boolean ifIndexChangedFlag = false;
        boolean ipHostnameChangedFlag = false;
        if (dbIpIfEntry.hasIfIndexChanged()) {
            ifIndexChangedFlag = true;
        }
        if (dbIpIfEntry.hasHostnameChanged()) {
            ipHostnameChangedFlag = true;
        }
        dbIpIfEntry.store(dbc);
        if (isNewIpEntry && !isReparented) {
            this.createNodeGainedInterfaceEvent(dbIpIfEntry);
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateInterfaceInfo: ifIndex changed: " + ifIndexChangedFlag));
        }
        if (ifIndexChangedFlag) {
            this.createInterfaceIndexChangedEvent(dbIpIfEntry, originalIpIfEntry);
            this.m_ifIndexOnNodeChangedFlag = true;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateInterfaceInfo: hostname changed: " + ipHostnameChangedFlag));
        }
        if (ipHostnameChangedFlag) {
            this.createIpHostNameChangedEvent(dbIpIfEntry, originalIpIfEntry);
        }
        if (isNewIpEntry) {
            boolean ipToBePolled = false;
            RescanProcessor.log().debug((Object)("updateInterfaceInfo: rebuilding PackageIpListMap for new interface " + ifaddr.getHostAddress()));
            PollerConfigFactory.getInstance().rebuildPackageIpListMap();
            Package ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddr.getHostAddress());
            if (ipPkg != null) {
                ipToBePolled = true;
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateInterfaceInfo: interface " + ifaddr.getHostAddress() + " to be polled: " + ipToBePolled));
            }
            if (ipToBePolled) {
                PreparedStatement stmt = dbc.prepareStatement(SQL_DB_UPDATE_ISMANAGED);
                stmt.setString(1, new String(new char[]{'M'}));
                stmt.setInt(2, dbIpIfEntry.getNodeId());
                stmt.setString(3, ifaddr.getHostAddress());
                try {
                    stmt.executeUpdate();
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug((Object)("updateInterfaceInfo: updated managed state for new interface " + ifaddr.getHostAddress() + " on node " + dbIpIfEntry.getNodeId() + " to managed"));
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private DbIpInterfaceEntry getNewDbIpInterfaceEntry(DbNodeEntry node, IfSnmpCollector snmpc, boolean doesSnmp, InetAddress ifaddr) {
        DbIpInterfaceEntry currIpIfEntry;
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        int ifIndex = -1;
        if (doesSnmp) {
            if (snmpc != null && snmpc.hasIpAddrTable()) {
                ifIndex = snmpc.getIfIndex(ifaddr);
            }
            if (ifIndex == -1) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateInterfaceInfo: interface " + ifaddr.getHostAddress() + " has no valid ifIndex. Assuming this is a " + "lame SNMP host with no ipAddrTable"));
                }
                ifIndex = -100;
            }
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
        } else {
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
        }
        currIpIfEntry.setHostname(ifaddr.getHostName());
        Package ipPkg = null;
        if (cFactory.isAddressUnmanaged(ifaddr)) {
            currIpIfEntry.setManagedState('U');
        } else {
            boolean ipToBePolled = false;
            ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddr.getHostAddress());
            if (ipPkg != null) {
                ipToBePolled = true;
            }
            if (ipToBePolled) {
                currIpIfEntry.setManagedState('M');
            } else {
                currIpIfEntry.setManagedState('N');
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateInterfaceInfo: interface " + ifaddr.getHostAddress() + " to be polled = " + ipToBePolled));
            }
        }
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            if (ifIndex != -1) {
                if (snmpc.hasIfTable()) {
                    int status = snmpc.getAdminStatus(ifIndex);
                    currIpIfEntry.setStatus(status);
                }
            } else {
                RescanProcessor.log().debug((Object)("updateInterfaceInfo:  No ifIndex found for " + ifaddr.getHostAddress() + ". Not eligible for primary SNMP interface"));
            }
            currIpIfEntry.setPrimaryState('N');
        } else if (doesSnmp) {
            currIpIfEntry.setPrimaryState('N');
        }
        return currIpIfEntry;
    }

    private void updateServiceInfo(Connection dbc, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, boolean isNewIpEntry, List<IfCollector.SupportedProtocol> protocols) throws SQLException {
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        Package ipPkg = null;
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIfServiceEntry[] dbSupportedServices = dbIpIfEntry.getServices(dbc);
        int ifIndex = dbIpIfEntry.getIfIndex();
        if (RescanProcessor.log().isDebugEnabled()) {
            if (ifIndex == -1) {
                RescanProcessor.log().debug((Object)("updateServiceInfo: Retrieving interface's service list from database for host " + dbIpIfEntry.getHostname()));
            } else {
                RescanProcessor.log().debug((Object)("updateServiceInfo: Retrieving interface's service list from database for host " + dbIpIfEntry.getHostname() + " ifindex " + ifIndex));
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateServiceInfo: Checking for new services on host " + dbIpIfEntry.getHostname()));
        }
        for (IfCollector.SupportedProtocol p : protocols) {
            Integer sid = this.m_capsdDbSyncer.getServiceId(p.getProtocolName());
            boolean found = false;
            for (int i = 0; i < dbSupportedServices.length && !found; ++i) {
                if (dbSupportedServices[i].getServiceId() != ((Number)sid).intValue()) continue;
                found = true;
            }
            if (!found) {
                DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.create(node.getNodeId(), ifaddr, sid);
                if (cFactory.isAddressUnmanaged(ifaddr)) {
                    ifSvcEntry.setStatus('U');
                } else {
                    ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddr.getHostAddress());
                    if (this.isServicePolledLocally(ifaddr.getHostAddress(), p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('A');
                    } else if (this.isServicePolled(ifaddr.getHostAddress(), p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('X');
                    } else {
                        ifSvcEntry.setStatus('N');
                    }
                }
                if (p.getQualifiers() != null && p.getQualifiers().get("port") != null) {
                    try {
                        Integer port = (Integer)p.getQualifiers().get("port");
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("updateServiceInfo: got a port qualifier: " + port + " for service: " + p.getProtocolName()));
                        }
                        ifSvcEntry.setQualifier(port.toString());
                    }
                    catch (ClassCastException ccE) {
                        // empty catch block
                    }
                }
                ifSvcEntry.setSource('P');
                ifSvcEntry.setNotify('Y');
                if (ifIndex != -1) {
                    ifSvcEntry.setIfIndex(ifIndex);
                }
                ifSvcEntry.store();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateIfServices: update service: " + p.getProtocolName() + " for interface:" + ifaddr.getHostAddress() + " on node:" + node.getNodeId()));
                }
                this.createNodeGainedServiceEvent(node, dbIpIfEntry, p.getProtocolName());
                if (!isNewIpEntry && p.getProtocolName().equalsIgnoreCase("SNMP")) {
                    this.createInterfaceSupportsSNMPEvent(dbIpIfEntry);
                }
            }
            dbSupportedServices = dbIpIfEntry.getServices(dbc);
        }
        if (this.m_forceRescan) {
            this.updateServicesOnForcedRescan(node, dbIpIfEntry, dbSupportedServices);
        }
    }

    private boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolled(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    private boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !ipPkg.getRemote() && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolledLocally(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServicesOnForcedRescan(DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIfServiceEntry[] dbSupportedServices) throws SQLException {
        Integer id;
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        Package ipPkg = null;
        boolean ipToBePolled = false;
        ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddr.getHostAddress());
        if (ipPkg != null) {
            ipToBePolled = true;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("updateServicesOnForcedRescan: Checking status of existing services on host " + ifaddr));
        }
        Connection ctest = null;
        ResultSet rs = null;
        HashMap<Integer, String> serviceNames = new HashMap<Integer, String>();
        try {
            ctest = DataSourceFactory.getInstance().getConnection();
            PreparedStatement loadStmt = ctest.prepareStatement(SQL_RETRIEVE_SERVICE_IDS);
            rs = loadStmt.executeQuery();
            while (rs.next()) {
                id = new Integer(rs.getInt(1));
                String name = rs.getString(2);
                serviceNames.put(id, name);
            }
        }
        catch (Throwable t) {
            RescanProcessor.log().error((Object)"Error reading services table", t);
        }
        finally {
            try {
                if (ctest != null) {
                    ctest.close();
                }
            }
            catch (SQLException e) {
                RescanProcessor.log().error((Object)"Error closing connection", (Throwable)e);
            }
        }
        for (int i = 0; i < dbSupportedServices.length; ++i) {
            id = new Integer(dbSupportedServices[i].getServiceId());
            String sn = ((String)serviceNames.get(id)).toString();
            DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.get(node.getNodeId(), ifaddr, dbSupportedServices[i].getServiceId());
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateServicesOnForcedRescan: old status for nodeId " + node.getNodeId() + ", ifaddr " + ifaddr + ", serviceId " + dbSupportedServices[i].getServiceId() + " = " + ifSvcEntry.getStatus()));
            }
            boolean svcChangeToActive = false;
            boolean svcChangeToNotPolled = false;
            boolean svcChangeToForced = false;
            if (!cFactory.isAddressUnmanaged(ifaddr)) {
                boolean svcToBePolled = false;
                if (ipToBePolled) {
                    if (ipPkg == null) {
                        ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddr.getHostAddress());
                    }
                    if (ipPkg != null) {
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("updateServicesOnForcedRescan: Is service to be polled for package = " + ipPkg.getName() + ", service = " + sn));
                        }
                        if (!(svcToBePolled = pollerCfgFactory.isPolled(sn, ipPkg))) {
                            if (RescanProcessor.log().isDebugEnabled()) {
                                RescanProcessor.log().debug((Object)("updateServicesOnForcedRescan: Is service to be polled for ifaddr = " + ifaddr.getHostAddress() + ", service = " + sn));
                            }
                            svcToBePolled = pollerCfgFactory.isPolled(ifaddr.getHostAddress(), sn);
                        }
                        if (!svcToBePolled) {
                            RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: Service not to be polled");
                        }
                    } else {
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: No poller package found");
                    }
                } else {
                    RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: Service not polled because interface is not polled");
                }
                if (ifSvcEntry.getStatus() == 'F') {
                    if (svcToBePolled) {
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = FORCED. No action taken.");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = FORCED. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'S') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('F');
                        svcChangeToForced = true;
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = SUSPEND. Changed to FORCED");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = SUSPEND. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'R') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('A');
                        svcChangeToActive = true;
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = RESUME. Changed to ACTIVE");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: status = RESUME. Changed to NOT_POLLED");
                    }
                } else if (svcToBePolled && ifSvcEntry.getStatus() != 'A') {
                    ifSvcEntry.updateStatus('A');
                    svcChangeToActive = true;
                    RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: New status = ACTIVE");
                } else if (!svcToBePolled && ifSvcEntry.getStatus() == 'A') {
                    ifSvcEntry.updateStatus('N');
                    svcChangeToNotPolled = true;
                    RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: New status = NOT_POLLED");
                } else {
                    RescanProcessor.log().debug((Object)"updateServicesOnForcedRescan: Status Unchanged");
                }
            }
            if (svcChangeToActive) {
                ifSvcEntry.store();
                this.createResumePollingServiceEvent(node, dbIpIfEntry, sn);
                continue;
            }
            if (!svcChangeToNotPolled && !svcChangeToForced) continue;
            ifSvcEntry.store();
            this.createSuspendPollingServiceEvent(node, dbIpIfEntry, sn);
        }
    }

    private void updateSnmpInfo(Connection dbc, DbNodeEntry node, IfSnmpCollector snmpc, InetAddress ifaddr, int ifIndex) throws SQLException {
        if (snmpc != null && !snmpc.failed() && ifIndex != -1) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateSnmpInfo: updating snmp interface for nodeId/ifIndex=" + node.getNodeId() + "/" + ifIndex));
            }
            boolean newSnmpIfTableEntry = false;
            DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
            if (dbSnmpIfEntry == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object."));
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
                newSnmpIfTableEntry = true;
            }
            DbSnmpInterfaceEntry currSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            IfTable ift = snmpc.getIfTable();
            Iterator ifiter = ift.getEntries().iterator();
            IfTableEntry ifte = null;
            while (ifiter.hasNext()) {
                ifte = (IfTableEntry)((Object)ifiter.next());
                Integer sint = ifte.getIfIndex();
                if (sint == null) continue;
                if (ifIndex == sint) break;
                ifte = null;
            }
            if (ifte == null && ifIndex == -100) {
                currSnmpIfEntry.setIfAddress(snmpc.getCollectorTargetAddress());
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: interface " + snmpc.getCollectorTargetAddress().getHostAddress() + " appears to be a lame SNMP host. Setting ipaddr only."));
                }
            } else if (ifte != null) {
                String ifAlias;
                Long uint;
                InetAddress[] aaddrs = snmpc.getIfAddressAndMask(ifIndex);
                if (aaddrs == null) {
                    RescanProcessor.log().warn((Object)("updateSnmpInfo: unable to retrieve address and netmask for nodeId/ifIndex: " + node.getNodeId() + "/" + ifIndex));
                    aaddrs = new InetAddress[]{ifaddr, null};
                }
                currSnmpIfEntry.setIfAddress(aaddrs[0]);
                if (aaddrs[1] != null) {
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug((Object)("updateSnmpInfo: interface " + aaddrs[0].getHostAddress() + " has netmask: " + aaddrs[1].getHostAddress()));
                    }
                    currSnmpIfEntry.setNetmask(aaddrs[1]);
                }
                Integer sint = ifte.getIfType();
                currSnmpIfEntry.setType(sint);
                String str = ifte.getIfDescr();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: " + ifaddr + " has ifDescription: " + str));
                }
                if (str != null && str.length() > 0) {
                    currSnmpIfEntry.setDescription(str);
                }
                String physAddr = ifte.getPhysAddr();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: " + ifaddr + " has phys address: -" + physAddr + "-"));
                }
                if (physAddr != null && physAddr.length() == 12) {
                    currSnmpIfEntry.setPhysicalAddress(physAddr);
                }
                currSnmpIfEntry.setSpeed((uint = ifte.getIfSpeed()) == null ? 10000000L : uint);
                sint = ifte.getIfAdminStatus();
                currSnmpIfEntry.setAdminStatus(sint == null ? 0 : sint);
                sint = ifte.getIfOperStatus();
                currSnmpIfEntry.setOperationalStatus(sint == null ? 0 : sint);
                String ifName = snmpc.getIfName(ifIndex);
                if (ifName != null && ifName.length() > 0) {
                    currSnmpIfEntry.setName(ifName);
                }
                if ((ifAlias = snmpc.getIfAlias(ifIndex)) != null) {
                    currSnmpIfEntry.setAlias(ifAlias);
                } else {
                    currSnmpIfEntry.setAlias("");
                }
            }
            dbSnmpIfEntry.updateIfAddress(currSnmpIfEntry.getIfAddress());
            dbSnmpIfEntry.updateNetmask(currSnmpIfEntry.getNetmask());
            dbSnmpIfEntry.updatePhysicalAddress(currSnmpIfEntry.getPhysicalAddress());
            dbSnmpIfEntry.updateDescription(currSnmpIfEntry.getDescription());
            dbSnmpIfEntry.updateName(currSnmpIfEntry.getName());
            dbSnmpIfEntry.updateType(currSnmpIfEntry.getType());
            dbSnmpIfEntry.updateSpeed(currSnmpIfEntry.getSpeed());
            dbSnmpIfEntry.updateAdminStatus(currSnmpIfEntry.getAdminStatus());
            dbSnmpIfEntry.updateOperationalStatus(currSnmpIfEntry.getOperationalStatus());
            dbSnmpIfEntry.updateAlias(currSnmpIfEntry.getAlias());
            if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasIfAddressChanged() || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
                this.m_snmpIfTableChangedFlag = true;
            }
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null && snmpc.hasIpAddrTable() && ifIndex != -1) {
            DbSnmpInterfaceEntry dbSnmpIfEntry;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateSnmpInfo: updating snmp interface for nodeId/ifIndex/ipAddr=" + node.getNodeId() + "/" + ifIndex + "/" + ifaddr + " based on ipAddrTable only - No ifTable " + "available"));
            }
            if ((dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex)) == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object."));
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            }
            DbSnmpInterfaceEntry currSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            currSnmpIfEntry.setIfAddress(ifaddr);
            dbSnmpIfEntry.updateIfAddress(currSnmpIfEntry.getIfAddress());
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null) {
            DbSnmpInterfaceEntry dbSnmpIfEntry;
            ifIndex = -100;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updateSnmpInfo: updating snmp interface for nodeId/ipAddr=" + node.getNodeId() + "/" + ifaddr + " based on ip address only - No ipAddrTable " + "available"));
            }
            if ((dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex)) == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object."));
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            }
            DbSnmpInterfaceEntry currSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            currSnmpIfEntry.setIfAddress(ifaddr);
            dbSnmpIfEntry.updateIfAddress(currSnmpIfEntry.getIfAddress());
            dbSnmpIfEntry.store(dbc);
        }
    }

    private void reparentInterface(Connection dbc, InetAddress ifAddr, int ifIndex, int newNodeId, int oldNodeId) throws SQLException {
        String ipaddr = ifAddr.getHostAddress();
        PreparedStatement ifLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_LOOKUP);
        PreparedStatement ifDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_DELETE);
        PreparedStatement ipInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE);
        PreparedStatement snmpIfLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_LOOKUP);
        PreparedStatement snmpIfDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_DELETE);
        PreparedStatement snmpInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_INTERFACE);
        PreparedStatement ifServicesLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_LOOKUP);
        PreparedStatement ifServicesDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_DELETE);
        PreparedStatement ifServicesStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES);
        try {
            ResultSet rs;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("reparentInterface: reparenting address/ifIndex/nodeID: " + ipaddr + "/" + ifIndex + "/" + newNodeId));
            }
            if (ifIndex < 1) {
                RescanProcessor.log().debug((Object)"reparentInterface: don't have a valid ifIndex, skipping snmpInterface table reparenting.");
            } else {
                boolean alreadyExists = false;
                snmpIfLookupStmt.setInt(1, newNodeId);
                snmpIfLookupStmt.setString(2, ipaddr);
                snmpIfLookupStmt.setInt(3, ifIndex);
                rs = snmpIfLookupStmt.executeQuery();
                if (rs.next()) {
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in snmpinterface table, deleting from under old node " + oldNodeId));
                    }
                    alreadyExists = true;
                    snmpIfDeleteStmt.setInt(1, oldNodeId);
                    snmpIfDeleteStmt.setString(2, ipaddr);
                    snmpIfDeleteStmt.setInt(3, ifIndex);
                    snmpIfDeleteStmt.executeUpdate();
                }
                if (!alreadyExists) {
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in snmpinterface table, reparenting."));
                    }
                    snmpInterfaceStmt.setInt(1, newNodeId);
                    snmpInterfaceStmt.setInt(2, oldNodeId);
                    snmpInterfaceStmt.setString(3, ipaddr);
                    snmpInterfaceStmt.setInt(4, ifIndex);
                    snmpInterfaceStmt.executeUpdate();
                }
            }
            boolean ifAlreadyExists = false;
            ifLookupStmt.setInt(1, newNodeId);
            ifLookupStmt.setString(2, ipaddr);
            rs = ifLookupStmt.executeQuery();
            if (rs.next()) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in ipinterface table, deleting from under old node " + oldNodeId));
                }
                ifAlreadyExists = true;
                ifDeleteStmt.setInt(1, oldNodeId);
                ifDeleteStmt.setString(2, ipaddr);
                ifDeleteStmt.executeUpdate();
            }
            if (!ifAlreadyExists) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in ipinterface table, reparenting."));
                }
                ipInterfaceStmt.setInt(1, newNodeId);
                ipInterfaceStmt.setInt(2, oldNodeId);
                ipInterfaceStmt.setString(3, ipaddr);
                ipInterfaceStmt.executeUpdate();
            }
            boolean ifsAlreadyExists = false;
            ifServicesLookupStmt.setInt(1, newNodeId);
            ifServicesLookupStmt.setString(2, ipaddr);
            ifServicesLookupStmt.setInt(3, ifIndex);
            rs = ifServicesLookupStmt.executeQuery();
            if (rs.next()) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in ifservices table, deleting from under old node " + oldNodeId));
                }
                ifsAlreadyExists = true;
                ifServicesDeleteStmt.setInt(1, oldNodeId);
                ifServicesDeleteStmt.setString(2, ipaddr);
                ifServicesDeleteStmt.executeUpdate();
            }
            if (!ifsAlreadyExists) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in ifservices table, reparenting."));
                }
                ifServicesStmt.setInt(1, newNodeId);
                ifServicesStmt.setInt(2, oldNodeId);
                ifServicesStmt.setString(3, ipaddr);
                ifServicesStmt.executeUpdate();
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("reparentInterface: reparented " + ipaddr + " : ifIndex: " + ifIndex + " : oldNodeID: " + oldNodeId + " newNodeID: " + newNodeId));
            }
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error((Object)("SQLException while reparenting addr/ifindex/nodeid " + ipaddr + "/" + ifIndex + "/" + oldNodeId));
            throw sqlE;
        }
        finally {
            try {
                ifLookupStmt.close();
                ifDeleteStmt.close();
                ipInterfaceStmt.close();
                snmpIfLookupStmt.close();
                snmpIfDeleteStmt.close();
                snmpInterfaceStmt.close();
                ifServicesLookupStmt.close();
                ifServicesDeleteStmt.close();
                ifServicesStmt.close();
            }
            catch (SQLException e) {}
        }
    }

    private static List<InetAddress> buildLBSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            RescanProcessor.log().debug((Object)"buildLBSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        if (!snmpc.hasIfTable()) {
            RescanProcessor.log().debug((Object)"buildLBSnmpAddressList: no SNMP ifTable available...");
            return addresses;
        }
        Collection<IfCollector> values = collectorMap.values();
        for (IfCollector ifc : values) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc) && SuspectEventProcessor.getIfType(ifaddr, snmpc) == 24) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("buildLBSnmpAddressList: adding target interface " + ifaddr.getHostAddress() + " temporarily marked as primary!"));
                }
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress xifaddr : subTargets.keySet()) {
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(subTargets.get(xifaddr)) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc) || SuspectEventProcessor.getIfType(xifaddr, snmpc) != 24) continue;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("buildLBSnmpAddressList: adding subtarget interface " + xifaddr.getHostAddress() + " temporarily marked as primary!"));
                }
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private static List<InetAddress> buildSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            RescanProcessor.log().debug((Object)"buildSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        Collection<IfCollector> values = collectorMap.values();
        for (IfCollector ifc : values) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc)) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("buildSnmpAddressList: adding target interface " + ifaddr.getHostAddress() + " temporarily marked as primary!"));
                }
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress xifaddr : subTargets.keySet()) {
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(subTargets.get(xifaddr)) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc)) continue;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("buildSnmpAddressList: adding subtarget interface " + xifaddr.getHostAddress() + " temporarily marked as primary!"));
                }
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private InetAddress determinePrimaryIpInterface(Map<String, IfCollector> collectorMap) {
        Collection<IfCollector> values = collectorMap.values();
        Iterator<IfCollector> iter = values.iterator();
        InetAddress primaryIf = null;
        while (iter.hasNext()) {
            IfCollector ifc = iter.next();
            InetAddress currIf2 = ifc.getTarget();
            if (primaryIf == null) {
                primaryIf = currIf2;
                continue;
            }
            primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf2, primaryIf);
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress currIf2 : subTargets.keySet()) {
                primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf2, primaryIf);
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            if (primaryIf != null) {
                RescanProcessor.log().debug((Object)("determinePrimaryIpInterface: selected primary interface: " + primaryIf.getHostAddress()));
            } else {
                RescanProcessor.log().debug((Object)"determinePrimaryIpInterface: no primary interface found");
            }
        }
        return primaryIf;
    }

    private void setNodeLabelAndSmbInfo(Map<String, IfCollector> collectorMap, DbNodeEntry dbNodeEntry, DbNodeEntry currNodeEntry, InetAddress currPrimarySnmpIf) {
        IfSmbCollector smbc;
        Collection<IfCollector> values;
        boolean labelSet = false;
        InetAddress primaryIf = null;
        if (!labelSet) {
            primaryIf = currPrimarySnmpIf != null ? currPrimarySnmpIf : this.determinePrimaryIpInterface(collectorMap);
            if (primaryIf == null) {
                RescanProcessor.log().error((Object)"setNodeLabelAndSmbInfo: failed to find primary interface...");
            } else {
                String hostName = primaryIf.getHostName();
                if (!hostName.equals(primaryIf.getHostAddress())) {
                    labelSet = true;
                    currNodeEntry.setLabel(hostName);
                    currNodeEntry.setLabelSource('H');
                }
            }
        }
        IfSmbCollector savedSmbcRef = null;
        if (dbNodeEntry.getNetBIOSName() != null) {
            values = collectorMap.values();
            Iterator<IfCollector> iter = values.iterator();
            while (iter.hasNext() && !labelSet) {
                IfCollector ifc = iter.next();
                smbc = ifc.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
                String netbiosName = smbc.getNbtName().toUpperCase();
                if (!netbiosName.equals(dbNodeEntry.getNetBIOSName())) continue;
                labelSet = true;
                currNodeEntry.setLabel(netbiosName);
                currNodeEntry.setLabelSource('N');
                currNodeEntry.setNetBIOSName(netbiosName);
                if (smbc.getDomainName() != null) {
                    currNodeEntry.setDomainName(smbc.getDomainName());
                }
                if (smbc.getOS() == null) continue;
                currNodeEntry.setOS(smbc.getOS());
            }
        } else {
            values = collectorMap.values();
            for (IfCollector ifc : values) {
                smbc = ifc.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
            }
        }
        if (!labelSet && savedSmbcRef != null) {
            labelSet = true;
            currNodeEntry.setLabel(savedSmbcRef.getNbtName());
            currNodeEntry.setLabelSource('N');
            currNodeEntry.setNetBIOSName(currNodeEntry.getLabel());
            if (savedSmbcRef.getDomainName() != null) {
                currNodeEntry.setDomainName(savedSmbcRef.getDomainName());
            }
            if (savedSmbcRef.getOS() != null) {
                currNodeEntry.setOS(savedSmbcRef.getOS());
            }
        }
        if (!labelSet && currPrimarySnmpIf != null) {
            IfCollector ifc2 = collectorMap.get(currPrimarySnmpIf.getHostAddress());
            if (ifc2 == null) {
                Collection<IfCollector> collectors = collectorMap.values();
                for (IfCollector ifc2 : collectors) {
                    if (ifc2.getSnmpCollector() != null) break;
                }
            }
            if (ifc2 == null || ifc2.getSnmpCollector() == null) {
                RescanProcessor.log().warn((Object)("setNodeLabelAndSmbInfo: primary SNMP interface set to " + currPrimarySnmpIf.getHostAddress() + " but no SNMP collector found."));
            } else {
                IfSnmpCollector snmpc = ifc2.getSnmpCollector();
                SystemGroup sysgrp = snmpc.getSystemGroup();
                String str = sysgrp.getSysName();
                if (str != null && str.length() > 0) {
                    labelSet = true;
                    currNodeEntry.setLabel(str);
                    currNodeEntry.setLabelSource('S');
                }
            }
        }
        if (!labelSet) {
            if (primaryIf != null) {
                currNodeEntry.setLabel(primaryIf.getHostAddress());
                currNodeEntry.setLabelSource('A');
            } else {
                currNodeEntry.setLabel(dbNodeEntry.getLabel());
                currNodeEntry.setLabelSource(dbNodeEntry.getLabelSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNodeDeleted(Connection dbc, int nodeId) throws SQLException {
        boolean nodeDeleted = false;
        PreparedStatement stmt = null;
        try {
            char nodeType;
            stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_NODE_TYPE);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            String nodeTypeStr = rs.getString(1);
            if (!rs.wasNull() && (nodeType = nodeTypeStr.charAt(0)) == 'D') {
                nodeDeleted = true;
            }
            rs.close();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
        return nodeDeleted;
    }

    private boolean areDbInterfacesInSnmpCollection(DbIpInterfaceEntry[] dbInterfaces, IfSnmpCollector snmpc) {
        if (dbInterfaces == null || snmpc == null) {
            RescanProcessor.log().error((Object)"areDbInterfacesInSnmpCollection: empty dbInterfaces or IfSnmpCollector.");
            return false;
        }
        if (!snmpc.hasIpAddrTable()) {
            RescanProcessor.log().error((Object)"areDbInterfacesInSnmpCollection: Snmp Collector failed.");
            return false;
        }
        IpAddrTable ipAddrTable = null;
        if (snmpc.hasIpAddrTable()) {
            ipAddrTable = snmpc.getIpAddrTable();
        }
        if (ipAddrTable == null) {
            RescanProcessor.log().error((Object)"areDbInterfacesInSnmpCollection: null ipAddrTable in the snmp collection");
            return false;
        }
        List<InetAddress> ipAddrList = ipAddrTable.getIpAddresses();
        for (DbIpInterfaceEntry dbInterface : dbInterfaces) {
            InetAddress ipaddr = dbInterface.getIfAddress();
            if (ipaddr.getHostAddress().equals("0.0.0.0") || ipaddr.getHostAddress().startsWith("127.")) continue;
            boolean found = false;
            for (InetAddress addr : ipAddrList) {
                if (addr.getHostAddress().equals("0.0.0.0") || addr.getHostAddress().startsWith("127.") || !ipaddr.getHostAddress().equals(addr.getHostAddress())) continue;
                found = true;
                if (!RescanProcessor.log().isDebugEnabled()) break;
                RescanProcessor.log().debug((Object)("areDbInterfacesInSnmpCollection: found match for ipaddress: " + ipaddr.getHostAddress()));
                break;
            }
            if (found) continue;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("areDbInterfacesInSnmpCollection: ipaddress : " + ipaddr.getHostAddress() + " not in the snmp collection. Snmp collection may not be usable."));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object snmpc;
        DbIpInterfaceEntry[] dbInterfaces;
        DbNodeEntry dbNodeEntry = this.getNode();
        if (dbNodeEntry == null) {
            return;
        }
        if (dbNodeEntry.getForeignSource() != null) {
            RescanProcessor.log().info((Object)("Skipping rescan of node " + this.getNodeId() + " since it was imported with foreign source " + dbNodeEntry.getForeignSource()));
            return;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("start rescanning node: " + this.getNodeId()));
        }
        if ((dbInterfaces = this.getInterfaces(dbNodeEntry)) == null) {
            RescanProcessor.log().debug((Object)("no interfaces found in the database to rescan for node: " + this.getNodeId()));
            return;
        }
        boolean doesSnmp = true;
        IpAddrTable ipAddTable = null;
        List<InetAddress> prevAddrList = null;
        boolean snmpcAgree = false;
        boolean gotSnmpc = false;
        HashMap<String, IfCollector> collectorMap = new HashMap<String, IfCollector>();
        HashMap<String, IfCollector> nonSnmpCollectorMap = new HashMap<String, IfCollector>();
        HashSet<InetAddress> probedAddrs = new HashSet<InetAddress>();
        boolean gotSnmpCollection = false;
        DbIpInterfaceEntry oldPrimarySnmpInterface = DbNodeEntry.getPrimarySnmpInterface(dbInterfaces);
        if (oldPrimarySnmpInterface != null) {
            gotSnmpCollection = this.scanPrimarySnmpInterface(oldPrimarySnmpInterface, collectorMap, probedAddrs);
        }
        if (!gotSnmpCollection) {
            for (int i = 0; i < dbInterfaces.length; ++i) {
                InetAddress ifaddr = dbInterfaces[i].getIfAddress();
                if (ifaddr.getHostAddress().startsWith("127") || ifaddr.getHostAddress().equals("0.0.0.0")) continue;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("running collection for " + ifaddr.getHostAddress()));
                }
                IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
                collector.run();
                snmpc = collector.getSnmpCollector();
                if (snmpc != null) {
                    gotSnmpc = true;
                }
                if (snmpc != null && ((IfSnmpCollector)snmpc).hasIpAddrTable() && ((IfSnmpCollector)snmpc).getIfIndex(((IfSnmpCollector)snmpc).getCollectorTargetAddress()) != -1) {
                    if (this.areDbInterfacesInSnmpCollection(dbInterfaces, (IfSnmpCollector)snmpc)) {
                        collectorMap.put(ifaddr.getHostAddress(), collector);
                        gotSnmpCollection = true;
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("SNMP data collected via " + ifaddr.getHostAddress()));
                            RescanProcessor.log().debug((Object)("Adding " + ifaddr.getHostAddress() + " to collectorMap for node: " + this.getNodeId()));
                        }
                        snmpcAgree = false;
                        break;
                    }
                    if (ipAddTable == null) {
                        snmpcAgree = true;
                        collectorMap.put(ifaddr.getHostAddress(), collector);
                        ipAddTable = ((IfSnmpCollector)snmpc).getIpAddrTable();
                        prevAddrList = ipAddTable.getIpAddresses();
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug((Object)("SNMP data collected via " + ifaddr.getHostAddress() + " does not agree with database.  " + "Tentatively adding to the " + "collectorMap and continuing"));
                            for (InetAddress a : prevAddrList) {
                                RescanProcessor.log().debug((Object)("IP address in list = " + a));
                            }
                        }
                    } else if (ipAddTable != null && snmpcAgree) {
                        ipAddTable = ((IfSnmpCollector)snmpc).getIpAddrTable();
                        List<InetAddress> addrList = ipAddTable.getIpAddresses();
                        boolean listMatch = true;
                        String jstring = null;
                        String kstring = null;
                        Iterator<InetAddress> j = prevAddrList.iterator();
                        Iterator<InetAddress> k = addrList.iterator();
                        while (j.hasNext()) {
                            jstring = j.next().toString();
                            if (k.hasNext()) {
                                kstring = k.next().toString();
                                if (jstring.equals(kstring)) {
                                    if (!RescanProcessor.log().isDebugEnabled()) continue;
                                    RescanProcessor.log().debug((Object)(jstring + " = " + kstring));
                                    continue;
                                }
                                if (RescanProcessor.log().isDebugEnabled()) {
                                    RescanProcessor.log().debug((Object)(jstring + " != " + kstring));
                                }
                                listMatch = false;
                                continue;
                            }
                            listMatch = false;
                        }
                        if (k.hasNext()) {
                            listMatch = false;
                        }
                        if (listMatch) {
                            RescanProcessor.log().debug((Object)"Current and previous address lists match");
                        } else {
                            RescanProcessor.log().debug((Object)"Current and previous address lists DO NOT match");
                            snmpcAgree = false;
                        }
                        collector.deleteSnmpCollector();
                    }
                    if (snmpcAgree || !RescanProcessor.log().isDebugEnabled()) continue;
                    RescanProcessor.log().debug((Object)("SNMP data collected via " + ifaddr.getHostAddress() + " does not agree with database or with " + "other interface(s) on this node."));
                    continue;
                }
                nonSnmpCollectorMap.put(ifaddr.getHostAddress(), collector);
                if (!RescanProcessor.log().isDebugEnabled()) continue;
                RescanProcessor.log().debug((Object)("Adding " + ifaddr.getHostAddress() + " to nonSnmpCollectorMap for node: " + this.getNodeId()));
            }
        }
        if (!gotSnmpCollection && !snmpcAgree) {
            collectorMap = nonSnmpCollectorMap;
            if (nonSnmpCollectorMap.size() == 1 && gotSnmpc) {
                doesSnmp = true;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug((Object)("node " + this.getNodeId() + " appears to be a lame SNMP host... " + "Proceeding"));
                }
            } else {
                doesSnmp = false;
                if (RescanProcessor.log().isDebugEnabled()) {
                    if (!gotSnmpc) {
                        RescanProcessor.log().debug((Object)("Could not collect SNMP data for node: " + this.getNodeId()));
                    } else {
                        RescanProcessor.log().debug((Object)("Not using SNMP data for node: " + this.getNodeId() + ".  " + "Collection does not agree with database."));
                    }
                }
            }
        } else if (snmpcAgree) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("SNMP collection for node: " + this.getNodeId() + " does not agree with database, but there is no " + "conflict among the interfaces on this node which " + "respond to SNMP. Proceeding..."));
            }
            this.createSnmpConflictsWithDbEvent(dbNodeEntry);
        }
        Date now = null;
        Connection dbc = null;
        boolean updateCompleted = false;
        try {
            RescanProcessor.log().debug((Object)("Waiting for capsd dbLock to process " + this.getNodeId()));
            snmpc = Capsd.getDbSyncLock();
            synchronized (snmpc) {
                RescanProcessor.log().debug((Object)("Got capsd dbLock. processing " + this.getNodeId()));
                dbc = DataSourceFactory.getInstance().getConnection();
                if (!this.isNodeDeleted(dbc, this.getNodeId())) {
                    now = new Date();
                    this.updateInterfaces(dbc, now, dbNodeEntry, collectorMap, doesSnmp);
                    if (doesSnmp) {
                        InetAddress oldPriIf = null;
                        if (oldPrimarySnmpInterface != null) {
                            oldPriIf = oldPrimarySnmpInterface.getIfAddress();
                        }
                        InetAddress newSnmpPrimaryIf = this.updatePrimarySnmpInterface(dbc, dbNodeEntry, collectorMap, oldPriIf);
                        this.updateNode(dbc, now, dbNodeEntry, newSnmpPrimaryIf, dbInterfaces, collectorMap);
                    }
                    updateCompleted = true;
                    this.createRescanCompletedEvent(dbNodeEntry);
                }
            }
        }
        catch (Throwable t) {
            RescanProcessor.log().error((Object)("Error updating records for node ID " + this.getNodeId() + ": " + t), t);
        }
        finally {
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (SQLException e) {
                RescanProcessor.log().error((Object)("Error closing connection: " + e), (Throwable)e);
            }
        }
        if (updateCompleted) {
            for (Event event : this.m_eventList) {
                try {
                    EventIpcManagerFactory.getIpcManager().sendNow(event);
                }
                catch (Throwable t) {
                    RescanProcessor.log().warn((Object)("run: unexpected throwable exception caught while sending event: " + t), t);
                }
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)((this.m_forceRescan ? "Forced r" : "R") + "escan " + "for node w/ nodeid " + this.getNodeId() + " completed."));
        }
    }

    private int getNodeId() {
        return this.m_nodeId;
    }

    private boolean scanPrimarySnmpInterface(DbIpInterfaceEntry oldPrimarySnmpInterface, Map<String, IfCollector> collectorMap, Set<InetAddress> probedAddrs) {
        boolean gotSnmpCollection = false;
        InetAddress ifaddr = oldPrimarySnmpInterface.getIfAddress();
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("running collection for DB primary snmp interface " + ifaddr.getHostAddress()));
        }
        IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
        collector.run();
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (snmpc == null) {
            RescanProcessor.log().debug((Object)"SNMP Collector from DB primary snmp interface is null");
        } else {
            gotSnmpCollection = true;
            collectorMap.put(ifaddr.getHostAddress(), collector);
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("SNMP data collected from DB primary snmp interface" + ifaddr.getHostAddress()));
            }
            if (!snmpc.hasIfTable()) {
                RescanProcessor.log().debug((Object)"SNMP Collector has no IfTable");
            }
            if (!snmpc.hasIpAddrTable() || snmpc.getIfIndex(snmpc.getCollectorTargetAddress()) == -1) {
                RescanProcessor.log().debug((Object)"SNMP Collector has no IpAddrTable. Assume its a lame SNMP host.");
            }
        }
        return gotSnmpCollection;
    }

    private InetAddress updatePrimarySnmpInterface(Connection dbc, DbNodeEntry dbNodeEntry, Map<String, IfCollector> collectorMap, InetAddress oldPriIf) throws SQLException {
        boolean strict = true;
        CollectdConfigFactory.getInstance().rebuildPackageIpListMap();
        IfSnmpCollector snmpc = this.findSnmpCollector(collectorMap);
        List<InetAddress> snmpLBAddresses = RescanProcessor.buildLBSnmpAddressList(collectorMap, snmpc);
        List<InetAddress> snmpAddresses = RescanProcessor.buildSnmpAddressList(collectorMap, snmpc);
        for (InetAddress addr : snmpAddresses) {
            if (!CollectdConfigFactory.getInstance().isServiceCollectionEnabled(addr.getHostAddress(), "SNMP")) continue;
            PreparedStatement stmt = dbc.prepareStatement("UPDATE ipInterface SET isSnmpPrimary='S' WHERE nodeId=? AND ipAddr=? AND isManaged!='D'");
            stmt.setInt(1, dbNodeEntry.getNodeId());
            stmt.setString(2, addr.getHostAddress());
            try {
                stmt.executeUpdate();
                RescanProcessor.log().debug((Object)("updatePrimarySnmpInterface: updated " + addr.getHostAddress() + " to secondary."));
            }
            catch (SQLException sqlE) {
                throw sqlE;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        InetAddress newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpLBAddresses, strict);
        String psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpAddresses, strict);
            psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
        }
        strict = false;
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpLBAddresses, strict);
            psiType = "DB loopback addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpAddresses, strict);
            psiType = "DB addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = snmpc.getCollectorTargetAddress();
            psiType = "snmp collector target address";
        }
        if (newSnmpPrimaryIf != null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("updatePrimarySnmpInterface: primary SNMP interface is: " + newSnmpPrimaryIf + ", selected from " + psiType));
            }
            SuspectEventProcessor.setPrimarySnmpInterface(dbc, dbNodeEntry, newSnmpPrimaryIf, oldPriIf);
        } else {
            RescanProcessor.log().debug((Object)"SuspectEventProcessor: Unable to determine a primary snmp interface");
        }
        this.generateSnmpDataCollectionEvents(dbNodeEntry, oldPriIf, newSnmpPrimaryIf);
        return newSnmpPrimaryIf;
    }

    private IfSnmpCollector findSnmpCollector(Map<String, IfCollector> collectorMap) {
        for (IfCollector collector : collectorMap.values()) {
            if (!collector.hasSnmpCollection()) continue;
            return collector.getSnmpCollector();
        }
        return null;
    }

    private DbIpInterfaceEntry[] getInterfaces(DbNodeEntry dbNodeEntry) {
        DbIpInterfaceEntry[] dbInterfaces = null;
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("retrieving managed interfaces for node: " + this.getNodeId()));
        }
        try {
            dbInterfaces = this.m_forceRescan ? dbNodeEntry.getInterfaces() : dbNodeEntry.getManagedInterfaces();
        }
        catch (NullPointerException npE) {
            RescanProcessor.log().error((Object)("RescanProcessor: Null pointer when retrieving " + (this.m_forceRescan ? "" : "managed") + " interfaces for node " + this.getNodeId()), (Throwable)npE);
            RescanProcessor.log().error((Object)("Rescan failed for node w/ nodeid " + this.getNodeId()));
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error((Object)("RescanProcessor: unable to load interface info for nodeId " + this.getNodeId() + " from the database."), (Throwable)sqlE);
            RescanProcessor.log().error((Object)("Rescan failed for node w/ nodeid " + this.getNodeId()));
        }
        return dbInterfaces;
    }

    private DbNodeEntry getNode() {
        DbNodeEntry dbNodeEntry = null;
        try {
            dbNodeEntry = DbNodeEntry.get(this.getNodeId());
        }
        catch (SQLException e) {
            RescanProcessor.log().error((Object)("RescanProcessor: unable to load node info for nodeId " + this.getNodeId() + " from the database."), (Throwable)e);
            RescanProcessor.log().error((Object)("Rescan failed for node w/ nodeid " + this.getNodeId()));
        }
        return dbNodeEntry;
    }

    private void generateSnmpDataCollectionEvents(DbNodeEntry nodeEntry, InetAddress oldPriIf, InetAddress primarySnmpIf) {
        boolean reInit = true;
        if (oldPriIf == null && primarySnmpIf != null) {
            reInit = false;
            RescanProcessor.log().debug((Object)"generateSnmpDataCollectionEvents: Either SNMP support was recently enabled on this node, or node doesn't support ipAddrTable MIB.");
            this.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, null);
        } else if (primarySnmpIf != null && !oldPriIf.equals(primarySnmpIf)) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("generateSnmpDataCollectionEvents: primary SNMP interface has changed.  Was: " + oldPriIf.getHostAddress() + " Is: " + primarySnmpIf.getHostAddress()));
            }
            this.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, oldPriIf);
            reInit = false;
        }
        if (reInit && (this.m_ifIndexOnNodeChangedFlag || this.m_snmpIfTableChangedFlag)) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug((Object)("generateSnmpDataCollectionEvents: Generating reinitializeSnmpInterface event for interface " + primarySnmpIf.getHostAddress()));
            }
            this.createReinitializePrimarySnmpInterfaceEvent(nodeEntry.getNodeId(), primarySnmpIf);
        }
    }

    private void createNodeLabelChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeLabelChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldLabel: '" + originalEntry.getLabel() + "' oldSource: '" + originalEntry.getLabelSource() + "' newLabel: '" + updatedEntry.getLabel() + "' newLabelSource: '" + updatedEntry.getLabelSource() + "'"));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeLabelChanged");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)updatedEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        if (originalEntry.getLabel() != null) {
            eventParm = new Parm();
            eventParm.setParmName("oldNodeLabel");
            parmValue = new Value();
            parmValue.setContent(originalEntry.getLabel());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("oldNodeLabelSource");
            parmValue = new Value();
            parmValue.setContent(String.valueOf(originalEntry.getLabelSource()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getLabel() != null) {
            eventParm = new Parm();
            eventParm.setParmName("newNodeLabel");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getLabel());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("newNodeLabelSource");
            parmValue = new Value();
            parmValue.setContent(String.valueOf(updatedEntry.getLabelSource()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeLabelChangedEvent: successfully created nodeLabelChanged event for nodeid: " + updatedEntry.getNodeId()));
        }
    }

    private void createNodeInfoChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeInfoChangedEvent: nodeId: " + updatedEntry.getNodeId()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeInfoChanged");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)updatedEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        if (updatedEntry.getSystemOID() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysoid");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getSystemOID());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getSystemLocation() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesyslocation");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getSystemLocation());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getSystemContact() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesyscontact");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getSystemContact());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getNetBIOSName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodenetbiosname");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getNetBIOSName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getDomainName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodedomainname");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getDomainName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getOS() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodeoperatingsystem");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getOS());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeInfoChangedEvent: successfully created nodeInfoChanged event for nodeid: " + updatedEntry.getNodeId()));
        }
    }

    private void createPrimarySnmpInterfaceChangedEvent(int nodeId, InetAddress newPrimaryIf, InetAddress oldPrimaryIf) {
        String oldPrimaryAddr = null;
        if (oldPrimaryIf != null) {
            oldPrimaryAddr = oldPrimaryIf.getHostAddress();
        }
        String newPrimaryAddr = null;
        if (newPrimaryIf != null) {
            newPrimaryAddr = newPrimaryIf.getHostAddress();
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createPrimarySnmpInterfaceChangedEvent: nodeId: " + nodeId + "oldPrimarySnmpIf: '" + oldPrimaryAddr + "' newPrimarySnmpIf: '" + newPrimaryAddr + "'"));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)nodeId);
        newEvent.setInterface(newPrimaryAddr);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setService("SNMP");
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        if (oldPrimaryAddr != null) {
            eventParm = new Parm();
            eventParm.setParmName("oldPrimarySnmpAddress");
            parmValue = new Value();
            parmValue.setContent(oldPrimaryAddr);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (newPrimaryAddr != null) {
            eventParm = new Parm();
            eventParm.setParmName("newPrimarySnmpAddress");
            parmValue = new Value();
            parmValue.setContent(newPrimaryAddr);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createPrimarySnmpInterfaceChangedEvent: successfully created primarySnmpInterfaceChanged event for nodeid: " + nodeId));
        }
    }

    private void createInterfaceIndexChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createInterfaceIndexChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldIfIndex: " + originalEntry.getIfIndex() + " newIfIndex: " + updatedEntry.getIfIndex()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceIndexChanged");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)updatedEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(updatedEntry.getIfAddress().getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("oldIfIndex");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(originalEntry.getIfIndex()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("newIfIndex");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(updatedEntry.getIfIndex()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createInterfaceIndexChangedEvent: successfully created interfaceIndexChanged event for nodeid: " + updatedEntry.getNodeId()));
        }
    }

    private void createIpHostNameChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createIpHostNameChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldHostName: " + originalEntry.getHostname() + " newHostName: " + updatedEntry.getHostname()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceIPHostNameChanged");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)updatedEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(updatedEntry.getIfAddress().getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        if (originalEntry.getHostname() != null) {
            eventParm = new Parm();
            eventParm.setParmName("oldiphostname");
            parmValue = new Value();
            parmValue.setContent(originalEntry.getHostname());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (updatedEntry.getHostname() != null) {
            eventParm = new Parm();
            eventParm.setParmName("iphostname");
            parmValue = new Value();
            parmValue.setContent(updatedEntry.getHostname());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createIpHostNameChangedEvent: successfully created ipHostNameChanged event for nodeid: " + updatedEntry.getNodeId()));
        }
    }

    private void createInterfaceReparentedEvent(DbNodeEntry newNode, int oldNodeId, InetAddress reparentedIf) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createInterfaceReparentedEvent: ifAddr: " + reparentedIf.getHostAddress() + " oldNodeId: " + oldNodeId + " newNodeId: " + newNode.getNodeId()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceReparented");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)newNode.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(reparentedIf.getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("oldNodeID");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(oldNodeId));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("newNodeID");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(newNode.getNodeId()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        String hostname = reparentedIf.getHostName();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (newNode.getLabel() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodelabel");
            parmValue = new Value();
            parmValue.setContent(newNode.getLabel());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("nodelabelsource");
            parmValue = new Value();
            parmValue.setContent(String.valueOf(newNode.getLabelSource()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (newNode.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(newNode.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (newNode.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(newNode.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createInterfaceReparentedEvent: successfully created interfaceReparented event for nodeid/interface: " + newNode.getNodeId() + "/" + reparentedIf.getHostAddress()));
        }
    }

    private void createDuplicateNodeDeletedEvent(DbNodeEntry deletedNode) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createDuplicateNodeDeletedEvent: delete nodeid: " + deletedNode.getNodeId()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/duplicateNodeDeleted");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)deletedNode.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createDuplicateNodeDeletedEvent: successfully created duplicateNodeDeleted event for nodeid: " + deletedNode.getNodeId()));
        }
    }

    private void createNodeGainedInterfaceEvent(DbIpInterfaceEntry ifEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeGainedInterfaceEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedInterface");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = ifEntry.getHostname() == null ? "" : ifEntry.getHostname();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("method");
        parmValue = new Value();
        parmValue.setContent("icmp");
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeGainedInterfaceEvent: successfully created nodeGainedInterface event for nodeid: " + ifEntry.getNodeId()));
        }
    }

    private void createDuplicateIpAddressEvent(DbIpInterfaceEntry ifEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createDuplicateIpAddressEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/duplicateIPAddress");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = ifEntry.getHostname() == null ? "" : ifEntry.getHostname();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("method");
        parmValue = new Value();
        parmValue.setContent("icmp");
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createDuplicateIpAddressEvent: successfully created duplicateIpAddress event for nodeid: " + ifEntry.getNodeId()));
        }
    }

    private void createNodeGainedServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeGainedServiceEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress() + " service: " + svcName));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedService");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setService(svcName);
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = ifEntry.getHostname() == null ? "" : ifEntry.getHostname();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeEntry.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (nodeEntry.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createNodeGainedServiceEvent: successfully created nodeGainedService event for nodeid: " + ifEntry.getNodeId()));
        }
    }

    private void createSuspendPollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/poller/suspendPollingService");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setService(svcName);
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = ifEntry.getHostname() == null ? "" : ifEntry.getHostname();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeEntry.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (nodeEntry.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("suspendPollingServiceEvent: Created suspendPollingService event for nodeid: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress() + " service: " + svcName));
        }
    }

    private void createResumePollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/poller/resumePollingService");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setService(svcName);
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = ifEntry.getHostname() == null ? "" : ifEntry.getHostname();
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeEntry.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (nodeEntry.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("resumePollingServiceEvent: Created resumePollingService event for nodeid: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress() + " service: " + svcName));
        }
    }

    private void createSnmpConflictsWithDbEvent(DbNodeEntry nodeEntry) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/snmpConflictsWithDb");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)nodeEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel();
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeEntry.getSystemName() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemName());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (nodeEntry.getSystemDescription() != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(nodeEntry.getSystemDescription());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("snmpConflictsWithDbEvent: Created snmpConflictsWithDbEvent for nodeid: " + nodeEntry.getNodeId()));
        }
    }

    private void createRescanCompletedEvent(DbNodeEntry nodeEntry) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/rescanCompleted");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)nodeEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        String hostname = null;
        hostname = nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel();
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(hostname);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("rescanCompletedEvent: Created rescanCompletedEvent for nodeid: " + nodeEntry.getNodeId()));
        }
    }

    private void createInterfaceSupportsSNMPEvent(DbIpInterfaceEntry ifEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createInterfaceSupportsSNMPEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifEntry.getIfAddress().getHostAddress()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/interfaceSupportsSNMP");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)ifEntry.getNodeId());
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifEntry.getIfAddress().getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("interfaceSupportsSNMPEvent: successfully created interfaceSupportsSNMPEvent event for nodeid: " + ifEntry.getNodeId()));
        }
    }

    private void createReinitializePrimarySnmpInterfaceEvent(int nodeId, InetAddress primarySnmpIf) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("reinitializePrimarySnmpInterface: nodeId: " + nodeId + " interface: " + primarySnmpIf.getHostAddress()));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(primarySnmpIf.getHostAddress());
        newEvent.setTime(EventConstants.formatToString(new Date()));
        this.m_eventList.add(newEvent);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((Object)("createReinitializePrimarySnmpInterfaceEvent: successfully created reinitializePrimarySnmpInterface event for interface: " + primarySnmpIf.getHostAddress()));
        }
    }
}

