/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

class SnmpRequest
implements Runnable {
    SnmpSession m_session;
    SnmpSyntax m_pdu;
    SnmpHandler m_handler;
    int m_timesSent;
    boolean m_expired;

    SnmpRequest(SnmpSession session, SnmpPduPacket pdu, SnmpHandler handler) {
        this.m_session = session;
        this.m_pdu = pdu;
        this.m_expired = false;
        this.m_timesSent = 0;
        this.m_handler = handler;
    }

    SnmpRequest(SnmpSession session, SnmpPduTrap pdu, SnmpHandler handler) {
        this.m_session = session;
        this.m_pdu = pdu;
        this.m_expired = false;
        this.m_timesSent = 0;
        this.m_handler = handler;
    }

    public void run() {
        if (this.m_expired) {
            return;
        }
        if (this.m_timesSent <= this.m_session.getPeer().getRetries()) {
            ++this.m_timesSent;
            try {
                this.m_session.transmit(this);
                if (this.m_pdu instanceof SnmpPduPacket) {
                    if (((SnmpPduPacket)this.m_pdu).getCommand() != 167) {
                        this.m_session.getTimer().schedule(this, this.m_session.getPeer().getTimeout());
                    } else {
                        this.m_expired = true;
                    }
                } else if (this.m_pdu instanceof SnmpPduTrap) {
                    this.m_expired = true;
                }
            }
            catch (IOException err) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -2, this.m_pdu);
                }
                catch (Exception e) {
                }
            }
            catch (SnmpPduEncodingException err) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -3, this.m_pdu);
                }
                catch (Exception e) {
                }
            }
            catch (AsnEncodingException err) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -3, this.m_pdu);
                }
                catch (Exception exception) {}
            }
        } else {
            this.m_expired = true;
            try {
                this.m_handler.snmpTimeoutError(this.m_session, this.m_pdu);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

