/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPEventSource;
import com.novell.ldap.events.LDAPExceptionEvent;
import com.novell.ldap.events.edir.EdirEventIntermediateResponse;
import com.novell.ldap.events.edir.EdirEventSpecifier;
import com.novell.ldap.events.edir.MonitorEventRequest;
import com.novell.ldap.events.edir.MonitorFilterEventRequest;

public class EdirEventSource
extends LDAPEventSource {
    static /* synthetic */ Class class$com$novell$ldap$events$edir$EdirEventIntermediateResponse;

    public EdirEventSource() throws LDAPException {
        this.registerIntermediateResponses();
    }

    public void removeListener(LDAPEventListener lDAPEventListener) throws LDAPException {
        if (lDAPEventListener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        super.stopeventpolling(lDAPEventListener);
    }

    public final void registerforEvent(EdirEventSpecifier[] edirEventSpecifierArray, LDAPConnection lDAPConnection, LDAPEventListener lDAPEventListener) throws LDAPException {
        if (edirEventSpecifierArray == null || lDAPConnection == null || lDAPEventListener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        MonitorEventRequest monitorEventRequest = new MonitorEventRequest(edirEventSpecifierArray);
        this.sendExtendedRequest(lDAPConnection, monitorEventRequest, lDAPEventListener);
    }

    private void sendExtendedRequest(LDAPConnection lDAPConnection, LDAPExtendedOperation lDAPExtendedOperation, LDAPEventListener lDAPEventListener) throws LDAPException {
        LDAPResponseQueue lDAPResponseQueue = lDAPConnection.extendedOperation(lDAPExtendedOperation, null, null);
        EdirEventsGenerator edirEventsGenerator = null;
        int[] nArray = lDAPResponseQueue.getMessageIDs();
        if (nArray.length != 1) {
            throw new LDAPException(null, 82, "Unable to Obtain Message Id");
        }
        edirEventsGenerator = new EdirEventsGenerator(lDAPEventListener);
        super.pollforevents(lDAPResponseQueue, lDAPConnection, edirEventsGenerator, nArray[0], this);
    }

    public final void registerforFilterEvent(EdirEventSpecifier[] edirEventSpecifierArray, LDAPConnection lDAPConnection, LDAPEventListener lDAPEventListener) throws LDAPException {
        if (edirEventSpecifierArray == null || lDAPConnection == null || lDAPEventListener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        MonitorFilterEventRequest monitorFilterEventRequest = new MonitorFilterEventRequest(edirEventSpecifierArray);
        this.sendExtendedRequest(lDAPConnection, monitorFilterEventRequest, lDAPEventListener);
    }

    private void registerIntermediateResponses() throws LDAPException {
        try {
            this.getClass().getClassLoader().loadClass((class$com$novell$ldap$events$edir$EdirEventIntermediateResponse == null ? (class$com$novell$ldap$events$edir$EdirEventIntermediateResponse = EdirEventSource.class$("com.novell.ldap.events.edir.EdirEventIntermediateResponse")) : class$com$novell$ldap$events$edir$EdirEventIntermediateResponse).getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("PARAM_ERROR", 82, classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EdirEventsGenerator
    implements LDAPEventListener {
        private final LDAPEventListener listener;

        EdirEventsGenerator(LDAPEventListener lDAPEventListener) {
            this.listener = lDAPEventListener;
        }

        public void ldapEventNotification(LDAPEvent lDAPEvent) {
            LDAPMessage lDAPMessage;
            lDAPEvent.setEventclassification(1);
            if (lDAPEvent.getContainedEventInformation().getType() == 25 && (lDAPMessage = lDAPEvent.getContainedEventInformation()) instanceof EdirEventIntermediateResponse) {
                EdirEventIntermediateResponse edirEventIntermediateResponse = (EdirEventIntermediateResponse)lDAPMessage;
                lDAPEvent.setEventtype(edirEventIntermediateResponse.getEventtype());
            }
            this.listener.ldapEventNotification(lDAPEvent);
        }

        public void ldapExceptionNotification(LDAPExceptionEvent lDAPExceptionEvent) {
            this.listener.ldapExceptionNotification(lDAPExceptionEvent);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

