/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public class UsmSecurityParameters
implements SecurityParameters {
    private static final LogAdapter logger = LogFactory.getLogger(UsmSecurityParameters.class);
    private static final int MAX_BER_LENGTH_WITHOU_SEC_PARAMS = 80;
    private OctetString authoritativeEngineID = new OctetString();
    private Integer32 authoritativeEngineBoots = new Integer32();
    private Integer32 authoritativeEngineTime = new Integer32();
    private OctetString userName = new OctetString();
    private AuthenticationProtocol authenticationProtocol = null;
    private PrivacyProtocol privacyProtocol = null;
    private byte[] authenticationKey;
    private byte[] privacyKey;
    private OctetString privacyParameters = new OctetString();
    private OctetString authenticationParameters = new OctetString();
    private int securityParametersPosition = -1;
    private int authParametersPosition = -1;
    private int decodedLength = -1;

    public UsmSecurityParameters() {
    }

    public UsmSecurityParameters(OctetString octetString, Integer32 integer32, Integer32 integer322, OctetString octetString2, AuthenticationProtocol authenticationProtocol, PrivacyProtocol privacyProtocol) {
        this.authoritativeEngineID = octetString;
        this.authoritativeEngineBoots = integer32;
        this.authoritativeEngineTime = integer322;
        this.privacyProtocol = privacyProtocol;
        this.userName = octetString2;
        this.authenticationProtocol = authenticationProtocol;
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID.getValue();
    }

    public void setAuthoritativeEngineID(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Authoritative engine ID must not be null");
        }
        this.authoritativeEngineID.setValue(byArray);
    }

    public void setAuthoritativeEngineBoots(int n) {
        this.authoritativeEngineBoots.setValue(n);
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots.getValue();
    }

    public void setAuthoritativeEngineTime(int n) {
        this.authoritativeEngineTime.setValue(n);
    }

    public int getAuthoritativeEngineTime() {
        return this.authoritativeEngineTime.getValue();
    }

    public void setUserName(OctetString octetString) {
        this.userName = octetString;
    }

    public OctetString getUserName() {
        return this.userName;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public int getBERLength() {
        int n = this.getBERPayloadLength();
        return n + BER.getBERLengthOfLength(n) + 1;
    }

    public int getBERPayloadLength() {
        int n = this.getBERUsmPayloadLength();
        n += BER.getBERLengthOfLength(n) + 1;
        return n;
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        int n;
        this.decodedLength = n = (int)bERInputStream.getPosition();
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n2 = BER.decodeHeader(bERInputStream, mutableByte);
        long l = bERInputStream.getPosition();
        if (mutableByte.getValue() != 4) {
            String string = "BER decoding error: Expected BER OCTETSTRING but found: " + mutableByte.getValue();
            logger.warn(string);
            throw new IOException(string);
        }
        int n3 = BER.decodeHeader(bERInputStream, mutableByte);
        long l2 = bERInputStream.getPosition();
        if (mutableByte.getValue() != 48) {
            String string = "BER decoding error: Expected BER SEQUENCE but found: " + mutableByte.getValue();
            logger.warn(string);
            throw new IOException(string);
        }
        this.authoritativeEngineID.decodeBER(bERInputStream);
        this.authoritativeEngineBoots.decodeBER(bERInputStream);
        this.authoritativeEngineTime.decodeBER(bERInputStream);
        this.userName.decodeBER(bERInputStream);
        this.authParametersPosition = (int)(bERInputStream.getPosition() - (long)n);
        n = (int)bERInputStream.getPosition();
        this.authenticationParameters.decodeBER(bERInputStream);
        this.authParametersPosition = (int)((long)this.authParametersPosition + (bERInputStream.getPosition() - (long)n - (long)this.authenticationParameters.getBERPayloadLength()));
        this.privacyParameters.decodeBER(bERInputStream);
        this.decodedLength = (int)(bERInputStream.getPosition() - (long)this.decodedLength);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(n3, (int)(bERInputStream.getPosition() - l2), this);
            BER.checkSequenceLength(n2, (int)(bERInputStream.getPosition() - l), this);
        }
    }

    private int getBEREncodedAuthParamsPosition() {
        int n = this.getBERLength() - (this.authenticationParameters.getBERPayloadLength() + this.privacyParameters.getBERLength());
        return n;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, 4, this.getBERPayloadLength());
        BER.encodeHeader(outputStream, 48, this.getBERUsmPayloadLength());
        this.authoritativeEngineID.encodeBER(outputStream);
        this.authoritativeEngineBoots.encodeBER(outputStream);
        this.authoritativeEngineTime.encodeBER(outputStream);
        this.userName.encodeBER(outputStream);
        this.authenticationParameters.encodeBER(outputStream);
        this.privacyParameters.encodeBER(outputStream);
    }

    public int getBERUsmPayloadLength() {
        int n = this.authoritativeEngineID.getBERLength();
        n += this.authoritativeEngineBoots.getBERLength();
        n += this.authoritativeEngineTime.getBERLength();
        n += this.userName.getBERLength();
        n += this.authenticationParameters.getBERLength();
        return n += this.privacyParameters.getBERLength();
    }

    public int getBERMaxLength(int n) {
        SecurityProtocols securityProtocols = SecurityProtocols.getInstance();
        int n2 = 2;
        if (n > 1) {
            n2 = securityProtocols.getMaxAuthDigestLength() + BER.getBERLengthOfLength(securityProtocols.getMaxAuthDigestLength()) + 1;
            if (n == 3) {
                n2 += securityProtocols.getMaxPrivDecryptParamsLength() + BER.getBERLengthOfLength(securityProtocols.getMaxPrivDecryptParamsLength()) + 1;
            }
        }
        return 80 + n2 + BER.getBERLengthOfLength(80 + n2) + 1;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(byte[] byArray) {
        this.authenticationKey = byArray;
    }

    public byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    public void setPrivacyKey(byte[] byArray) {
        this.privacyKey = byArray;
    }

    public OctetString getPrivacyParameters() {
        return this.privacyParameters;
    }

    public void setPrivacyParameters(OctetString octetString) {
        this.privacyParameters = octetString;
    }

    public OctetString getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public void setAuthenticationParameters(OctetString octetString) {
        this.authenticationParameters = octetString;
    }

    public int getSecurityParametersPosition() {
        return this.securityParametersPosition;
    }

    public void setSecurityParametersPosition(int n) {
        this.securityParametersPosition = n;
    }

    public int getAuthParametersPosition() {
        if (this.authParametersPosition >= 0) {
            return this.authParametersPosition;
        }
        return this.getBEREncodedAuthParamsPosition();
    }

    public int getScopedPduPosition() {
        if (this.decodedLength >= 0) {
            return this.decodedLength + this.getSecurityParametersPosition();
        }
        return this.getSecurityParametersPosition() + this.getBERLength();
    }
}

