/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.jaas;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.jaas.RadiusCallback;
import net.sourceforge.jradiusclient.jaas.RadiusPrincipal;
import net.sourceforge.jradiusclient.packets.PapAccessRequest;

public class RadiusLoginModule
implements LoginModule {
    public static final int MAX_CHALLENGE_ATTEMPTS = 3;
    private Subject radiusSubject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map moduleOptions;
    private boolean authenticationSucceeded = false;
    private boolean authenticationCommitted = false;
    private String userName;
    private RadiusPrincipal userPrincipal;
    private int challengedAttempts = 0;
    private RadiusClient radiusClient;

    public boolean abort() throws LoginException {
        if (!this.authenticationSucceeded) {
            return false;
        }
        if (this.authenticationSucceeded && !this.authenticationCommitted) {
            this.authenticationSucceeded = false;
            this.userName = null;
            this.radiusClient = null;
            this.userPrincipal = null;
            this.challengedAttempts = 0;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.authenticationSucceeded) {
            return false;
        }
        this.userPrincipal = new RadiusPrincipal(this.userName);
        if (!this.radiusSubject.getPrincipals().contains(this.userPrincipal)) {
            this.radiusSubject.getPrincipals().add(this.userPrincipal);
        }
        this.userName = null;
        this.radiusClient = null;
        this.challengedAttempts = 0;
        this.authenticationCommitted = true;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.radiusSubject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.moduleOptions = map2;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: No callback handler installed to gather username and password.");
        }
        NameCallback nameCallback = new NameCallback("User Name: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", true);
        RadiusCallback radiusCallback = new RadiusCallback();
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, radiusCallback};
        try {
            this.callbackHandler.handle(callbackArray);
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            StringBuffer stringBuffer = new StringBuffer("Error: callback ");
            stringBuffer.append(unsupportedCallbackException.getCallback().toString());
            stringBuffer.append(" not supported.");
            throw new LoginException(stringBuffer.toString());
        }
        this.userName = nameCallback.getName();
        char[] cArray = passwordCallback.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        passwordCallback.clearPassword();
        try {
            this.radiusClient = new RadiusClient(radiusCallback.getHostName(), radiusCallback.getAuthPort(), radiusCallback.getAcctPort(), radiusCallback.getSharedSecret());
            PapAccessRequest papAccessRequest = new PapAccessRequest(this.userName, String.valueOf(cArray));
            this.authenticate(papAccessRequest, radiusCallback.getNumRetries());
        }
        catch (InvalidParameterException invalidParameterException) {
            StringBuffer stringBuffer = new StringBuffer("Configuration of the RADIUS client is incorrect. ");
            stringBuffer.append(invalidParameterException.getMessage());
            throw new LoginException(stringBuffer.toString());
        }
        catch (RadiusException radiusException) {
            StringBuffer stringBuffer = new StringBuffer("Configuration of the RADIUS client is incorrect. ");
            stringBuffer.append(radiusException.getMessage());
            throw new LoginException(stringBuffer.toString());
        }
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = 32;
            ++n;
        }
        cArray = null;
        this.authenticationSucceeded = true;
        return true;
    }

    private void authenticate(RadiusPacket radiusPacket, int n) throws LoginException {
        try {
            RadiusPacket radiusPacket2 = this.radiusClient.authenticate(radiusPacket, n);
            switch (radiusPacket2.getPacketType()) {
                case 2: {
                    break;
                }
                case 3: {
                    throw new CredentialExpiredException("Incorrect User Name or Password.");
                }
                case 11: {
                    if (this.challengedAttempts > 3) {
                        this.challengedAttempts = 0;
                        throw new LoginException("Maximum number of challenge retries exceeded.");
                    }
                    Callback[] callbackArray = new Callback[1];
                    String string = null;
                    callbackArray[0] = new PasswordCallback(String.valueOf(radiusPacket2.getAttribute(18).getValue()), true);
                    try {
                        this.callbackHandler.handle(callbackArray);
                        string = String.valueOf(((PasswordCallback)callbackArray[0]).getPassword());
                        if (string == null) {
                            string = new String("");
                        }
                        ((PasswordCallback)callbackArray[0]).clearPassword();
                    }
                    catch (IOException iOException) {
                        throw new LoginException(iOException.getMessage());
                    }
                    catch (UnsupportedCallbackException unsupportedCallbackException) {
                        StringBuffer stringBuffer = new StringBuffer("Error: callback ");
                        stringBuffer.append(unsupportedCallbackException.getCallback().toString());
                        stringBuffer.append(" not supported.");
                        throw new LoginException(stringBuffer.toString());
                    }
                    ++this.challengedAttempts;
                    PapAccessRequest papAccessRequest = new PapAccessRequest(this.userName, String.valueOf(string));
                    this.authenticate(papAccessRequest, 1);
                    break;
                }
                default: {
                    throw new LoginException("Received an Invalid response from the RADIUS Server.");
                }
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new LoginException(invalidParameterException.getMessage());
        }
        catch (RadiusException radiusException) {
            throw new LoginException(radiusException.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        this.radiusSubject.getPrincipals().remove(this.userPrincipal);
        this.authenticationCommitted = false;
        this.authenticationSucceeded = false;
        this.userName = null;
        this.radiusClient = null;
        this.userPrincipal = null;
        this.challengedAttempts = 0;
        return true;
    }
}

