/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.ActionEvent;
import org.opennms.netmgt.config.vacuumd.Assignment;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.utils.EventBuilder;
import org.opennms.netmgt.vacuumd.AutomationException;
import org.opennms.netmgt.vacuumd.Transaction;
import org.opennms.netmgt.vacuumd.Vacuumd;
import org.opennms.netmgt.xml.event.Event;

public class AutomationProcessor
implements ReadyRunnable {
    private Automation m_automation;
    private boolean m_ready = true;
    private Schedule m_schedule;
    public TriggerProcessor m_trigger;
    private ActionProcessor m_action;
    private AutoEventProcessor m_autoEvent;
    private ActionEventProcessor m_actionEvent;

    public AutomationProcessor(Automation automation) {
        this.m_automation = automation;
        this.m_trigger = new TriggerProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getTrigger(this.m_automation.getTriggerName()));
        this.m_action = new ActionProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getAction(this.m_automation.getActionName()));
        this.m_autoEvent = new AutoEventProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getAutoEvent(this.m_automation.getAutoEventName()));
        this.m_actionEvent = new ActionEventProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getActionEvent(this.m_automation.getActionEvent()));
    }

    public ActionProcessor getAction() {
        return this.m_action;
    }

    public TriggerProcessor getTrigger() {
        return this.m_trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Date startDate = new Date();
        this.log().debug((Object)("Start Scheduled automation " + this));
        if (this.getAutomation() != null) {
            this.setReady(false);
            try {
                this.runAutomation();
            }
            catch (SQLException e) {
                this.log().warn((Object)("Error running automation: " + this.getAutomation().getName() + ", " + e.getMessage()));
            }
            finally {
                this.setReady(true);
            }
        }
        this.log().debug((Object)("run: Finished automation " + this.m_automation.getName() + ", started at " + startDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAutomation() throws SQLException {
        this.log().debug((Object)("runAutomation: " + this.m_automation.getName() + " running..."));
        if (this.hasTrigger()) {
            this.log().debug((Object)("runAutomation: " + this.m_automation.getName() + " trigger statement is: " + this.m_trigger.getTriggerSQL()));
        }
        this.log().debug((Object)("runAutomation: " + this.m_automation.getName() + " action statement is: " + this.m_action.getActionSQL()));
        this.log().debug((Object)("runAutomation: Executing trigger: " + this.m_automation.getTriggerName()));
        Transaction.begin();
        try {
            this.log().debug((Object)("runAutomation: Processing automation: " + this.m_automation.getName()));
            TriggerResults results = this.processTrigger();
            boolean success = false;
            if (results.isSuccessful()) {
                success = this.processAction(results);
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            Transaction.rollbackOnly();
            this.log().warn((Object)("runAutomation: Could not execute automation: " + this.m_automation.getName()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.log().debug((Object)("runAutomation: Ending processing of automation: " + this.m_automation.getName()));
            Transaction.end();
        }
    }

    private boolean processAction(TriggerResults triggerResults) throws SQLException {
        this.log().debug((Object)("runAutomation: running action(s)/actionEvent(s) for : " + this.m_automation.getName()));
        this.m_action.checkForRequiredColumns(triggerResults);
        if (this.m_action.processAction(triggerResults)) {
            this.m_actionEvent.processActionEvent(triggerResults);
            this.m_autoEvent.send();
            return true;
        }
        return false;
    }

    private TriggerResults processTrigger() throws SQLException {
        if (this.m_trigger.hasTrigger()) {
            ResultSet triggerResultSet = this.m_trigger.runTriggerQuery();
            TriggerResults triggerResults = new TriggerResults(this.m_trigger, triggerResultSet, this.verifyRowCount(triggerResultSet));
            return triggerResults;
        }
        return new TriggerResults(this.m_trigger, null, true);
    }

    protected boolean verifyRowCount(ResultSet triggerResultSet) throws SQLException {
        if (!this.m_trigger.hasTrigger()) {
            return true;
        }
        boolean validRows = true;
        int resultRows = this.countRows(triggerResultSet);
        int triggerRowCount = this.m_trigger.getTrigger().getRowCount();
        String triggerOperator = this.m_trigger.getTrigger().getOperator();
        this.log().debug((Object)("verifyRowCount: Verifying trigger result: " + resultRows + " is " + triggerOperator + " than " + triggerRowCount));
        if (!this.m_trigger.triggerRowCheck(triggerRowCount, triggerOperator, resultRows)) {
            validRows = false;
        }
        return validRows;
    }

    public int countRows(ResultSet rs) throws SQLException {
        if (rs == null) {
            return 0;
        }
        int rows = 0;
        while (rs.next()) {
            ++rows;
        }
        rs.beforeFirst();
        return rows;
    }

    public boolean containsTokens(String targetString) {
        return this.m_action.getTokenCount(targetString) > 0;
    }

    public Automation getAutomation() {
        return this.m_automation;
    }

    public boolean isReady() {
        return this.m_ready;
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    private Category log() {
        return ThreadCategory.getInstance(AutomationProcessor.class);
    }

    private boolean hasTrigger() {
        return this.m_trigger.hasTrigger();
    }

    public void setReady(boolean ready) {
        this.m_ready = ready;
    }

    static class ActionEventProcessor {
        private ActionEvent m_actionEvent;
        private String m_automationName;
        private List<EventAssignment> m_assignments;

        public ActionEventProcessor(String automationName, ActionEvent actionEvent) {
            this.m_automationName = automationName;
            this.m_actionEvent = actionEvent;
            if (actionEvent != null) {
                this.m_assignments = new ArrayList<EventAssignment>(actionEvent.getAssignmentCount());
                for (Assignment assignment : actionEvent.getAssignment()) {
                    this.m_assignments.add(new EventAssignment(assignment));
                }
            }
        }

        public Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public boolean hasEvent() {
            return this.m_actionEvent != null;
        }

        void send() {
            this.log().debug((Object)("runAutomation: Sending any possible configured event for automation: " + this.m_automationName));
            if (this.hasEvent()) {
                EventBuilder bldr = new EventBuilder(new Event());
                this.buildEvent(bldr, new InvalidSymbolTable());
                this.sendEvent(bldr.getEvent());
            } else {
                this.log().debug((Object)("runAutomation: No event configured automation: " + this.m_automationName));
            }
        }

        private void buildEvent(EventBuilder bldr, PropertiesUtils.SymbolTable symbols) {
            for (EventAssignment assignment : this.m_assignments) {
                assignment.assign(bldr, symbols);
            }
        }

        private void sendEvent(Event event) {
            Vacuumd.getSingleton().getEventManager().sendNow(event);
        }

        void processTriggerResults(TriggerResults triggerResults) throws SQLException {
            if (!this.hasEvent()) {
                return;
            }
            ResultSet triggerResultSet = triggerResults.getResultSet();
            triggerResultSet.beforeFirst();
            while (triggerResultSet.next()) {
                EventBuilder bldr = new EventBuilder(new Event());
                bldr.setSource("Automation");
                ResultSetSymbolTable symbols = new ResultSetSymbolTable(triggerResultSet);
                try {
                    this.buildEvent(bldr, symbols);
                }
                catch (SQLExceptionHolder holder) {
                    holder.rethrow();
                }
                this.sendEvent(bldr.getEvent());
            }
        }

        public boolean forEachResult() {
            return this.m_actionEvent == null ? false : this.m_actionEvent.getForEachResult();
        }

        void processActionEvent(TriggerResults triggerResults) throws SQLException {
            if (triggerResults.hasTrigger() && this.forEachResult()) {
                this.processTriggerResults(triggerResults);
            } else {
                this.send();
            }
        }
    }

    static class EventAssignment {
        static final Pattern s_pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        private Assignment m_assignment;

        public EventAssignment(Assignment assignment) {
            this.m_assignment = assignment;
        }

        public Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public void assign(EventBuilder bldr, PropertiesUtils.SymbolTable symbols) {
            String val = PropertiesUtils.substitute((String)this.m_assignment.getValue(), (PropertiesUtils.SymbolTable)symbols);
            if (this.m_assignment.getValue().equals(val) && s_pattern.matcher(val).matches()) {
                return;
            }
            if ("field".equals(this.m_assignment.getType())) {
                bldr.setField(this.m_assignment.getName(), val);
            } else {
                bldr.addParam(this.m_assignment.getName(), val);
            }
        }
    }

    static class InvalidSymbolTable
    implements PropertiesUtils.SymbolTable {
        InvalidSymbolTable() {
        }

        public String getSymbolValue(String symbol) {
            throw new IllegalArgumentException("token " + symbol + " is not allowed for " + this + " when no trigger is being processed");
        }
    }

    static class ResultSetSymbolTable
    implements PropertiesUtils.SymbolTable {
        private ResultSet m_rs;

        public ResultSetSymbolTable(ResultSet rs) {
            this.m_rs = rs;
        }

        public String getSymbolValue(String symbol) {
            try {
                return this.m_rs.getString(symbol);
            }
            catch (SQLException e) {
                throw new SQLExceptionHolder(e);
            }
        }
    }

    static class SQLExceptionHolder
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        SQLException m_ex = null;

        public SQLExceptionHolder(SQLException ex) {
            this.m_ex = ex;
        }

        public void rethrow() throws SQLException {
            if (this.m_ex != null) {
                throw this.m_ex;
            }
        }
    }

    static class AutoEventProcessor {
        private AutoEvent m_autoEvent;
        private String m_automationName;

        public AutoEventProcessor(String automationName, AutoEvent autoEvent) {
            this.m_automationName = automationName;
            this.m_autoEvent = autoEvent;
        }

        public Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public boolean hasEvent() {
            return this.m_autoEvent != null;
        }

        public AutoEvent getAutoEvent() {
            return this.m_autoEvent;
        }

        String getUei() {
            if (this.hasEvent()) {
                return this.getAutoEvent().getUei().getContent();
            }
            return null;
        }

        void send() {
            this.log().debug((Object)("runAutomation: Sending any possible configured event for automation: " + this.m_automationName));
            if (this.hasEvent()) {
                this.log().debug((Object)("runAutomation: Sending event: " + this.getUei() + " for automation: " + this.m_automationName));
                EventBuilder bldr = new EventBuilder(this.getUei(), "Automation");
                this.sendEvent(bldr.getEvent());
            } else {
                this.log().debug((Object)("runAutomation: No event configured automation: " + this.m_automationName));
            }
        }

        private void sendEvent(Event event) {
            Vacuumd.getSingleton().getEventManager().sendNow(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionProcessor {
        private String m_automationName;
        private Action m_action;

        public ActionProcessor(String automationName, Action action) {
            this.m_automationName = automationName;
            this.m_action = action;
        }

        public boolean hasAction() {
            return this.m_action != null;
        }

        public Action getAction() {
            return this.m_action;
        }

        public Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        String getActionSQL() {
            return this.getAction().getStatement().getContent();
        }

        PreparedStatement createPreparedStatement() throws SQLException {
            String actionJDBC = this.getActionSQL().replaceAll("\\$\\{\\w+\\}", "?");
            this.log().debug((Object)("createPrepareStatement: This action SQL: " + this.getActionSQL() + "\nTurned into this: " + actionJDBC));
            Connection conn = Transaction.getConnection(this.m_action.getDataSource());
            PreparedStatement stmt = conn.prepareStatement(actionJDBC);
            Transaction.register(stmt);
            return stmt;
        }

        public List<String> getActionColumns() {
            return this.getTokenizedColumns(this.getActionSQL());
        }

        private List<String> getTokenizedColumns(String targetString) {
            String expression = "\\$\\{(\\w+)\\}";
            Pattern pattern = Pattern.compile(expression);
            Matcher matcher = pattern.matcher(targetString);
            this.log().debug((Object)("getTokenizedColumns: processing string: " + targetString));
            ArrayList<String> tokens = new ArrayList<String>();
            int count = 0;
            while (matcher.find()) {
                this.log().debug((Object)("getTokenizedColumns: Token " + ++count + ": " + matcher.group(1)));
                tokens.add(matcher.group(1));
            }
            return tokens;
        }

        void assignStatementParameters(PreparedStatement stmt, ResultSet rs) throws SQLException {
            List<String> actionColumns = this.getTokenizedColumns(this.getActionSQL());
            Iterator<String> it = actionColumns.iterator();
            String actionColumnName = null;
            int i = 0;
            while (it.hasNext()) {
                actionColumnName = it.next();
                stmt.setObject(++i, rs.getObject(actionColumnName));
            }
        }

        public int getTokenCount(String targetString) {
            String expression = "(\\$\\{\\w+\\})";
            Pattern pattern = Pattern.compile(expression, 2);
            Matcher matcher = pattern.matcher(targetString);
            this.log().debug((Object)("getTokenCount: processing string: " + targetString));
            int count = 0;
            while (matcher.find()) {
                this.log().debug((Object)("getTokenCount: Token " + ++count + ": " + matcher.group(1)));
            }
            return count;
        }

        boolean execute() throws SQLException {
            if (this.getTokenCount(this.getActionSQL()) != 0) {
                this.log().info((Object)("execute: not running action: " + this.m_action.getName() + ".  Action contains tokens in an automation (" + this.m_automationName + ") with no trigger."));
                return false;
            }
            PreparedStatement actionStatement = this.createPreparedStatement();
            actionStatement.executeUpdate();
            return true;
        }

        boolean processTriggerResults(TriggerResults triggerResults) throws SQLException {
            ResultSet triggerResultSet = triggerResults.getResultSet();
            triggerResultSet.beforeFirst();
            PreparedStatement actionStatement = this.createPreparedStatement();
            while (triggerResultSet.next()) {
                this.assignStatementParameters(actionStatement, triggerResultSet);
                actionStatement.executeUpdate();
            }
            return true;
        }

        boolean processAction(TriggerResults triggerResults) throws SQLException {
            if (triggerResults.hasTrigger()) {
                return this.processTriggerResults(triggerResults);
            }
            return this.execute();
        }

        public String getName() {
            return this.m_action.getName();
        }

        public String toString() {
            return this.m_action.getName();
        }

        public void checkForRequiredColumns(TriggerResults triggerResults) {
            ResultSet triggerResultSet = triggerResults.getResultSet();
            if (!this.resultSetHasRequiredActionColumns(triggerResultSet, this.getActionColumns())) {
                throw new AutomationException("Action " + this + " uses column not defined in trigger: " + triggerResults);
            }
        }

        public boolean resultSetHasRequiredActionColumns(ResultSet rs, Collection<String> actionColumns) {
            this.log().debug((Object)"resultSetHasRequiredActionColumns: Verifying required action columns in trigger ResultSet...");
            if (actionColumns.isEmpty()) {
                return true;
            }
            if (rs == null) {
                return false;
            }
            boolean verified = true;
            String actionColumnName2 = null;
            for (String actionColumnName2 : actionColumns) {
                try {
                    if (rs.findColumn(actionColumnName2) <= 0) continue;
                }
                catch (SQLException e) {
                    this.log().warn((Object)("resultSetHasRequiredActionColumns: Trigger ResultSet does NOT have required action columns.  Missing: " + actionColumnName2));
                    this.log().warn((Object)e.getMessage());
                    verified = false;
                }
            }
            return verified;
        }
    }

    static class TriggerResults {
        private TriggerProcessor m_trigger;
        private ResultSet m_resultSet;
        private boolean m_successful;

        public TriggerResults(TriggerProcessor trigger, ResultSet set, boolean successful) {
            this.m_trigger = trigger;
            this.m_resultSet = set;
            this.m_successful = successful;
        }

        public boolean hasTrigger() {
            return this.m_trigger.hasTrigger();
        }

        public ResultSet getResultSet() {
            return this.m_resultSet;
        }

        public boolean isSuccessful() {
            return this.m_successful;
        }
    }

    static class TriggerProcessor {
        private String m_automationName;
        private Trigger m_trigger;

        public TriggerProcessor(String automationName, Trigger trigger) {
            this.m_automationName = automationName;
            this.m_trigger = trigger;
        }

        public Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public Trigger getTrigger() {
            return this.m_trigger;
        }

        public boolean hasTrigger() {
            return this.m_trigger != null;
        }

        public String getTriggerSQL() {
            if (this.hasTrigger()) {
                return this.getTrigger().getStatement().getContent();
            }
            return null;
        }

        public String getName() {
            return this.getTrigger().getName();
        }

        public String toString() {
            return this.m_trigger == null ? "<No-Trigger>" : this.m_trigger.getName();
        }

        ResultSet runTriggerQuery() throws SQLException {
            try {
                if (!this.hasTrigger()) {
                    return null;
                }
                Connection conn = Transaction.getConnection(this.m_trigger.getDataSource());
                Statement triggerStatement = conn.createStatement(1005, 1007);
                Transaction.register(triggerStatement);
                ResultSet triggerResultSet = triggerStatement.executeQuery(this.getTriggerSQL());
                Transaction.register(triggerResultSet);
                return triggerResultSet;
            }
            catch (SQLException e) {
                this.log().warn((Object)("Error executing trigger " + this.getName()), (Throwable)e);
                throw e;
            }
        }

        public boolean triggerRowCheck(int trigRowCount, String trigOp, int resultRows) {
            if (trigRowCount == 0 || trigOp == null) {
                this.log().debug((Object)("triggerRowCheck: trigger has no row-count restrictions: operator is: " + trigOp + ", row-count is: " + trigRowCount));
                return true;
            }
            this.log().debug((Object)("triggerRowCheck: Verifying trigger resulting row count " + resultRows + " is " + trigOp + " " + trigRowCount));
            boolean runAction = false;
            if ("<".equals(trigOp)) {
                if (resultRows < trigRowCount) {
                    runAction = true;
                }
            } else if ("<=".equals(trigOp)) {
                if (resultRows <= trigRowCount) {
                    runAction = true;
                }
            } else if ("=".equals(trigOp)) {
                if (resultRows == trigRowCount) {
                    runAction = true;
                }
            } else if (">=".equals(trigOp)) {
                if (resultRows >= trigRowCount) {
                    runAction = true;
                }
            } else if (">".equals(trigOp) && resultRows > trigRowCount) {
                runAction = true;
            }
            this.log().debug((Object)("Row count verification is: " + runAction));
            return runAction;
        }
    }
}

