/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.SyslogHandler;

public class SyslogConnection
implements Runnable {
    private DatagramPacket _packet;
    private FifoQueue _queue;
    private String m_logPrefix;
    private String _matchPattern;
    private int _hostGroup;
    private int _messageGroup;
    private UeiList _ueiList;
    private HideMessage _hideMessages;
    private static final String LOG4J_CATEGORY = "OpenNMS.Syslogd";

    public SyslogConnection(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages) {
        this._packet = packet;
        this._matchPattern = matchPattern;
        this._hostGroup = hostGroup;
        this._messageGroup = messageGroup;
        this._ueiList = ueiList;
        this._hideMessages = hideMessages;
        this.m_logPrefix = LOG4J_CATEGORY;
    }

    public void run() {
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        ConvertToEvent re = null;
        try {
            re = ConvertToEvent.make(this._packet.getAddress(), this._packet.getPort(), this._packet.getData(), this._packet.getLength(), this._matchPattern, this._hostGroup, this._messageGroup, this._ueiList, this._hideMessages);
        }
        catch (UnsupportedEncodingException e1) {
            log.debug((Object)"Failure to convert package");
        }
        log.debug((Object)"Sending received packet to the queue");
        SyslogHandler.queueManager.putInQueue(re);
        try {
            Thread.sleep((int)(Math.random() * 100.0));
        }
        catch (InterruptedException e) {
            log.debug((Object)("Syslogd: Interruption " + e));
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

