/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.ssh;

import java.net.InetAddress;
import java.util.Collections;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.protocols.InsufficientParametersException;
import org.opennms.netmgt.protocols.ssh.Ssh;

public class Poll
extends Ssh
implements org.opennms.netmgt.protocols.Poll {
    public Poll() {
    }

    public Poll(InetAddress address) {
        this.setAddress(address);
    }

    public Poll(InetAddress address, int port) {
        this.setAddress(address);
        this.setPort(port);
    }

    public Poll(InetAddress address, int port, int timeout) {
        this.setAddress(address);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    public PollStatus poll(TimeoutTracker tracker) throws InsufficientParametersException {
        tracker.startAttempt();
        boolean isAvailable = this.connect();
        double responseTime = tracker.elapsedTimeInMillis();
        PollStatus ps = PollStatus.unavailable();
        String errorMessage = "";
        if (this.getError() != null) {
            errorMessage = this.getError().getMessage();
        }
        if (isAvailable) {
            ps = PollStatus.available((Double)responseTime);
        } else if (errorMessage.matches("^.*java.net.NoRouteToHostException.*$")) {
            ps = PollStatus.unavailable((String)"no route to host");
        } else if (errorMessage.matches("^.*(timeout: socket is not established|java.io.InterruptedIOException).*$")) {
            ps = PollStatus.unavailable((String)"connection timed out");
        } else if (errorMessage.matches("^.*(connection is closed by foreign host|java.net.ConnectException).*$")) {
            ps = PollStatus.unavailable((String)"connection exception");
        } else if (errorMessage.matches("^.*java.io.IOException.*$")) {
            ps = PollStatus.unavailable((String)"I/O exception");
        }
        return ps;
    }

    public PollStatus poll() throws InsufficientParametersException {
        TimeoutTracker tracker = new TimeoutTracker(Collections.emptyMap(), 1, this.getTimeout());
        return this.poll(tracker);
    }
}

