/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.xml.event.Event;

public abstract class PollableElement {
    private PollableContainer m_parent;
    private PollStatus m_status = PollStatus.unknown();
    private boolean m_statusChanged = false;
    private PollEvent m_cause;
    private boolean m_deleted;

    protected PollableElement(PollableContainer parent) {
        this.m_parent = parent;
    }

    protected PollableContainer getParent() {
        return this.m_parent;
    }

    protected void setParent(PollableContainer newParent) {
        this.m_parent = newParent;
    }

    public void visit(PollableVisitor v) {
        this.visitThis(v);
    }

    protected void visitThis(PollableVisitor v) {
        v.visitElement(this);
    }

    public PollStatus getStatus() {
        return this.m_status;
    }

    private void setStatus(PollStatus status) {
        this.m_status = status;
    }

    public boolean isStatusChanged() {
        return this.m_statusChanged;
    }

    private void setStatusChanged(boolean statusChanged) {
        this.m_statusChanged = statusChanged;
    }

    public void updateStatus(PollStatus newStatus) {
        if (!this.getStatus().equals((Object)newStatus)) {
            ThreadCategory.getInstance(this.getClass()).info((Object)("Changing status of PollableElement " + this + " from " + this.getStatus() + " to " + newStatus));
            this.setStatus(newStatus);
            this.setStatusChanged(true);
        }
    }

    public void resetStatusChanged() {
        this.setStatusChanged(false);
    }

    public void recalculateStatus() {
    }

    public abstract PollContext getContext();

    public PollStatus doPoll(PollableElement elem) {
        if (this.getParent() == null) {
            this.resetStatusChanged();
            return this.poll(elem);
        }
        return this.getParent().doPoll(elem);
    }

    public PollableElement getLockRoot() {
        PollableContainer parent = this.getParent();
        return parent == null ? this : parent.getLockRoot();
    }

    public boolean isTreeLockAvailable() {
        return this.getLockRoot().isTreeLockAvailable();
    }

    public void obtainTreeLock(long timeout) {
        this.getLockRoot().obtainTreeLock(timeout);
    }

    public void releaseTreeLock() {
        this.getLockRoot().releaseTreeLock();
    }

    public void withTreeLock(Runnable r) {
        this.withTreeLock(r, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withTreeLock(Runnable r, long timeout) {
        try {
            Category log = ThreadCategory.getInstance(this.getClass());
            PollableElement lock = this.getLockRoot();
            this.obtainTreeLock(timeout);
            r.run();
        }
        finally {
            this.releaseTreeLock();
        }
    }

    public abstract PollStatus poll();

    protected PollStatus poll(PollableElement elem) {
        if (elem != this) {
            throw new IllegalArgumentException("Invalid parameter to poll on " + this + ": " + elem);
        }
        return this.poll();
    }

    public PollableElement selectPollElement() {
        return this;
    }

    public abstract Event createDownEvent(Date var1);

    public abstract Event createUpEvent(Date var1);

    protected void createOutage(PollEvent cause) {
        this.setCause(cause);
    }

    protected void resolveOutage(PollEvent resolution) {
        this.setCause(null);
    }

    public boolean hasOpenOutage() {
        return this.m_cause != null;
    }

    public void setCause(PollEvent cause) {
        this.m_cause = cause;
    }

    public PollEvent getCause() {
        return this.m_cause;
    }

    public void processStatusChange(Date date) {
        if (this.getStatus().isDown() && this.isStatusChanged()) {
            this.processGoingDown(date);
        } else if (this.getStatus().isUp() && this.isStatusChanged()) {
            this.processComingUp(date);
        }
    }

    protected void processComingUp(Date date) {
        PollEvent resolution = this.getContext().sendEvent(this.createUpEvent(date));
        this.processResolution(this.getCause(), resolution);
    }

    protected void processResolution(PollEvent cause, PollEvent resolution) {
        this.resolveOutage(resolution);
    }

    protected void processGoingDown(Date date) {
        PollEvent cause = this.getContext().sendEvent(this.createDownEvent(date));
        this.processCause(cause);
    }

    protected void processCause(PollEvent cause) {
        if (!this.hasOpenOutage()) {
            this.createOutage(cause);
        }
    }

    protected void resolveAllOutages(PollEvent resolvedCause, PollEvent resolution) {
        if (resolvedCause.equals(this.getCause())) {
            this.resolveOutage(resolution);
        }
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void delete() {
        Runnable r = new Runnable(){

            public void run() {
                PollableElement.this.m_deleted = true;
                if (PollableElement.this.m_parent != null) {
                    PollableElement.this.getParent().deleteMember(PollableElement.this);
                    PollableElement.this.getParent().recalculateStatus();
                }
            }
        };
        this.withTreeLock(r);
    }

    protected void processLingeringCauses(PollEvent resolvedCause, PollEvent resolution) {
        if (this.getStatus().isDown() && resolvedCause.equals(this.getCause())) {
            this.resolveAllOutages(resolvedCause, resolution);
            this.processGoingDown(resolution.getDate());
        } else if (this.getStatus().isUp() && resolvedCause.equals(this.getCause())) {
            this.processResolution(resolvedCause, resolution);
        } else if (this.getStatus().isUp() && !resolvedCause.equals(this.getCause())) {
            this.processComingUp(resolution.getDate());
        }
    }
}

