/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyStoringServiceMonitorAdaptor
implements ServiceMonitor {
    public static final String DEFAULT_BASENAME = "response-time";
    private ServiceMonitor m_serviceMonitor;
    private PollerConfig m_pollerConfig;
    private Package m_pkg;

    public LatencyStoringServiceMonitorAdaptor(ServiceMonitor monitor, PollerConfig config, Package pkg) {
        this.m_serviceMonitor = monitor;
        this.m_pollerConfig = config;
        this.m_pkg = pkg;
    }

    @Override
    public void initialize(Map parameters) {
        try {
            RrdUtils.initialize();
            this.m_serviceMonitor.initialize(parameters);
        }
        catch (RrdException e) {
            throw new IllegalStateException("Unable to initialize RrdUtils: " + (Object)((Object)e), e);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        try {
            RrdUtils.initialize();
            this.m_serviceMonitor.initialize(svc);
        }
        catch (RrdException e) {
            throw new IllegalStateException("Unable to initialize RrdUtils: " + (Object)((Object)e), e);
        }
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map parameters) {
        PollStatus status = this.m_serviceMonitor.poll(svc, parameters);
        if (!status.getProperties().isEmpty()) {
            this.storeResponseTime(svc, new LinkedHashMap<String, Number>(status.getProperties()), parameters);
        }
        if ("true".equals(ParameterMap.getKeyedString(parameters, "invert-status", "false"))) {
            if (status.isAvailable()) {
                return PollStatus.unavailable((String)"This is an inverted service and the underlying service has started responding");
            }
            return PollStatus.available();
        }
        return status;
    }

    private void storeResponseTime(MonitoredService svc, LinkedHashMap<String, Number> entries, Map parameters) {
        String rrdPath = ParameterMap.getKeyedString(parameters, "rrd-repository", null);
        String dsName = ParameterMap.getKeyedString(parameters, "ds-name", DEFAULT_BASENAME);
        String rrdBaseName = ParameterMap.getKeyedString(parameters, "rrd-base-name", dsName);
        if (rrdPath == null) {
            this.log().debug((Object)"storeResponseTime: RRD repository not specified in parameters, latency data will not be stored.");
            return;
        }
        if (!entries.containsKey(dsName) && entries.containsKey(DEFAULT_BASENAME)) {
            entries.put(dsName, entries.get(DEFAULT_BASENAME));
            entries.remove(DEFAULT_BASENAME);
        }
        this.updateRRD(rrdPath, svc.getAddress(), rrdBaseName, entries);
    }

    public void updateRRD(String repository, InetAddress addr, String rrdBaseName, String dsName, long value) {
        LinkedHashMap<String, Number> lhm = new LinkedHashMap<String, Number>();
        lhm.put(dsName, value);
        this.updateRRD(repository, addr, rrdBaseName, lhm);
    }

    public void updateRRD(String repository, InetAddress addr, String rrdBaseName, LinkedHashMap<String, Number> entries) {
        block6: {
            try {
                ArrayList<RrdDataSource> dsList = new ArrayList<RrdDataSource>(entries.size());
                for (String dsName : entries.keySet()) {
                    dsList.add(new RrdDataSource(dsName, "GAUGE", this.m_pollerConfig.getStep(this.m_pkg) * 2, "U", "U"));
                }
                this.createRRD(repository, addr, rrdBaseName, dsList);
                String path = repository + File.separator + addr.getHostAddress();
                StringBuffer value = new StringBuffer();
                Iterator<String> i = entries.keySet().iterator();
                while (i.hasNext()) {
                    Number num = entries.get(i.next());
                    if (num == null || Double.isNaN(num.doubleValue())) {
                        value.append("U");
                    } else {
                        NumberFormat nf = NumberFormat.getInstance(Locale.US);
                        nf.setGroupingUsed(false);
                        nf.setMinimumFractionDigits(0);
                        nf.setMaximumFractionDigits(Integer.MAX_VALUE);
                        nf.setMinimumIntegerDigits(0);
                        nf.setMaximumIntegerDigits(Integer.MAX_VALUE);
                        value.append(nf.format(num.doubleValue()));
                    }
                    if (!i.hasNext()) continue;
                    value.append(":");
                }
                RrdUtils.updateRRD((String)addr.getHostAddress(), (String)path, (String)rrdBaseName, (String)value.toString());
            }
            catch (RrdException e) {
                if (!this.log().isEnabledFor((Priority)Level.ERROR)) break block6;
                String msg = e.getMessage();
                this.log().error((Object)msg);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public boolean createRRD(String repository, InetAddress addr, String rrdBaseName, String dsName) throws RrdException {
        List<RrdDataSource> dsList = Collections.singletonList(new RrdDataSource(dsName, "GAUGE", this.m_pollerConfig.getStep(this.m_pkg) * 2, "U", "U"));
        return this.createRRD(repository, addr, rrdBaseName, dsList);
    }

    public boolean createRRD(String repository, InetAddress addr, String rrdBaseName, List<RrdDataSource> dsList) throws RrdException {
        List<String> rraList = this.m_pollerConfig.getRRAList(this.m_pkg);
        String path = repository + File.separator + addr.getHostAddress();
        return RrdUtils.createRRD((String)addr.getHostAddress(), (String)path, (String)rrdBaseName, (int)this.m_pollerConfig.getStep(this.m_pkg), dsList, rraList);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void release() {
        this.m_serviceMonitor.release();
    }

    @Override
    public void release(MonitoredService svc) {
        this.m_serviceMonitor.release(svc);
    }
}

