/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.utils.ParameterMap;

public class TimeoutTracker {
    private int m_retry;
    private long m_timeoutInNanos;
    private long m_timeoutInMillis;
    private long m_timeoutInSeconds;
    private boolean m_strictTimeouts;
    private int m_attempt = 0;
    private long m_nextRetryTimeNanos = -1L;
    private long m_attemptStartTimeNanos = -1L;

    public TimeoutTracker(Map parameters, int defaultRetry, int defaultTimeout) {
        this.m_retry = ParameterMap.getKeyedInteger(parameters, "retry", defaultRetry);
        this.m_timeoutInMillis = Math.max(10L, (long)ParameterMap.getKeyedInteger(parameters, "timeout", defaultTimeout));
        this.m_timeoutInNanos = Math.max(10000000L, TimeUnit.NANOSECONDS.convert(this.m_timeoutInMillis, TimeUnit.MILLISECONDS));
        this.m_timeoutInSeconds = Math.max(1L, TimeUnit.SECONDS.convert(this.m_timeoutInMillis, TimeUnit.SECONDS));
        this.m_strictTimeouts = ParameterMap.getKeyedBoolean(parameters, "strict-timeout", false);
        this.resetAttemptStartTime();
    }

    public boolean shouldRetry() {
        return this.m_attempt <= this.m_retry;
    }

    public long getTimeoutInMillis() {
        return this.m_timeoutInMillis;
    }

    public long getTimeoutInSeconds() {
        return this.m_timeoutInSeconds;
    }

    public void reset() {
        this.m_attempt = 0;
        this.resetAttemptStartTime();
    }

    private void resetAttemptStartTime() {
        this.m_attemptStartTimeNanos = -1L;
    }

    public void nextAttempt() {
        ++this.m_attempt;
        this.resetAttemptStartTime();
    }

    public int getAttempt() {
        return this.m_attempt;
    }

    public void startAttempt() {
        long now = System.nanoTime();
        while (this.m_strictTimeouts && now < this.m_nextRetryTimeNanos) {
            this.sleep(this.m_nextRetryTimeNanos - now);
            now = System.nanoTime();
        }
        this.m_attemptStartTimeNanos = System.nanoTime();
        this.m_nextRetryTimeNanos = this.m_attemptStartTimeNanos + this.m_timeoutInNanos;
    }

    private void sleep(long nanos) {
        long millis = nanos / 1000000L;
        int remainingNanos = (int)(nanos % 1000000L);
        try {
            Thread.sleep(millis, remainingNanos);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private void assertStarted() {
        if (this.m_attemptStartTimeNanos < 0L) {
            throw new IllegalStateException("Failed to call startAttempt before requesting elapsedTime.. This is most likely a bug");
        }
    }

    public double elapsedTimeInMillis() {
        return this.convertFromNanos(this.elapsedTimeNanos(), TimeUnit.MILLISECONDS);
    }

    public long elapsedTimeNanos() {
        long nanoTime = System.nanoTime();
        this.assertStarted();
        return nanoTime - this.m_attemptStartTimeNanos;
    }

    public double elapsedTime(TimeUnit unit) {
        return this.convertFromNanos(this.elapsedTimeNanos(), unit);
    }

    private double convertFromNanos(double nanos, TimeUnit unit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, unit);
        return nanos / nanosPerUnit;
    }

    public String toString() {
        return new StringBuilder(64).append("timeout: ").append(this.getTimeoutInMillis()).append("ms").append(" retry: ").append(this.m_attempt).append(" of ").append(this.m_retry).toString();
    }

    public int getSoTimeout() {
        return (int)this.getTimeoutInMillis();
    }

    public int getConnectionTimeout() {
        return (int)this.getTimeoutInMillis();
    }
}

