/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.mailtransporttest.MailTransportTest;
import org.opennms.netmgt.config.mailtransporttest.ReadmailTest;
import org.opennms.netmgt.config.mailtransporttest.SendmailTest;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailTransportParameters {
    public static final String KEY = MailTransportParameters.class.getName();
    private static final int DEFAULT_RETRY = 1;
    private static final int DEFAULT_TIMEOUT = 3000;
    private Map<String, String> m_parameterMap;
    private MailTransportTest m_transportTest;
    private String m_testSubjectSuffix;
    private boolean m_end2EndTestInProgress = false;
    private Properties m_javamailProperties = new Properties();

    MailTransportParameters(Map<String, String> parameterMap) {
        this.m_parameterMap = parameterMap;
        String test = this.getStringParm("mail-transport-test", null);
        if (test == null) {
            throw new IllegalArgumentException("mail-transport-test must be set in monitor parameters");
        }
        this.m_transportTest = this.parseMailTransportTest(test);
    }

    static synchronized MailTransportParameters get(Map paramterMap) {
        MailTransportParameters parms = (MailTransportParameters)paramterMap.get(KEY);
        if (parms == null) {
            parms = new MailTransportParameters(paramterMap);
            paramterMap.put(KEY, parms);
        }
        return parms;
    }

    Map<String, String> getParameterMap() {
        return this.m_parameterMap;
    }

    MailTransportTest getTransportTest() {
        return this.m_transportTest;
    }

    MailTransportTest parseMailTransportTest(String test) {
        try {
            return (MailTransportTest)Unmarshaller.unmarshal(MailTransportTest.class, (Reader)new StringReader(test));
        }
        catch (MarshalException e) {
            throw new IllegalArgumentException("Unable to parse mail-test-sequence for MailTransportMonitor: " + test, e);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("Unable to parse page-sequence for HttpMonitor: " + test, e);
        }
    }

    private String getStringParm(String key, String deflt) {
        return ParameterMap.getKeyedString(this.getParameterMap(), key, deflt);
    }

    private int getIntParm(String key, int defValue) {
        return ParameterMap.getKeyedInteger(this.getParameterMap(), key, defValue);
    }

    public int getRetries() {
        return this.getIntParm("retry", 1);
    }

    public int getTimeout() {
        return this.getIntParm("timeout", 3000);
    }

    public String getReadTestPassword() {
        return this.getReadTest().getUserAuth().getPassword();
    }

    ReadmailTest getReadTest() {
        return this.getTransportTest().getMailTest().getReadmailTest();
    }

    public String getTestSubjectSuffix() {
        return this.m_testSubjectSuffix;
    }

    public void setTestSubjectSuffix(String suffix) {
        this.m_testSubjectSuffix = suffix;
    }

    public String getComputedTestSubject() {
        try {
            if (this.getSendTestSubject() != null) {
                return this.getSendTestSubject() + ':' + (this.m_testSubjectSuffix == null ? null : this.m_testSubjectSuffix);
            }
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    String getSendTestFrom() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getFrom();
    }

    public boolean isSendTestUseAuth() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().isUseAuthentication();
    }

    public String getSendTestCharSet() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getCharSet();
    }

    public String getSendTestMessageContentType() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMessageContentType();
    }

    public boolean isSendTestDebug() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().isDebug();
    }

    public String getSendTestMessageEncoding() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMessageEncoding();
    }

    public String getSendTestMailer() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getMailer();
    }

    public String getSendTestHost() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailHost().getHost();
    }

    public String getSendTestMessageBody() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getBody();
    }

    public String getSendTestPassword() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getUserAuth().getPassword();
    }

    public boolean isSendTestIsQuitWait() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().isQuitWait();
    }

    public int getSendTestPort() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return (int)this.getSendTest().getSendmailHost().getPort();
    }

    public boolean isSendTestIsSslEnable() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().isSslEnable();
    }

    public boolean isSendTestStartTls() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().isStartTls();
    }

    public String getSendTestSubject() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getSubject();
    }

    public String getSendTestRecipeint() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailMessage().getTo();
    }

    public String getSendTestTransport() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getSendmailProtocol().getTransport();
    }

    public boolean isSendTestUseJmta() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().isUseJmta();
    }

    public String getSendTestUserName() {
        if (this.getSendTest() == null) {
            throw new IllegalStateException("Request for send mailparmaters invalid due to no sendmail specification in config");
        }
        return this.getSendTest().getUserAuth().getUserName();
    }

    SendmailTest getSendTest() {
        return this.getTransportTest().getMailTest().getSendmailTest();
    }

    public String getReadTestHost() {
        return this.getReadTest().getReadmailHost().getHost();
    }

    public int getReadTestPort() {
        return (int)this.getReadTest().getReadmailHost().getPort();
    }

    public String getReadTestUserName() {
        return this.getReadTest().getUserAuth().getUserName();
    }

    public String getReadTestFolder() {
        return this.getReadTest().getMailFolder();
    }

    public String getReadTestProtocol() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().getTransport();
    }

    public boolean isReadTestStartTlsEnabled() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().isStartTls();
    }

    public boolean isReadTestSslEnabled() {
        return this.getReadTest().getReadmailHost().getReadmailProtocol().isSslEnable();
    }

    public void setEnd2EndTestInProgress(boolean b) {
        this.m_end2EndTestInProgress = b;
    }

    public boolean isEnd2EndTestInProgress() {
        return this.m_end2EndTestInProgress;
    }

    public long getReadTestAttemptInterval() {
        return this.getReadTest().getAttemptInterval();
    }

    public long getSendTestAttemptInterval() {
        return this.getSendTest().getAttemptInterval();
    }

    public Properties getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(Properties props) {
        this.m_javamailProperties = props;
    }

    public void setReadTestHost(String host) {
        this.getReadTest().getReadmailHost().setHost(host);
    }

    public void setSendTestHost(String host) {
        this.getSendTest().getSendmailHost().setHost(host);
    }
}

