/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class LdapMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 1;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_BASE = "base";
    private static final String DEFAULT_FILTER = "(objectclass=*)";

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        int serviceStatus = 2;
        String reason = null;
        TimeoutTracker tracker = new TimeoutTracker(parameters, 1, 3000);
        int ldapVersion = ParameterMap.getKeyedInteger(parameters, "version", 3);
        int ldapPort = ParameterMap.getKeyedInteger(parameters, "port", 389);
        String searchBase = ParameterMap.getKeyedString(parameters, "searchbase", DEFAULT_BASE);
        String searchFilter = ParameterMap.getKeyedString(parameters, "searchfilter", DEFAULT_FILTER);
        String password = (String)parameters.get("password");
        String ldapDn = (String)parameters.get("dn");
        Object addressObject = iface.getAddress();
        String address = null;
        if (addressObject instanceof InetAddress) {
            address = ((InetAddress)addressObject).getHostAddress();
        } else if (addressObject instanceof String) {
            address = (String)addressObject;
        }
        Double responseTime = null;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress((InetAddress)iface.getAddress(), ldapPort), tracker.getConnectionTimeout());
            socket.setSoTimeout(tracker.getSoTimeout());
            this.log().debug((Object)("LdapMonitor: connected to host: " + address + " on port: " + ldapPort));
            serviceStatus = 3;
            if (socket != null) {
                socket.close();
            }
            LDAPConnection lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(tracker.getSoTimeout()));
            tracker.reset();
            while (tracker.shouldRetry() && serviceStatus != 1) {
                block25: {
                    block26: {
                        this.log().debug((Object)("polling LDAP on " + address + ", " + tracker));
                        tracker.startAttempt();
                        try {
                            lc.connect(address, ldapPort);
                            this.log().debug((Object)("connected to LDAP server " + address + " on port " + ldapPort));
                        }
                        catch (LDAPException e) {
                            this.log().debug((Object)("could not connect to LDAP server " + address + " on port " + ldapPort));
                            reason = "could not connect to LDAP server " + address + " on port " + ldapPort;
                            break block25;
                        }
                        if (ldapDn != null && password != null) {
                            try {
                                lc.bind(ldapVersion, ldapDn, password.getBytes());
                                if (!this.log().isDebugEnabled()) break block26;
                                this.log().debug((Object)("bound to LDAP server version " + ldapVersion + " with distinguished name " + ldapDn));
                                this.log().debug((Object)("poll: responseTime= " + tracker.elapsedTimeInMillis() + "ms"));
                            }
                            catch (LDAPException e) {
                                try {
                                    lc.disconnect();
                                }
                                catch (LDAPException ex) {
                                    this.log().debug((Object)ex);
                                }
                                this.log().debug((Object)("could not bind to LDAP server version " + ldapVersion + " with distinguished name " + ldapDn));
                                reason = "could not bind to LDAP server version " + ldapVersion + " with distinguished name " + ldapDn;
                                break block25;
                            }
                        }
                    }
                    boolean attributeOnly = true;
                    String[] attrs = new String[]{"1.1"};
                    int searchScope = 1;
                    this.log().debug((Object)("running search " + searchFilter + " from " + searchBase));
                    LDAPSearchResults results = null;
                    try {
                        results = lc.search(searchBase, searchScope, searchFilter, attrs, attributeOnly);
                        if (results != null && results.hasMore()) {
                            responseTime = tracker.elapsedTimeInMillis();
                            this.log().debug((Object)"search yielded results");
                            serviceStatus = 1;
                        } else {
                            this.log().debug((Object)"no results found from search");
                            reason = "No results found from search";
                            serviceStatus = 2;
                        }
                    }
                    catch (LDAPException e) {
                        try {
                            lc.disconnect();
                        }
                        catch (LDAPException ex) {
                            this.log().debug((Object)ex);
                        }
                        this.log().debug((Object)("could not perform search " + searchFilter + " from " + searchBase));
                        reason = "could not perform search " + searchFilter + " from " + searchBase;
                        break block25;
                    }
                    try {
                        lc.disconnect();
                        this.log().debug((Object)("disconected from LDAP server " + address + " on port "));
                    }
                    catch (LDAPException e) {
                        this.log().debug((Object)e);
                    }
                }
                tracker.nextAttempt();
            }
        }
        catch (ConnectException e) {
            this.log().debug((Object)("connection refused to host " + address), (Throwable)e);
            reason = "connection refused to host " + address;
        }
        catch (NoRouteToHostException e) {
            this.log().debug((Object)("No route to host " + address), (Throwable)e);
            reason = "No route to host " + address;
        }
        catch (InterruptedIOException e) {
            this.log().debug((Object)("did not connect to host with " + tracker));
            reason = "did not connect to host with " + tracker;
        }
        catch (Throwable t) {
            this.log().debug((Object)("An undeclared throwable exception caught contacting host " + address), t);
            reason = "An undeclared throwable exception caught contacting host " + address;
        }
        return PollStatus.get((int)serviceStatus, (String)reason, responseTime);
    }

    private class TimeoutLDAPSocket
    implements LDAPSocketFactory {
        private int m_timeout;

        public TimeoutLDAPSocket(int timeout) {
            this.m_timeout = timeout;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(this.m_timeout);
            return socket;
        }
    }
}

