/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;

public class DbVlanEntry {
    static final char STATUS_ACTIVE = 'A';
    static final char STATUS_NOT_POLLED = 'N';
    static final char STATUS_DELETE = 'D';
    static final char STATUS_UNKNOWN = 'K';
    int m_nodeId;
    int m_vlanId;
    String m_vlanname;
    int m_vlantype;
    int m_vlanstatus;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_STPNODE = "SELECT vlanname,vlantype,vlanstatus,status,lastPollTime FROM vlan WHERE nodeid = ? AND vlanid = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_VLANNAME = 1;
    private static final int CHANGED_VLANTYPE = 2;
    private static final int CHANGED_VLANSTATUS = 4;
    private static final int CHANGED_STATUS = 8;
    private static final int CHANGED_POLLTIME = 16;

    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO vlan (nodeid,vlanid");
        StringBuffer values = new StringBuffer("?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",vlanname");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",vlantype");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",vlanstatus");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",status");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",lastpolltime");
        }
        names.append(") VALUES (").append(values).append(')');
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbVlanEntry.insert: SQL insert statment = " + names.toString()));
        }
        PreparedStatement stmt = c.prepareStatement(names.toString());
        int ndx = 1;
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setInt(ndx++, this.m_vlanId);
        if ((this.m_changed & 1) == 1) {
            stmt.setString(ndx++, this.m_vlanname);
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setInt(ndx++, this.m_vlantype);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setInt(ndx++, this.m_vlanstatus);
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
        }
        int rc = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbVlanEntry.insert: row " + rc));
        }
        stmt.close();
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE vlan SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("vlanname = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("vlantype = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("vlanstatus = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND vlanid = ? ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbVlanEntry.update: SQL insert statment = " + sqlText.toString()));
        }
        PreparedStatement stmt = c.prepareStatement(sqlText.toString());
        int ndx = 1;
        if ((this.m_changed & 1) == 1) {
            stmt.setString(ndx++, this.m_vlanname);
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setInt(ndx++, this.m_vlantype);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setInt(ndx++, this.m_vlanstatus);
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
        }
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setInt(ndx++, this.m_vlanId);
        int rc = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbVlanEntry.update: row " + rc));
        }
        stmt.close();
        this.m_changed = 0;
    }

    private boolean load(Connection c) throws SQLException {
        String str;
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        stmt = c.prepareStatement(SQL_LOAD_STPNODE);
        stmt.setInt(1, this.m_nodeId);
        stmt.setInt(2, this.m_vlanId);
        ResultSet rset = stmt.executeQuery();
        if (!rset.next()) {
            rset.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"DbVlanEntry.load: no result found");
            }
            return false;
        }
        int ndx = 1;
        this.m_vlanname = rset.getString(ndx++);
        this.m_vlantype = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_vlantype = -1;
        }
        this.m_vlanstatus = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_vlanstatus = -1;
        }
        this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
        this.m_lastPollTime = rset.getTimestamp(ndx++);
        rset.close();
        stmt.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)"DbVlanEntry.load: result found");
        }
        this.m_changed = 0;
        return true;
    }

    DbVlanEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    DbVlanEntry(int nodeId, int vlanid, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_vlanId = vlanid;
        this.m_fromDb = exists;
        this.m_vlantype = -1;
        this.m_vlanstatus = -1;
        this.m_vlanname = "default";
    }

    static DbVlanEntry create(int nodeId, int vlanid) {
        return new DbVlanEntry(nodeId, vlanid, false);
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public int getVlanId() {
        return this.m_vlanId;
    }

    public String getVlanName() {
        return this.m_vlanname;
    }

    void setVlanName(String vlanname) {
        this.m_vlanname = vlanname;
        this.m_changed |= 1;
    }

    boolean hasBaseVlanNameChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateVlanName(String vlanname) {
        if (vlanname != this.m_vlanname) {
            this.setVlanName(vlanname);
            return true;
        }
        return false;
    }

    public int getVlanType() {
        return this.m_vlantype;
    }

    void setVlanType(int vlantype) {
        this.m_vlantype = vlantype;
        this.m_changed |= 2;
    }

    boolean hasBaseTypeChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateVlanType(int vlantype) {
        if (vlantype != this.m_vlantype) {
            this.setVlanType(vlantype);
            return true;
        }
        return false;
    }

    public int getVlanStatus() {
        return this.m_vlanstatus;
    }

    void setVlanStatus(int vlanstatus) {
        this.m_vlanstatus = vlanstatus;
        this.m_changed |= 4;
    }

    boolean hasBaseStatusChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateVlanStatus(int vlanstatus) {
        if (vlanstatus != this.m_vlanstatus) {
            this.setVlanStatus(vlanstatus);
            return true;
        }
        return false;
    }

    char get_status() {
        return this.m_status;
    }

    void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 8;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x10;
    }

    void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x10;
    }

    void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbVlanEntry get(int nid, int basevlan) throws SQLException {
        DbVlanEntry dbVlanEntry;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            dbVlanEntry = DbVlanEntry.get(db, nid, basevlan);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbVlanEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (db != null) {
                db.close();
            }
        }
        catch (SQLException e) {
            ThreadCategory.getInstance(DbVlanEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
        }
        return dbVlanEntry;
    }

    static DbVlanEntry get(Connection db, int nid, int basevlan) throws SQLException {
        DbVlanEntry entry = new DbVlanEntry(nid, basevlan, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from db = ").append(this.m_fromDb).append(sep);
        buf.append("node id = ").append(this.m_nodeId).append(sep);
        buf.append("vlan index = ").append(this.m_vlanId).append(sep);
        buf.append("vlan name = ").append(this.m_vlanname).append(sep);
        buf.append("vlan type id = ").append(this.m_vlantype).append(sep);
        buf.append("vlan status id = ").append(this.m_vlanstatus).append(sep);
        buf.append("status = ").append(this.m_status).append(sep);
        buf.append("last poll time = ").append(this.m_lastPollTime).append(sep);
        return buf.toString();
    }
}

