/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Enumeration;
import org.opennms.netmgt.config.MergeableDefinition;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;

public class SnmpConfigManager {
    private SnmpConfig m_config;

    public SnmpConfigManager(SnmpConfig config) {
        this.m_config = config;
    }

    public SnmpConfig getConfig() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeIntoConfig(Definition eventDef) {
        SnmpConfig snmpConfig = this.m_config;
        synchronized (snmpConfig) {
            MergeableDefinition matchingDef = this.findDefMatchingAttributes(eventDef);
            if (matchingDef != null) {
                matchingDef.mergeMatchingAttributeDef(eventDef);
            } else {
                matchingDef = new MergeableDefinition(eventDef);
                this.getConfig().addDefinition(matchingDef.getConfigDef());
            }
            this.purgeOtherDefs(matchingDef, eventDef);
            this.optimizeAllDefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MergeableDefinition findDefMatchingAttributes(Definition eventDef) {
        SnmpConfig snmpConfig = this.m_config;
        synchronized (snmpConfig) {
            MergeableDefinition matchingDef = null;
            Enumeration defEnum = this.getConfig().enumerateDefinition();
            while (defEnum.hasMoreElements()) {
                Definition def = (Definition)defEnum.nextElement();
                MergeableDefinition definition = new MergeableDefinition(def);
                if (!definition.equals(eventDef)) continue;
                matchingDef = new MergeableDefinition(def);
                break;
            }
            return matchingDef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOtherDefs(MergeableDefinition updatedDef, Definition eventDef) {
        SnmpConfig snmpConfig = this.m_config;
        synchronized (snmpConfig) {
            MergeableDefinition eventDefinition = new MergeableDefinition(eventDef);
            Definition[] defs = this.getConfig().getDefinition();
            for (int i = 0; i < defs.length; ++i) {
                MergeableDefinition def = new MergeableDefinition(defs[i]);
                if (def.getConfigDef() == updatedDef.getConfigDef()) continue;
                if (eventDefinition.isSpecific()) {
                    def.purgeSpecificFromDef(eventDefinition.getConfigDef().getSpecific(0));
                } else {
                    def.purgeRangeFromDef(eventDefinition.getConfigDef().getRange(0));
                }
                if (def.getConfigDef().getRangeCount() >= 1 || def.getConfigDef().getSpecificCount() >= 1) continue;
                this.getConfig().removeDefinition(def.getConfigDef());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeAllDefs() {
        SnmpConfig snmpConfig = this.m_config;
        synchronized (snmpConfig) {
            Definition[] defs = this.getConfig().getDefinition();
            for (int i = 0; i < defs.length; ++i) {
                MergeableDefinition definition = new MergeableDefinition(defs[i]);
                if (definition.getConfigDef().getSpecificCount() > 0) {
                    definition.optimizeSpecifics();
                }
                if (definition.getConfigDef().getRangeCount() <= 1) continue;
                definition.optimizeRanges();
            }
            this.getConfig().setDefinition(defs);
        }
    }
}

