/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.NotifdConfiguration;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifdConfigManager {
    protected NotifdConfiguration configuration;

    public synchronized void parseXml(Reader reader) throws MarshalException, ValidationException, IOException {
        this.configuration = (NotifdConfiguration)Unmarshaller.unmarshal(NotifdConfiguration.class, (Reader)reader);
    }

    public NotifdConfiguration getConfiguration() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration;
    }

    protected abstract void update() throws IOException, MarshalException, ValidationException;

    public String getNotificationStatus() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration.getStatus();
    }

    public void turnNotifdOn() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOn");
        this.configuration.setStatus("on");
        this.saveCurrent();
    }

    public void turnNotifdOff() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOff");
        this.configuration.setStatus("off");
        this.saveCurrent();
    }

    public boolean getNotificationMatch() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration.getMatchAll();
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.configuration, (Writer)stringWriter);
        String xml = stringWriter.toString();
        this.saveXml(xml);
        this.update();
    }

    protected abstract void saveXml(String var1) throws IOException;

    protected void sendEvent(String uei) {
        Event event = new Event();
        event.setUei(uei);
        event.setSource("NotifdConfigFactory");
        event.setTime(EventConstants.formatToString(new Date()));
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(event);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getNextNotifIdSql() throws IOException, MarshalException, ValidationException {
        return this.getConfiguration().getNextNotifId();
    }

    public boolean matchNotificationParameters(Event event, Notification notification) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean parmmatch = false;
        Parms parms = event.getParms();
        if (parms != null && notification.getVarbind() != null && notification.getVarbind().getVbname() != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            String notfValue = null;
            String notfName = notification.getVarbind().getVbname();
            if (notification.getVarbind().getVbvalue() != null) {
                notfValue = notification.getVarbind().getVbvalue();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"BroadcastEventProcessor:matchNotificationParameters:  Null value for varbind, assuming true.");
                parmmatch = true;
            }
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (!parmName.equals(notfName) || !parmContent.startsWith(notfValue)) continue;
                parmmatch = true;
            }
        } else if (notification.getVarbind() == null || notification.getVarbind().getVbname() == null) {
            parmmatch = true;
        }
        return parmmatch;
    }

    public String getNextUserNotifIdSql() throws IOException, MarshalException, ValidationException {
        return this.getConfiguration().getNextUserNotifId();
    }

    public Collection<AutoAcknowledge> getAutoAcknowledges() throws MarshalException, ValidationException, IOException {
        return this.getConfiguration().getAutoAcknowledgeCollection();
    }

    public Collection<String> getOutageCalendarNames() throws MarshalException, ValidationException, IOException {
        return this.getConfiguration().getOutageCalendarCollection();
    }
}

