/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.SpecificComparator;

public final class MergeableSpecific
implements Comparable {
    private String m_specific;
    private SpecificComparator m_comparator;
    private long m_value;

    public MergeableSpecific(String specific) {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_specific = specific;
        try {
            this.m_value = SnmpPeerFactory.toLong(InetAddress.getByName(specific));
        }
        catch (UnknownHostException e) {
            log.error((Object)"ComparableSpecific(): Exception in construction.", (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        this.m_comparator = new SpecificComparator();
    }

    public int compareTo(Object specific) {
        return this.m_comparator.compare(this.m_specific, specific);
    }

    public String getSpecific() {
        return this.m_specific;
    }

    public void setSpecific(String specific) {
        this.m_specific = specific;
    }

    public String toString() {
        return this.m_specific;
    }

    public long getValue() {
        return this.m_value;
    }
}

