/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.archiver.events.EventsArchiverConfiguration;

public final class EventsArchiverConfigFactory {
    private static EventsArchiverConfigFactory m_singleton = null;
    private EventsArchiverConfiguration m_config;
    private static boolean m_loaded = false;

    private EventsArchiverConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (EventsArchiverConfiguration)Unmarshaller.unmarshal(EventsArchiverConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENTS_ARCHIVER_CONFIG_FILE_NAME);
        m_singleton = new EventsArchiverConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        EventsArchiverConfigFactory.init();
    }

    public static synchronized EventsArchiverConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized String getArchiveAge() {
        return this.m_config.getArchiveAge();
    }

    public synchronized String getSeparator() {
        return this.m_config.getSeparator();
    }
}

