/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public class SnmpIfCollector
extends AggregateTracker {
    private Map m_results = new TreeMap();
    private String m_primaryIf;
    private List m_objList;
    private SnmpCollectionSet m_collectionSet;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        buffer.append(": Primary Interface: " + this.m_primaryIf);
        buffer.append(", object list: " + this.m_objList);
        buffer.append(", CollectionSet: ");
        if (this.m_collectionSet == null) {
            buffer.append("(null)");
        } else {
            buffer.append(this.m_collectionSet.getClass().getName());
            buffer.append("@");
            buffer.append(Integer.toHexString(this.m_collectionSet.hashCode()));
        }
        return buffer.toString();
    }

    public SnmpIfCollector(InetAddress address, List objList, SnmpCollectionSet collectionSet) {
        super(SnmpAttributeType.getCollectionTrackers(objList));
        SnmpIfCollector.log().debug((Object)("COLLECTING on list of " + objList.size() + " items"));
        SnmpIfCollector.log().debug((Object)("List is " + objList));
        this.m_primaryIf = address.getHostAddress();
        this.m_objList = objList;
        this.m_collectionSet = collectionSet;
    }

    protected static Category log() {
        return ThreadCategory.getInstance(SnmpIfCollector.class);
    }

    public List getEntries() {
        return new ArrayList(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        SnmpIfCollector.log().warn((Object)(this.m_primaryIf + ": genErr collecting ifData. " + msg));
    }

    protected void reportNoSuchNameErr(String msg) {
        SnmpIfCollector.log().info((Object)(this.m_primaryIf + ": noSuchName collecting ifData. " + msg));
    }

    protected void reportTooBigErr(String msg) {
        SnmpIfCollector.log().info((Object)(this.m_primaryIf + ": request tooBig. " + msg));
    }

    protected void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (base.toString().equals(".1.3.6.1.2.1.31.1.1.1.18") && (val.isNull() || val.toDisplayString() == null || val.toDisplayString().equals(""))) {
            SnmpIfCollector.log().debug((Object)"Skipping storeResult. Null or zero length ifAlias");
            return;
        }
        SNMPCollectorEntry entry = (SNMPCollectorEntry)((Object)this.m_results.get(inst));
        if (entry == null) {
            SnmpIfCollector.log().debug((Object)"Creating new SNMPCollectorEntry entry");
            entry = new SNMPCollectorEntry(this.m_objList, this.m_collectionSet);
            this.m_results.put(inst, entry);
        }
        entry.storeResult(base, inst, val);
    }

    public boolean hasData() {
        return !this.m_results.isEmpty();
    }

    public CollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }
}

