/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.ForceRescanState;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.utils.EventProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpCollector
implements ServiceCollector {
    static final String SERVICE_NAME = "SNMP";
    static final char nonAnRepl = '_';
    static final String AnReplEx = "-._";
    static final String IFALIAS_OID = ".1.3.6.1.2.1.31.1.1.1.18";
    static final String SQL_GET_SNMPIFALIASES = "SELECT snmpifalias FROM snmpinterface WHERE nodeid=? AND snmpifindex = ? AND snmpifalias != ''";
    static final String SQL_GET_LATEST_FORCED_RESCAN_EVENTID = "SELECT eventid FROM events WHERE (nodeid=? OR ipaddr=?) AND eventuei='uei.opennms.org/internal/capsd/forceRescan' ORDER BY eventid DESC LIMIT 1";
    static final String SQL_GET_LATEST_RESCAN_COMPLETED_EVENTID = "SELECT eventid FROM events WHERE nodeid=? AND eventuei='uei.opennms.org/internal/capsd/rescanCompleted' ORDER BY eventid DESC LIMIT 1";
    static final String INTERFACES_IFNUMBER = ".1.3.6.1.2.1.2.1";
    static final String NODE_SYSUPTIME = ".1.3.6.1.2.1.1.3";
    public static String SNMP_STORAGE_PRIMARY = "primary";
    static String SNMP_STORAGE_ALL = "all";
    static String SNMP_STORAGE_SELECT = "select";
    static int DEFAULT_MAX_VARS_PER_PDU = 30;
    static final String SNMP_PEER_KEY = "org.opennms.netmgt.collectd.SnmpCollector.SnmpPeer";
    static final String INTERFACE_COUNT_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifCount";
    static String IF_MAP_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifMap";
    static String NODE_INFO_KEY = "org.opennms.netmgt.collectd.SnmpCollector.nodeInfo";
    static String SNMP_STORAGE_KEY = "org.opennms.netmgt.collectd.SnmpCollector.snmpStorage";
    static String MAX_VARS_PER_PDU_STORAGE_KEY = "org.opennms.netmgt.collectd.SnmpCollector.maxVarsPerPdu";

    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void initialize(Map parameters) {
        this.initSnmpPeerFactory();
        this.initDataCollectionConfig();
        this.initDatabaseConnectionFactory();
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initDataCollectionConfig() {
        try {
            DataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initDataCollectionConfig: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initDataCollectionConfig: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initDataCollectionConfig: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initSnmpPeerFactory() {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initSnmpPeerFactory: Failed to load SNMP configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initSnmpPeerFactory: Failed to load SNMP configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initSnmpPeerFactory: Failed to load SNMP configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(CollectionAgent agent, Map parameters) {
        agent.validateAgent();
    }

    @Override
    public void release(CollectionAgent agent) {
        agent.setAttribute("SNMP_COLLECTION", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eventProxy, Map<String, String> parameters) {
        ServiceParameters params = new ServiceParameters(parameters);
        params.logIfAliasConfig();
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(agent, params);
        ForceRescanState forceRescanState = new ForceRescanState(agent, eventProxy);
        SnmpCollectionSet collectionSet = snmpCollection.createCollectionSet(agent);
        if (!collectionSet.hasDataToCollect()) {
            this.logNoDataToCollect(agent);
        }
        Collectd.instrumentation().beginCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
        try {
            collectionSet.collect();
            if (collectionSet.rescanNeeded()) {
                forceRescanState.rescanIndicated();
            }
            SnmpCollectionSet snmpCollectionSet = collectionSet;
            Collectd.instrumentation().endCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
            return snmpCollectionSet;
        }
        catch (CollectionWarning e) {
            try {
                try {
                    Collectd.instrumentation().reportCollectionError(agent.getNodeId(), agent.getHostAddress(), this.serviceName(), e);
                    e.reportError();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Collectd.instrumentation().endCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.log().error((Object)("Unexpected error during node SNMP collection for : " + agent.getHostAddress()), t);
            }
        }
        return null;
    }

    private void logNoDataToCollect(CollectionAgent agent) {
        this.log().info((Object)("agent " + agent + " defines no data to collect.  Skipping."));
    }

    Category log() {
        return ThreadCategory.getInstance(SnmpCollector.class);
    }

    int unexpected(CollectionAgent agent, Throwable t) {
        this.log().error((Object)("Unexpected error during node SNMP collection for " + agent.getHostAddress()), t);
        return 2;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return DataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

