/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.snmp.SnmpValue;

public class SnmpAttribute
extends AbstractCollectionAttribute {
    private CollectionResource m_resource;
    private SnmpAttributeType m_type;
    private SnmpValue m_val;

    public SnmpAttribute(CollectionResource resource, SnmpAttributeType type, SnmpValue val) {
        this.m_resource = resource;
        this.m_type = type;
        this.m_val = val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpAttribute) {
            SnmpAttribute attr = (SnmpAttribute)obj;
            return this.m_resource.equals(attr.m_resource) && this.m_type.equals(attr.m_type);
        }
        return false;
    }

    public int hashCode() {
        return this.m_resource.hashCode() ^ this.m_type.hashCode();
    }

    public void visit(CollectionSetVisitor visitor) {
        this.log().debug((Object)("Visiting attribute " + this));
        visitor.visitAttribute(this);
        visitor.completeAttribute(this);
    }

    public SnmpAttributeType getAttributeType() {
        return this.m_type;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public SnmpValue getValue() {
        return this.m_val;
    }

    void store(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    public String toString() {
        return this.getResource() + "." + this.getAttributeType() + " = " + this.getValue();
    }

    public String getType() {
        return this.getAttributeType().getType();
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getName() {
        return this.getAttributeType().getName();
    }

    public String getNumericValue() {
        if (this.getValue() == null) {
            this.log().info((Object)("No data collected for attribute " + this + ". Skipping"));
            return null;
        }
        if (this.getValue().isNumeric()) {
            return Long.toString(this.getValue().toLong());
        }
        try {
            return Double.valueOf(this.getValue().toString()).toString();
        }
        catch (NumberFormatException e) {
            this.log().warn((Object)("Unable to process data received for attribute " + this + " maybe this is not a number? See bug 1473 for more information. Skipping."));
            return null;
        }
    }

    public String getStringValue() {
        SnmpValue value = this.getValue();
        return value == null ? null : value.toString();
    }
}

