/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionAttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.httpdatacollection.Attrib;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.Uri;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCollector
implements ServiceCollector {
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final String DEFAULT_SO_TIMEOUT = "3000";
    private final HashMap<Integer, String> m_scheduledNodes = new HashMap();
    private AttributeGroupType m_groupType = new AttributeGroupType("httpcollection", "all");
    private NumberFormat parser = NumberFormat.getNumberInstance();
    private NumberFormat rrdFormatter = null;

    public HttpCollector() {
        ((DecimalFormat)this.parser).setParseBigDecimal(true);
        this.rrdFormatter = NumberFormat.getNumberInstance();
        this.rrdFormatter.setMinimumFractionDigits(0);
        this.rrdFormatter.setMaximumFractionDigits(Integer.MAX_VALUE);
        this.rrdFormatter.setMinimumIntegerDigits(1);
        this.rrdFormatter.setMaximumIntegerDigits(Integer.MAX_VALUE);
        this.rrdFormatter.setGroupingUsed(false);
    }

    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        HttpCollectionSet collectionSet = new HttpCollectionSet(agent, parameters);
        collectionSet.collect();
        return collectionSet;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void doCollection(HttpCollectionSet collectionSet) throws HttpCollectorException {
        HttpClient client = null;
        HttpMethod method = null;
        try {
            client = new HttpClient(this.buildParams(collectionSet));
            method = this.buildHttpMethod(collectionSet);
            this.buildCredentials(collectionSet, client, method);
            this.log().info((Object)("doCollection: collecting for client: " + client + " using method: " + method));
            client.executeMethod(method);
            this.persistResponse(collectionSet, client, method);
        }
        catch (URIException e) {
            throw new HttpCollectorException("Error building HttpClient URI", client);
        }
        catch (HttpException e) {
            throw new HttpCollectorException("Error building HttpMethod", client);
        }
        catch (IOException e) {
            throw new HttpCollectorException("IO Error retrieving page", client);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private List<HttpCollectionAttribute> processResponse(String responseBodyAsString, HttpCollectionSet collectionSet) {
        this.log().debug((Object)"processResponse: ");
        LinkedList<HttpCollectionAttribute> butes = new LinkedList<HttpCollectionAttribute>();
        Pattern p = Pattern.compile(collectionSet.getUriDef().getUrl().getMatches());
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            this.log().debug((Object)("processResponse: found matching attributes: " + matches));
            List attribDefs = collectionSet.getUriDef().getAttributes().getAttribCollection();
            for (Attrib attribDef : attribDefs) {
                try {
                    Number num = NumberFormat.getNumberInstance().parse(m.group(attribDef.getMatchGroup()));
                    HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionSet.getResource(), new HttpCollectionAttributeType(attribDef, this.m_groupType), attribDef.getAlias(), attribDef.getType(), num);
                    this.log().debug((Object)("processResponse: adding found attribute: " + bute));
                    butes.add(bute);
                }
                catch (ParseException e) {
                    this.log().error((Object)("attribute " + attribDef.getAlias() + " failed to match a parsable number! Matched " + m.group(attribDef.getMatchGroup()) + " instead."));
                }
            }
        } else {
            this.log().debug((Object)("processResponse: found matching attributes: " + matches));
        }
        return butes;
    }

    private void persistResponse(HttpCollectionSet collectionSet, HttpClient client, HttpMethod method) throws IOException {
        List<HttpCollectionAttribute> butes = this.processResponse(method.getResponseBodyAsString(), collectionSet);
        if (butes.isEmpty()) {
            this.log().warn((Object)("doCollection: no attributes defined for collection were found in response text matching regular expression '" + collectionSet.getUriDef().getUrl().getMatches() + "'"));
            throw new HttpCollectorException("No attributes specified were found: ", client);
        }
        collectionSet.storeResults(butes);
        this.log().info((Object)("doCollection: persisting " + butes.size() + " attributes"));
    }

    private void buildCredentials(HttpCollectionSet collectionSet, HttpClient client, HttpMethod method) {
        String userInfo;
        String[] streetCred;
        if (collectionSet.getUriDef().getUrl().getUserInfo() != null && (streetCred = (userInfo = collectionSet.getUriDef().getUrl().getUserInfo()).split(":", 2)).length == 2) {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
            method.setDoAuthentication(true);
        }
    }

    private HttpClientParams buildParams(HttpCollectionSet collectionSet) {
        HttpClientParams params = new HttpClientParams(DefaultHttpParams.getDefaultParams());
        params.setVersion(this.computeVersion(collectionSet.getUriDef()));
        params.setSoTimeout(Integer.parseInt(ParameterMap.getKeyedString(collectionSet.getParameters(), "timeout", DEFAULT_SO_TIMEOUT)));
        params.setVirtualHost(collectionSet.getUriDef().getUrl().getVirtualHost());
        Integer retryCount = ParameterMap.getKeyedInteger(collectionSet.getParameters(), "retries", 2);
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryCount.intValue(), false));
        params.setParameter("http.useragent", (Object)this.determineUserAgent(collectionSet, params));
        return params;
    }

    private String determineUserAgent(HttpCollectionSet collectionSet, HttpClientParams params) {
        String userAgent = collectionSet.getUriDef().getUrl().getUserAgent();
        return userAgent == null ? params.getParameter("http.useragent") : userAgent;
    }

    private HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private HttpMethod buildHttpMethod(HttpCollectionSet collectionSet) throws URIException {
        Object method = "GET".equals(collectionSet.getUriDef().getUrl().getMethod()) ? new GetMethod() : new PostMethod();
        method.setURI(this.buildUri(collectionSet));
        return method;
    }

    private URI buildUri(HttpCollectionSet collectionSet) throws URIException {
        return new URI(collectionSet.getUriDef().getUrl().getScheme(), collectionSet.getUriDef().getUrl().getUserInfo(), this.determineHost(collectionSet.getAgent().getInetAddress(), collectionSet.getUriDef()), collectionSet.getUriDef().getUrl().getPort(), collectionSet.getUriDef().getUrl().getPath(), collectionSet.getUriDef().getUrl().getQuery(), collectionSet.getUriDef().getUrl().getFragment());
    }

    private String determineHost(InetAddress address, Uri uriDef) {
        String host = "${ipaddr}".equals(uriDef.getUrl().getHost()) ? address.getHostName() : uriDef.getUrl().getHost();
        this.log().debug((Object)("determineHost: host for URI is set to: " + host));
        return host;
    }

    @Override
    public void initialize(Map parameters) {
        this.log().debug((Object)"initialize: Initializing HttpCollector.");
        this.m_scheduledNodes.clear();
        this.initHttpCollecionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initHttpCollecionConfig() {
        try {
            this.log().debug((Object)("initialize: Initializing collector: " + this.getClass()));
            HttpCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            this.log().fatal((Object)"initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        this.log().debug((Object)"initializeRrdRepository: Initializing RRD repo from HttpCollector...");
        this.initializeRrdDirs();
        this.initializeRrdInterface();
    }

    private void initializeRrdDirs() {
        File f = new File(HttpCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            StringBuffer sb = new StringBuffer();
            sb.append("initializeRrdDirs: Unable to create RRD file repository.  Path doesn't already exist and could not make directory: ");
            sb.append(HttpCollectionConfigFactory.getInstance().getRrdPath());
            this.log().error((Object)sb.toString());
            throw new RuntimeException(sb.toString());
        }
    }

    private void initializeRrdInterface() {
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            this.log().error((Object)"initializeRrdInterface: Unable to initialize RrdUtils", (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map parameters) {
        this.log().debug((Object)("initialize: Initializing HTTP collection for agent: " + agent));
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        String scheduledAddress = this.m_scheduledNodes.get(scheduledNodeKey);
        if (scheduledAddress != null) {
            this.log().info((Object)("initialize: Not scheduling interface for collection: " + scheduledAddress));
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(this.determineServiceName(parameters));
            sb.append(" for address: ");
            sb.append(scheduledAddress);
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            this.log().debug((Object)sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        this.log().info((Object)("initialize: Scheduling interface for collection: " + scheduledAddress));
        this.m_scheduledNodes.put(scheduledNodeKey, scheduledAddress);
    }

    private String determineServiceName(Map<String, String> parameters) {
        return ParameterMap.getKeyedString(parameters, "service-name", "HTTP");
    }

    @Override
    public void release() {
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    class HttpCollectionAttributeType
    implements CollectionAttributeType {
        Attrib m_attribute;
        AttributeGroupType m_groupType;

        protected HttpCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            this.m_groupType = groupType;
            this.m_attribute = attribute;
        }

        public AttributeGroupType getGroupType() {
            return this.m_groupType;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            if (this.m_attribute.getType().equals("string")) {
                persister.persistStringAttribute(attribute);
            } else {
                persister.persistNumericAttribute(attribute);
            }
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpCollectionResource
    implements CollectionResource {
        CollectionAgent m_agent;
        AttributeGroup m_attribGroup;

        HttpCollectionResource(CollectionAgent agent) {
            this.m_agent = agent;
            this.m_attribGroup = new AttributeGroup(this, HttpCollector.this.m_groupType);
        }

        public void storeResults(List<HttpCollectionAttribute> results) {
            for (HttpCollectionAttribute attrib : results) {
                this.m_attribGroup.addAttribute(attrib);
            }
        }

        @Override
        public boolean rescanNeeded() {
            return false;
        }

        @Override
        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        @Override
        public String getOwnerName() {
            return this.m_agent.getHostAddress();
        }

        @Override
        public File getResourceDir(RrdRepository repository) {
            return new File(repository.getRrdBaseDir(), Integer.toString(this.m_agent.getNodeId()));
        }

        @Override
        public void visit(CollectionSetVisitor visitor) {
            visitor.visitResource(this);
            this.m_attribGroup.visit(visitor);
            visitor.completeResource(this);
        }

        @Override
        public int getType() {
            return -1;
        }

        @Override
        public String getResourceTypeName() {
            return "node";
        }

        @Override
        public String getInstance() {
            return null;
        }
    }

    public class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        HttpClient m_client;

        HttpCollectorException(String message, HttpClient client) {
            super(message);
            this.m_client = client;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            HostConfiguration hostConfiguration = this.m_client.getHostConfiguration();
            buffer.append(hostConfiguration == null ? "null" : hostConfiguration.toString());
            return buffer.toString();
        }
    }

    class HttpCollectionAttribute
    extends AbstractCollectionAttribute
    implements AttributeDefinition {
        String m_alias;
        String m_type;
        Number m_value;
        HttpCollectionResource m_resource;
        HttpCollectionAttributeType m_attribType;

        HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String alias, String type, Number value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        public String getName() {
            return this.m_alias;
        }

        public String getType() {
            return this.m_type;
        }

        public Number getValue() {
            return this.m_value;
        }

        public String getNumericValue() {
            return this.getValue().toString();
        }

        public String getStringValue() {
            return this.getValue().toString();
        }

        public String getValueAsString() {
            return HttpCollector.this.rrdFormatter.format(this.m_value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpCollectionAttribute) {
                HttpCollectionAttribute other = (HttpCollectionAttribute)obj;
                return this.getName().equals(other.getName());
            }
            return false;
        }

        public CollectionAttributeType getAttributeType() {
            return this.m_attribType;
        }

        public CollectionResource getResource() {
            return this.m_resource;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HttpAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValueAsString());
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HttpCollectionSet
    implements CollectionSet {
        private CollectionAgent m_agent;
        private Map<String, String> m_parameters;
        private Uri m_uriDef;
        private int m_status;
        private HttpCollectionResource m_collectionResource;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public void setUriDef(Uri uriDef) {
            this.m_uriDef = uriDef;
        }

        HttpCollectionSet(CollectionAgent agent, Map<String, String> parameters) {
            this.m_agent = agent;
            this.m_parameters = parameters;
            this.m_collectionResource = new HttpCollectionResource(agent);
            this.m_status = 2;
        }

        public void collect() {
            String collectionName = this.m_parameters.get("collection");
            if (collectionName == null) {
                collectionName = this.m_parameters.get("http-collection");
            }
            HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(collectionName);
            List uriDefs = collection.getUris().getUriCollection();
            Iterator i$ = uriDefs.iterator();
            while (i$.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)i$.next();
                try {
                    HttpCollector.this.doCollection(this);
                }
                catch (HttpCollectorException e) {
                    HttpCollector.this.log().error((Object)("collect: http collection failed: " + e), (Throwable)e);
                    this.m_status = 2;
                }
            }
            this.m_status = 1;
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public void setAgent(CollectionAgent agent) {
            this.m_agent = agent;
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.m_parameters = parameters;
        }

        @Override
        public int getStatus() {
            return this.m_status;
        }

        public void storeResults(List<HttpCollectionAttribute> results) {
            this.m_collectionResource.storeResults(results);
        }

        @Override
        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet(this);
            this.m_collectionResource.visit(visitor);
            visitor.completeCollectionSet(this);
        }

        public HttpCollectionResource getResource() {
            return this.m_collectionResource;
        }

        @Override
        public boolean ignorePersist() {
            return false;
        }
    }
}

