/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.config.DataSourceFactory;

public final class DbIpInterfaceEntry {
    public static final char SNMP_PRIMARY = 'P';
    public static final char SNMP_SECONDARY = 'S';
    public static final char SNMP_NOT_ELIGIBLE = 'N';
    public static final char SNMP_UNKNOWN = ' ';
    public static final char STATE_MANAGED = 'M';
    public static final char STATE_UNMANAGED = 'U';
    public static final char STATE_ALIAS = 'A';
    public static final char STATE_DELETED = 'D';
    public static final char STATE_FORCED = 'F';
    public static final char STATE_NOT_POLLED = 'N';
    public static final char STATE_REMOTE = 'X';
    public static final char STATE_UNKNOWN = ' ';
    private static final String SQL_LOAD_REC = "SELECT ifIndex, ipHostname, isManaged, ipStatus, ipLastCapsdPoll, isSnmpPrimary FROM ipInterface WHERE nodeID = ? AND ipAddr = ? AND isManaged != 'D'";
    private static final String SQL_LOAD_IFSVC_LIST = "SELECT serviceID FROM ifServices WHERE nodeID = ? AND ipAddr = ? AND status != 'D'";
    private static final String SQL_LOAD_REC_IFINDEX = "SELECT ifIndex, ipHostname, isManaged, ipStatus, ipLastCapsdPoll, isSnmpPrimary FROM ipInterface WHERE nodeID = ? AND ipAddr = ? AND ifIndex = ? AND isManaged != 'D'";
    private boolean m_fromDb;
    private int m_nodeId;
    private InetAddress m_ipAddr;
    private int m_ifIndex;
    private String m_hostname;
    private int m_status;
    private char m_managedState;
    private Timestamp m_lastPoll;
    private char m_primaryState;
    private int m_changed;
    private static final int CHANGED_IFINDEX = 1;
    private static final int CHANGED_HOSTNAME = 2;
    private static final int CHANGED_MANAGED = 4;
    private static final int CHANGED_STATUS = 8;
    private static final int CHANGED_POLLTIME = 16;
    private static final int CHANGED_PRIMARY = 32;
    private boolean m_useIfIndexAsKey;

    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO ipInterface (nodeID,ipAddr");
        StringBuffer values = new StringBuffer("?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",ifIndex");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",ipHostname");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",isManaged");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",ipStatus");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",ipLastCapsdPoll");
        }
        if ((this.m_changed & 0x20) == 32) {
            values.append(",?");
            names.append(",isSnmpPrimary");
        }
        names.append(") VALUES (").append(values).append(')');
        log.debug((Object)("DbIpInterfaceEntry.insert: SQL insert statment = " + names.toString()));
        PreparedStatement stmt = c.prepareStatement(names.toString());
        names = null;
        int ndx = 1;
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setString(ndx++, this.m_ipAddr.getHostAddress());
        if ((this.m_changed & 1) == 1) {
            stmt.setInt(ndx++, this.m_ifIndex);
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setString(ndx++, this.m_hostname);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setString(ndx++, new String(new char[]{this.m_managedState}));
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setInt(ndx++, this.m_status);
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setTimestamp(ndx++, this.m_lastPoll);
        }
        if ((this.m_changed & 0x20) == 32) {
            stmt.setString(ndx++, new String(new char[]{this.m_primaryState}));
        }
        int rc = stmt.executeUpdate();
        log.debug((Object)("DbIpInterfaceEntry.insert: SQL update result = " + rc));
        stmt.close();
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE ipInterface SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("ifIndex = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("ipHostname = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("isManaged = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("ipStatus = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("ipLastCapsdPoll = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("isSnmpPrimary = ?");
            comma = 44;
        }
        if (this.m_useIfIndexAsKey) {
            sqlText.append(" WHERE nodeID = ? AND ipAddr = ? AND ifIndex = ?");
        } else {
            sqlText.append(" WHERE nodeID = ? AND ipAddr = ?");
        }
        if ((this.m_changed & 0x20) == 32 && this.m_primaryState == 'N') {
            sqlText.append(" AND isSnmpPrimary != 'C'");
        }
        sqlText.append(" AND isManaged <> 'D'");
        log.debug((Object)("DbIpInterfaceEntry.update: SQL update statment = " + sqlText.toString()));
        PreparedStatement stmt = c.prepareStatement(sqlText.toString());
        sqlText = null;
        int ndx = 1;
        if ((this.m_changed & 1) == 1) {
            if (this.m_ifIndex == -1) {
                stmt.setNull(ndx++, 4);
            } else {
                stmt.setInt(ndx++, this.m_ifIndex);
            }
        }
        if ((this.m_changed & 2) == 2) {
            if (this.m_hostname != null) {
                stmt.setString(ndx++, this.m_hostname);
            } else {
                stmt.setNull(ndx++, 12);
            }
        }
        if ((this.m_changed & 4) == 4) {
            if (this.m_managedState == ' ') {
                stmt.setString(ndx++, "N");
            } else {
                stmt.setString(ndx++, new String(new char[]{this.m_managedState}));
            }
        }
        if ((this.m_changed & 8) == 8) {
            if (this.m_status == -1) {
                stmt.setNull(ndx++, 4);
            } else {
                stmt.setInt(ndx++, this.m_status);
            }
        }
        if ((this.m_changed & 0x10) == 16) {
            if (this.m_lastPoll != null) {
                stmt.setTimestamp(ndx++, this.m_lastPoll);
            } else {
                stmt.setNull(ndx++, 93);
            }
        }
        if ((this.m_changed & 0x20) == 32) {
            if (this.m_primaryState == ' ') {
                stmt.setNull(ndx++, 1);
            } else {
                stmt.setString(ndx++, new String(new char[]{this.m_primaryState}));
            }
        }
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setString(ndx++, this.m_ipAddr.getHostAddress());
        if (this.m_useIfIndexAsKey) {
            if (this.m_ifIndex == -1) {
                stmt.setNull(ndx++, 4);
            } else {
                stmt.setInt(ndx++, this.m_ifIndex);
            }
        }
        int rc = stmt.executeUpdate();
        log.debug((Object)("DbIpInterfaceEntry.update: update result = " + rc));
        stmt.close();
        this.m_changed = 0;
    }

    private boolean load(Connection c) throws SQLException {
        String str;
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        if (this.m_useIfIndexAsKey) {
            stmt = c.prepareStatement(SQL_LOAD_REC_IFINDEX);
            stmt.setInt(1, this.m_nodeId);
            stmt.setString(2, this.m_ipAddr.getHostAddress());
            stmt.setInt(3, this.m_ifIndex);
        } else {
            stmt = c.prepareStatement(SQL_LOAD_REC);
            stmt.setInt(1, this.m_nodeId);
            stmt.setString(2, this.m_ipAddr.getHostAddress());
        }
        ResultSet rset = stmt.executeQuery();
        if (!rset.next()) {
            rset.close();
            stmt.close();
            return false;
        }
        int ndx = 1;
        this.m_ifIndex = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_ifIndex = -1;
        }
        this.m_hostname = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_hostname = null;
        }
        this.m_managedState = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        this.m_status = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_status = -1;
        }
        this.m_lastPoll = rset.getTimestamp(ndx++);
        this.m_primaryState = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        rset.close();
        stmt.close();
        this.m_changed = 0;
        return true;
    }

    private DbIpInterfaceEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    private DbIpInterfaceEntry(int nid, InetAddress address, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nid;
        this.m_ipAddr = address;
        this.m_ifIndex = -1;
        this.m_managedState = (char)32;
        this.m_status = -1;
        this.m_lastPoll = null;
        this.m_primaryState = (char)32;
        this.m_changed = 0;
        this.m_useIfIndexAsKey = false;
    }

    private DbIpInterfaceEntry(int nid, InetAddress address, int ifIndex, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nid;
        this.m_ipAddr = address;
        this.m_ifIndex = ifIndex;
        this.m_status = -1;
        this.m_lastPoll = null;
        this.m_managedState = (char)32;
        this.m_primaryState = (char)32;
        this.m_changed = 0;
        this.m_useIfIndexAsKey = true;
    }

    int getNodeId() {
        return this.m_nodeId;
    }

    InetAddress getIfAddress() {
        return this.m_ipAddr;
    }

    String getLastPollString() {
        String result = null;
        if (this.m_lastPoll != null) {
            result = this.m_lastPoll.toString();
        }
        return result;
    }

    Timestamp getLastPoll() {
        return this.m_lastPoll;
    }

    void setLastPoll(String time) throws ParseException {
        if (time == null) {
            this.m_lastPoll = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_lastPoll = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x10;
    }

    void setLastPoll(Date time) {
        this.m_lastPoll = new Timestamp(time.getTime());
        this.m_changed |= 0x10;
    }

    void setLastPoll(Timestamp time) {
        this.m_lastPoll = time;
        this.m_changed |= 0x10;
    }

    boolean hasIfIndex() {
        return this.m_ifIndex != -1;
    }

    int getIfIndex() {
        return this.m_ifIndex;
    }

    void setIfIndex(int ndx) {
        this.m_ifIndex = ndx;
        this.m_changed |= 1;
    }

    boolean hasIfIndexChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateIfIndex(int newIfIndex) {
        if (newIfIndex != -1 && newIfIndex != this.m_ifIndex) {
            this.setIfIndex(newIfIndex);
            return true;
        }
        return false;
    }

    String getHostname() {
        return this.m_hostname;
    }

    void setHostname(String name) {
        this.m_hostname = name;
        this.m_changed |= 2;
    }

    boolean hasHostnameChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateHostname(String newHostname) {
        boolean doUpdate = false;
        if (newHostname != null && this.m_hostname != null) {
            if (!newHostname.equals(this.m_hostname)) {
                doUpdate = true;
            }
        } else if (newHostname != null || this.m_hostname != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setHostname(newHostname);
            return true;
        }
        return false;
    }

    char getManagedState() {
        return this.m_managedState;
    }

    void setManagedState(char state) {
        this.m_managedState = state;
        this.m_changed |= 4;
    }

    boolean hasManagedStateChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateManagedState(char newManagedState) {
        if (newManagedState != this.m_managedState) {
            this.setManagedState(newManagedState);
            return true;
        }
        return false;
    }

    int getStatus() {
        return this.m_status;
    }

    void setStatus(int status) {
        this.m_status = status;
        this.m_changed |= 8;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStatus(int newStatus) {
        if (newStatus != -1 && newStatus != this.m_status) {
            this.setStatus(newStatus);
            return true;
        }
        return false;
    }

    char getPrimaryState() {
        return this.m_primaryState;
    }

    void setPrimaryState(char state) {
        this.m_primaryState = state;
        this.m_changed |= 0x20;
    }

    boolean hasPrimaryStateChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updatePrimaryState(char newPrimaryState) {
        if (newPrimaryState != ' ' && newPrimaryState != this.m_primaryState) {
            this.setPrimaryState(newPrimaryState);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbIfServiceEntry[] getServices() throws SQLException {
        DbIfServiceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getServices(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    DbIfServiceEntry[] getServices(Connection db) throws SQLException {
        PreparedStatement stmt = db.prepareStatement(SQL_LOAD_IFSVC_LIST);
        stmt.setInt(1, this.m_nodeId);
        stmt.setString(2, this.m_ipAddr.getHostAddress());
        ResultSet rset = stmt.executeQuery();
        ArrayList<DbIfServiceEntry> l = new ArrayList<DbIfServiceEntry>();
        while (rset.next()) {
            int sid = rset.getInt(1);
            DbIfServiceEntry entry = DbIfServiceEntry.get(db, this.m_nodeId, this.m_ipAddr, sid);
            if (entry == null) continue;
            l.add(entry);
        }
        rset.close();
        stmt.close();
        DbIfServiceEntry[] entries = new DbIfServiceEntry[l.size()];
        return l.toArray(entries);
    }

    static DbIpInterfaceEntry create(int nid, InetAddress address) {
        return new DbIpInterfaceEntry(nid, address, false);
    }

    static DbIpInterfaceEntry create(int nid, InetAddress address, int ifIndex) {
        return new DbIpInterfaceEntry(nid, address, ifIndex, false);
    }

    static DbIpInterfaceEntry clone(DbIpInterfaceEntry entry) {
        DbIpInterfaceEntry clonedEntry = DbIpInterfaceEntry.create(entry.getNodeId(), entry.getIfAddress());
        clonedEntry.m_fromDb = entry.m_fromDb;
        clonedEntry.m_ifIndex = entry.m_ifIndex;
        clonedEntry.m_managedState = entry.m_managedState;
        clonedEntry.m_status = entry.m_status;
        clonedEntry.m_lastPoll = entry.m_lastPoll;
        clonedEntry.m_primaryState = entry.m_primaryState;
        clonedEntry.m_changed = entry.m_changed;
        return clonedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbIpInterfaceEntry get(int nid, InetAddress addr) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbIpInterfaceEntry dbIpInterfaceEntry = DbIpInterfaceEntry.get(db, nid, addr);
            return dbIpInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbIpInterfaceEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbIpInterfaceEntry get(int nid, InetAddress addr, int ifIndex) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbIpInterfaceEntry dbIpInterfaceEntry = DbIpInterfaceEntry.get(db, nid, addr, ifIndex);
            return dbIpInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbIpInterfaceEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    static DbIpInterfaceEntry get(Connection db, int nid, InetAddress addr) throws SQLException {
        DbIpInterfaceEntry entry = new DbIpInterfaceEntry(nid, addr, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    static DbIpInterfaceEntry get(Connection db, int nid, InetAddress addr, int ifIndex) throws SQLException {
        DbIpInterfaceEntry entry = new DbIpInterfaceEntry(nid, addr, ifIndex, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from database      = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier    = ").append(this.m_nodeId).append(sep);
        buf.append("IP Address         = ").append(this.m_ipAddr.getHostAddress()).append(sep);
        buf.append("interface index    = ").append(this.m_ifIndex).append(sep);
        buf.append("last poll time     = ").append(this.m_lastPoll).append(sep);
        buf.append("hostname           = ").append(this.m_hostname).append(sep);
        buf.append("status             = ").append(this.m_status).append(sep);
        buf.append("isManaged          = ").append(this.m_managedState).append(sep);
        buf.append("isSnmpPrimary      = ").append(this.m_primaryState).append(sep);
        buf.append("field change map   = 0x").append(Integer.toHexString(this.m_changed)).append(sep);
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            DbIpInterfaceEntry entry = DbIpInterfaceEntry.get(Integer.parseInt(args[0]), InetAddress.getByName(args[1]));
            System.out.println(entry.toString());
            DbIfServiceEntry[] services = entry.getServices();
            for (int i = 0; i < services.length; ++i) {
                System.out.println(services[i].toString());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

