/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.LValueI;
import org.nfunk.jep.function.PostfixMathCommand;

public class Assign
extends PostfixMathCommand
implements CallbackEvaluationI {
    public Assign() {
        this.numberOfParameters = 2;
    }

    public Object evaluate(Node node, EvaluatorI evaluatorI) throws ParseException {
        if (node.jjtGetNumChildren() != 2) {
            throw new ParseException("Assignment operator must have 2 operators.");
        }
        Object object = evaluatorI.eval(node.jjtGetChild(1));
        Node node2 = node.jjtGetChild(0);
        if (node2 instanceof ASTVarNode) {
            ASTVarNode aSTVarNode = (ASTVarNode)node2;
            Variable variable = aSTVarNode.getVar();
            variable.setValue(object);
            return object;
        }
        if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).getPFMC() instanceof LValueI) {
            ((LValueI)((Object)((ASTFunNode)node2).getPFMC())).set(evaluatorI, node2, object);
            return object;
        }
        throw new ParseException("Assignment should have a variable or LValue for the lhs.");
    }
}

