/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.Queue;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifdConfiguration
implements Serializable {
    private String _status;
    private String _pagesSent;
    private String _nextNotifId;
    private String _nextUserNotifId;
    private String _nextGroupId;
    private String _outstandingNoticesSql;
    private String _acknowledgeIdSql;
    private String _acknowledgeUpdateSql;
    private boolean _matchAll;
    private boolean _has_matchAll;
    private String _emailAddressCommand = "javaEmail";
    private List<AutoAcknowledge> _autoAcknowledgeList;
    private List<Queue> _queueList;
    private List<String> _outageCalendarList;

    public NotifdConfiguration() {
        this.setEmailAddressCommand("javaEmail");
        this._autoAcknowledgeList = new ArrayList<AutoAcknowledge>();
        this._queueList = new ArrayList<Queue>();
        this._outageCalendarList = new ArrayList<String>();
    }

    public void addAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(vAutoAcknowledge);
    }

    public void addAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(index, vAutoAcknowledge);
    }

    public void addOutageCalendar(String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(vOutageCalendar);
    }

    public void addOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(index, vOutageCalendar);
    }

    public void addQueue(Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(vQueue);
    }

    public void addQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(index, vQueue);
    }

    public void deleteMatchAll() {
        this._has_matchAll = false;
    }

    public Enumeration<AutoAcknowledge> enumerateAutoAcknowledge() {
        return Collections.enumeration(this._autoAcknowledgeList);
    }

    public Enumeration<String> enumerateOutageCalendar() {
        return Collections.enumeration(this._outageCalendarList);
    }

    public Enumeration<Queue> enumerateQueue() {
        return Collections.enumeration(this._queueList);
    }

    public String getAcknowledgeIdSql() {
        return this._acknowledgeIdSql;
    }

    public String getAcknowledgeUpdateSql() {
        return this._acknowledgeUpdateSql;
    }

    public AutoAcknowledge getAutoAcknowledge(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("getAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this._autoAcknowledgeList.size() - 1) + "]");
        }
        return this._autoAcknowledgeList.get(index);
    }

    public AutoAcknowledge[] getAutoAcknowledge() {
        AutoAcknowledge[] array = new AutoAcknowledge[]{};
        return this._autoAcknowledgeList.toArray(array);
    }

    public List<AutoAcknowledge> getAutoAcknowledgeCollection() {
        return this._autoAcknowledgeList;
    }

    public int getAutoAcknowledgeCount() {
        return this._autoAcknowledgeList.size();
    }

    public String getEmailAddressCommand() {
        return this._emailAddressCommand;
    }

    public boolean getMatchAll() {
        return this._matchAll;
    }

    public String getNextGroupId() {
        return this._nextGroupId;
    }

    public String getNextNotifId() {
        return this._nextNotifId;
    }

    public String getNextUserNotifId() {
        return this._nextUserNotifId;
    }

    public String getOutageCalendar(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("getOutageCalendar: Index value '" + index + "' not in range [0.." + (this._outageCalendarList.size() - 1) + "]");
        }
        return this._outageCalendarList.get(index);
    }

    public String[] getOutageCalendar() {
        String[] array = new String[]{};
        return this._outageCalendarList.toArray(array);
    }

    public List<String> getOutageCalendarCollection() {
        return this._outageCalendarList;
    }

    public int getOutageCalendarCount() {
        return this._outageCalendarList.size();
    }

    public String getOutstandingNoticesSql() {
        return this._outstandingNoticesSql;
    }

    public String getPagesSent() {
        return this._pagesSent;
    }

    public Queue getQueue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._queueList.size()) {
            throw new IndexOutOfBoundsException("getQueue: Index value '" + index + "' not in range [0.." + (this._queueList.size() - 1) + "]");
        }
        return this._queueList.get(index);
    }

    public Queue[] getQueue() {
        Queue[] array = new Queue[]{};
        return this._queueList.toArray(array);
    }

    public List<Queue> getQueueCollection() {
        return this._queueList;
    }

    public int getQueueCount() {
        return this._queueList.size();
    }

    public String getStatus() {
        return this._status;
    }

    public boolean hasMatchAll() {
        return this._has_matchAll;
    }

    public boolean isMatchAll() {
        return this._matchAll;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<AutoAcknowledge> iterateAutoAcknowledge() {
        return this._autoAcknowledgeList.iterator();
    }

    public Iterator<String> iterateOutageCalendar() {
        return this._outageCalendarList.iterator();
    }

    public Iterator<Queue> iterateQueue() {
        return this._queueList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllAutoAcknowledge() {
        this._autoAcknowledgeList.clear();
    }

    public void removeAllOutageCalendar() {
        this._outageCalendarList.clear();
    }

    public void removeAllQueue() {
        this._queueList.clear();
    }

    public boolean removeAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) {
        boolean removed = this._autoAcknowledgeList.remove(vAutoAcknowledge);
        return removed;
    }

    public AutoAcknowledge removeAutoAcknowledgeAt(int index) {
        AutoAcknowledge obj = this._autoAcknowledgeList.remove(index);
        return obj;
    }

    public boolean removeOutageCalendar(String vOutageCalendar) {
        boolean removed = this._outageCalendarList.remove(vOutageCalendar);
        return removed;
    }

    public String removeOutageCalendarAt(int index) {
        String obj = this._outageCalendarList.remove(index);
        return obj;
    }

    public boolean removeQueue(Queue vQueue) {
        boolean removed = this._queueList.remove(vQueue);
        return removed;
    }

    public Queue removeQueueAt(int index) {
        Queue obj = this._queueList.remove(index);
        return obj;
    }

    public void setAcknowledgeIdSql(String acknowledgeIdSql) {
        this._acknowledgeIdSql = acknowledgeIdSql;
    }

    public void setAcknowledgeUpdateSql(String acknowledgeUpdateSql) {
        this._acknowledgeUpdateSql = acknowledgeUpdateSql;
    }

    public void setAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("setAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this._autoAcknowledgeList.size() - 1) + "]");
        }
        this._autoAcknowledgeList.set(index, vAutoAcknowledge);
    }

    public void setAutoAcknowledge(AutoAcknowledge[] vAutoAcknowledgeArray) {
        this._autoAcknowledgeList.clear();
        for (int i = 0; i < vAutoAcknowledgeArray.length; ++i) {
            this._autoAcknowledgeList.add(vAutoAcknowledgeArray[i]);
        }
    }

    public void setAutoAcknowledge(List<AutoAcknowledge> vAutoAcknowledgeList) {
        this._autoAcknowledgeList.clear();
        this._autoAcknowledgeList.addAll(vAutoAcknowledgeList);
    }

    public void setAutoAcknowledgeCollection(List<AutoAcknowledge> autoAcknowledgeList) {
        this._autoAcknowledgeList = autoAcknowledgeList;
    }

    public void setEmailAddressCommand(String emailAddressCommand) {
        this._emailAddressCommand = emailAddressCommand;
    }

    public void setMatchAll(boolean matchAll) {
        this._matchAll = matchAll;
        this._has_matchAll = true;
    }

    public void setNextGroupId(String nextGroupId) {
        this._nextGroupId = nextGroupId;
    }

    public void setNextNotifId(String nextNotifId) {
        this._nextNotifId = nextNotifId;
    }

    public void setNextUserNotifId(String nextUserNotifId) {
        this._nextUserNotifId = nextUserNotifId;
    }

    public void setOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("setOutageCalendar: Index value '" + index + "' not in range [0.." + (this._outageCalendarList.size() - 1) + "]");
        }
        this._outageCalendarList.set(index, vOutageCalendar);
    }

    public void setOutageCalendar(String[] vOutageCalendarArray) {
        this._outageCalendarList.clear();
        for (int i = 0; i < vOutageCalendarArray.length; ++i) {
            this._outageCalendarList.add(vOutageCalendarArray[i]);
        }
    }

    public void setOutageCalendar(List<String> vOutageCalendarList) {
        this._outageCalendarList.clear();
        this._outageCalendarList.addAll(vOutageCalendarList);
    }

    public void setOutageCalendarCollection(List<String> outageCalendarList) {
        this._outageCalendarList = outageCalendarList;
    }

    public void setOutstandingNoticesSql(String outstandingNoticesSql) {
        this._outstandingNoticesSql = outstandingNoticesSql;
    }

    public void setPagesSent(String pagesSent) {
        this._pagesSent = pagesSent;
    }

    public void setQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._queueList.size()) {
            throw new IndexOutOfBoundsException("setQueue: Index value '" + index + "' not in range [0.." + (this._queueList.size() - 1) + "]");
        }
        this._queueList.set(index, vQueue);
    }

    public void setQueue(Queue[] vQueueArray) {
        this._queueList.clear();
        for (int i = 0; i < vQueueArray.length; ++i) {
            this._queueList.add(vQueueArray[i]);
        }
    }

    public void setQueue(List<Queue> vQueueList) {
        this._queueList.clear();
        this._queueList.addAll(vQueueList);
    }

    public void setQueueCollection(List<Queue> queueList) {
        this._queueList = queueList;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public static NotifdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (NotifdConfiguration)Unmarshaller.unmarshal(NotifdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

