/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class Snmp4jLogMib
implements MOGroup,
MOServerLookupListener,
MOTableRowListener,
RowStatusListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger((Class)Snmp4jLogMib.class);
    private static final MOTableRowFilter NOT_ACTIVE_ROW_FILTER = new MOTableRowFilter(){

        public boolean passesFilter(MOTableRow row) {
            Snmp4jLogLoggerRow r;
            return row instanceof Snmp4jLogLoggerRow && (r = (Snmp4jLogLoggerRow)row).getSnmp4jLogLoggerRowStatus().getValue() == 1;
        }
    };
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    private static final OID oidSnmp4jLogSysDescr = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 1, 1, 0});
    private static final OID oidSnmp4jLogFactory = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 1, 2, 0});
    private static final OID oidSnmp4jLogRootLevel = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 1, 0});
    private MOScalar snmp4jLogSysDescr;
    private MOScalar snmp4jLogFactory;
    private MOScalar snmp4jLogRootLevel;
    private static final OID oidSnmp4jLogLoggerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 2, 1});
    private static final int colSnmp4jLogLoggerIndex = 2;
    private static final int colSnmp4jLogLoggerLevel = 3;
    private static final int colSnmp4jLogLoggerEffectiveLevel = 4;
    private static final int colSnmp4jLogLoggerStorageType = 5;
    private static final int colSnmp4jLogLoggerRowStatus = 6;
    private static final int idxSnmp4jLogLoggerIndex = 0;
    private static final int idxSnmp4jLogLoggerLevel = 1;
    private static final int idxSnmp4jLogLoggerEffectiveLevel = 2;
    private static final int idxSnmp4jLogLoggerStorageType = 3;
    private static final int idxSnmp4jLogLoggerRowStatus = 4;
    private static MOTableSubIndex[] snmp4jLogLoggerEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(4, 0, 127)};
    private static MOTableIndex snmp4jLogLoggerEntryIndex = moFactory.createIndex(snmp4jLogLoggerEntryIndexes, true, new MOTableIndexValidator(){

        public boolean isValidIndex(OID index) {
            boolean isValidIndex = true;
            return isValidIndex;
        }
    });
    private MOTable snmp4jLogLoggerEntry;
    private MOMutableTableModel snmp4jLogLoggerEntryModel;
    private static final OID oidSnmp4jLogLoggerToHandlerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 3, 1});
    private static final int colSnmp4jLogLoggerToHandlerThreshold = 1;
    private static final int colSnmp4jLogLoggerToHandlerStorageType = 2;
    private static final int colSnmp4jLogLoggerToHandlerRowStatus = 3;
    private static final int idxSnmp4jLogLoggerToHandlerThreshold = 0;
    private static final int idxSnmp4jLogLoggerToHandlerStorageType = 1;
    private static final int idxSnmp4jLogLoggerToHandlerRowStatus = 2;
    private static MOTableSubIndex[] snmp4jLogLoggerToHandlerEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(2, 1, 1), moFactory.createSubIndex(4, 0, 255)};
    private static MOTableIndex snmp4jLogLoggerToHandlerEntryIndex = moFactory.createIndex(snmp4jLogLoggerToHandlerEntryIndexes, false);
    private MOTable snmp4jLogLoggerToHandlerEntry;
    private MOMutableTableModel snmp4jLogLoggerToHandlerEntryModel;
    private static final OID oidSnmp4jLogHandlerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 5, 2, 1});
    private static final int colSnmp4jLogHandlerType = 2;
    private static final int colSnmp4jLogHandlerStorageType = 3;
    private static final int colSnmp4jLogHandlerRowStatus = 4;
    private static final int idxSnmp4jLogHandlerType = 0;
    private static final int idxSnmp4jLogHandlerStorageType = 1;
    private static final int idxSnmp4jLogHandlerRowStatus = 2;
    private static MOTableSubIndex[] snmp4jLogHandlerEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(4, 0, 255)};
    private static MOTableIndex snmp4jLogHandlerEntryIndex = moFactory.createIndex(snmp4jLogHandlerEntryIndexes, false);
    private MOTable snmp4jLogHandlerEntry;
    private MOMutableTableModel snmp4jLogHandlerEntryModel;
    private static final OID oidSnmp4jLogFileHandlerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 5, 3, 1, 1});
    private static final int colSnmp4jLogFileHandlerPath = 1;
    private static final int colSnmp4jLogFileHandlerAppend = 2;
    private static final int colSnmp4jLogFileHandlerBufferedIO = 3;
    private static final int colSnmp4jLogFileHandlerBufferSize = 4;
    private static final int idxSnmp4jLogFileHandlerPath = 0;
    private static final int idxSnmp4jLogFileHandlerAppend = 1;
    private static final int idxSnmp4jLogFileHandlerBufferedIO = 2;
    private static final int idxSnmp4jLogFileHandlerBufferSize = 3;
    private static MOTableSubIndex[] snmp4jLogFileHandlerEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(4, 0, 255)};
    private static MOTableIndex snmp4jLogFileHandlerEntryIndex = moFactory.createIndex(snmp4jLogFileHandlerEntryIndexes, false);
    private MOTable snmp4jLogFileHandlerEntry;
    private MOMutableTableModel snmp4jLogFileHandlerEntryModel;
    private static final OID oidSnmp4jLogConsoleHandlerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 2, 5, 3, 2, 1});
    private static final int colSnmp4jLogConsoleHandlerTarget = 1;
    private static final int idxSnmp4jLogConsoleHandlerTarget = 0;
    private static MOTableSubIndex[] snmp4jLogConsoleHandlerEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(4, 0, 127)};
    private static MOTableIndex snmp4jLogConsoleHandlerEntryIndex = moFactory.createIndex(snmp4jLogConsoleHandlerEntryIndexes, false);
    private MOTable snmp4jLogConsoleHandlerEntry;
    private MOMutableTableModel snmp4jLogConsoleHandlerEntryModel;
    private Map loggers = new HashMap();
    private Map loggerNames2Index = new WeakHashMap();
    private int nextLoggerIndex = 1;
    private Object lastLoggerUpdateSource;

    public Snmp4jLogMib() {
        this.snmp4jLogSysDescr = moFactory.createScalar(oidSnmp4jLogSysDescr, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new OctetString());
        this.snmp4jLogFactory = moFactory.createScalar(oidSnmp4jLogFactory, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new OctetString());
        this.snmp4jLogRootLevel = new Snmp4jLogRootLevel(oidSnmp4jLogRootLevel, MOAccessImpl.ACCESS_READ_WRITE);
        this.snmp4jLogRootLevel.addMOValueValidationListener(new Snmp4jLogLevelValidator());
        this.createSnmp4jLogLoggerEntry();
        this.createSnmp4jLogLoggerToHandlerEntry();
        this.createSnmp4jLogHandlerEntry();
        this.createSnmp4jLogFileHandlerEntry();
        this.createSnmp4jLogConsoleHandlerEntry();
    }

    public MOTable getSnmp4jLogLoggerEntry() {
        return this.snmp4jLogLoggerEntry;
    }

    private void createSnmp4jLogLoggerEntry() {
        MOColumn[] snmp4jLogLoggerEntryColumns = new MOColumn[5];
        snmp4jLogLoggerEntryColumns[0] = new MOColumn(2, 2, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jLogLoggerEntryColumns[1] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(1), true);
        ((MOMutableColumn)snmp4jLogLoggerEntryColumns[1]).addMOValueValidationListener(new Snmp4jLogLevelValidator());
        snmp4jLogLoggerEntryColumns[2] = new MOColumn(4, 2, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jLogLoggerEntryColumns[3] = new StorageType(5, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(2), true);
        snmp4jLogLoggerEntryColumns[4] = new RowStatus(6);
        this.snmp4jLogLoggerEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jLogLoggerEntryModel.setRowFactory(new Snmp4jLogLoggerEntryRowFactory());
        this.snmp4jLogLoggerEntry = moFactory.createTable(oidSnmp4jLogLoggerEntry, snmp4jLogLoggerEntryIndex, snmp4jLogLoggerEntryColumns, this.snmp4jLogLoggerEntryModel);
        ((RowStatus)snmp4jLogLoggerEntryColumns[4]).addRowStatusListener(this);
        this.snmp4jLogLoggerEntry.addMOTableRowListener(this);
    }

    public MOTable getSnmp4jLogLoggerToHandlerEntry() {
        return this.snmp4jLogLoggerToHandlerEntry;
    }

    private void createSnmp4jLogLoggerToHandlerEntry() {
        MOColumn[] snmp4jLogLoggerToHandlerEntryColumns = new MOColumn[3];
        snmp4jLogLoggerToHandlerEntryColumns[0] = new MOMutableColumn(1, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(2), true);
        ((MOMutableColumn)snmp4jLogLoggerToHandlerEntryColumns[0]).addMOValueValidationListener(new Snmp4jLogLevelValidator());
        snmp4jLogLoggerToHandlerEntryColumns[1] = new StorageType(2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(2), true);
        snmp4jLogLoggerToHandlerEntryColumns[2] = new RowStatus(3);
        this.snmp4jLogLoggerToHandlerEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jLogLoggerToHandlerEntryModel.setRowFactory(new Snmp4jLogLoggerToHandlerEntryRowFactory());
        this.snmp4jLogLoggerToHandlerEntry = moFactory.createTable(oidSnmp4jLogLoggerToHandlerEntry, snmp4jLogLoggerToHandlerEntryIndex, snmp4jLogLoggerToHandlerEntryColumns, this.snmp4jLogLoggerToHandlerEntryModel);
    }

    public MOTable getSnmp4jLogHandlerEntry() {
        return this.snmp4jLogHandlerEntry;
    }

    private void createSnmp4jLogHandlerEntry() {
        MOColumn[] snmp4jLogHandlerEntryColumns = new MOColumn[3];
        snmp4jLogHandlerEntryColumns[0] = new MOMutableColumn(2, 6, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OID("1.3.6.1.4.1.4976.10.1.1.1.1.2.5.1.2.1"), true);
        ((MOMutableColumn)snmp4jLogHandlerEntryColumns[0]).addMOValueValidationListener(new Snmp4jLogHandlerTypeValidator());
        snmp4jLogHandlerEntryColumns[1] = new StorageType(3, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        snmp4jLogHandlerEntryColumns[2] = new RowStatus(4);
        this.snmp4jLogHandlerEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jLogHandlerEntryModel.setRowFactory(new Snmp4jLogHandlerEntryRowFactory());
        this.snmp4jLogHandlerEntry = moFactory.createTable(oidSnmp4jLogHandlerEntry, snmp4jLogHandlerEntryIndex, snmp4jLogHandlerEntryColumns, this.snmp4jLogHandlerEntryModel);
    }

    public MOTable getSnmp4jLogFileHandlerEntry() {
        return this.snmp4jLogFileHandlerEntry;
    }

    private void createSnmp4jLogFileHandlerEntry() {
        MOColumn[] snmp4jLogFileHandlerEntryColumns = new MOColumn[4];
        snmp4jLogFileHandlerEntryColumns[0] = new MOMutableColumn(1, 4, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(new byte[]{115, 110, 109, 112, 52, 106, 46, 108, 111, 103}), true);
        ((MOMutableColumn)snmp4jLogFileHandlerEntryColumns[0]).addMOValueValidationListener(new Snmp4jLogFileHandlerPathValidator());
        snmp4jLogFileHandlerEntryColumns[1] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(1), true);
        ((MOMutableColumn)snmp4jLogFileHandlerEntryColumns[1]).addMOValueValidationListener(new Snmp4jLogFileHandlerAppendValidator());
        snmp4jLogFileHandlerEntryColumns[2] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(1), true);
        ((MOMutableColumn)snmp4jLogFileHandlerEntryColumns[2]).addMOValueValidationListener(new Snmp4jLogFileHandlerBufferedIOValidator());
        snmp4jLogFileHandlerEntryColumns[3] = new MOMutableColumn(4, 66, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new UnsignedInteger32(16535), true);
        ((MOMutableColumn)snmp4jLogFileHandlerEntryColumns[3]).addMOValueValidationListener(new Snmp4jLogFileHandlerBufferSizeValidator());
        this.snmp4jLogFileHandlerEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jLogFileHandlerEntryModel.setRowFactory(new Snmp4jLogFileHandlerEntryRowFactory());
        this.snmp4jLogFileHandlerEntry = moFactory.createTable(oidSnmp4jLogFileHandlerEntry, snmp4jLogFileHandlerEntryIndex, snmp4jLogFileHandlerEntryColumns, this.snmp4jLogFileHandlerEntryModel);
    }

    public MOTable getSnmp4jLogConsoleHandlerEntry() {
        return this.snmp4jLogConsoleHandlerEntry;
    }

    private void createSnmp4jLogConsoleHandlerEntry() {
        MOColumn[] snmp4jLogConsoleHandlerEntryColumns = new MOColumn[]{new Enumerated(1, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2})};
        ((MOMutableColumn)snmp4jLogConsoleHandlerEntryColumns[0]).addMOValueValidationListener(new Snmp4jLogConsoleHandlerTargetValidator());
        this.snmp4jLogConsoleHandlerEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jLogConsoleHandlerEntryModel.setRowFactory(new Snmp4jLogConsoleHandlerEntryRowFactory());
        this.snmp4jLogConsoleHandlerEntry = moFactory.createTable(oidSnmp4jLogConsoleHandlerEntry, snmp4jLogConsoleHandlerEntryIndex, snmp4jLogConsoleHandlerEntryColumns, this.snmp4jLogConsoleHandlerEntryModel);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmp4jLogSysDescr, context);
        server.register(this.snmp4jLogFactory, context);
        server.register(this.snmp4jLogRootLevel, context);
        server.register(this.snmp4jLogLoggerEntry, context);
        server.addLookupListener(this, this.snmp4jLogSysDescr);
        server.addLookupListener(this, this.snmp4jLogLoggerEntry);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmp4jLogSysDescr, context);
        server.unregister(this.snmp4jLogFactory, context);
        server.unregister(this.snmp4jLogRootLevel, context);
        server.unregister(this.snmp4jLogLoggerEntry, context);
        server.unregister(this.snmp4jLogLoggerToHandlerEntry, context);
        server.unregister(this.snmp4jLogHandlerEntry, context);
        server.unregister(this.snmp4jLogFileHandlerEntry, context);
        server.unregister(this.snmp4jLogConsoleHandlerEntry, context);
        server.removeLookupListener(this, this.snmp4jLogSysDescr);
        server.removeLookupListener(this, this.snmp4jLogLoggerEntry);
    }

    private OctetString getLogSysDescr() {
        LogFactory logFactory = LogFactory.getLogFactory();
        if (logFactory == null) {
            return new OctetString();
        }
        return new OctetString(logFactory.toString());
    }

    private OctetString getLogFactory() {
        LogFactory logFactory = LogFactory.getLogFactory();
        if (logFactory == null) {
            return new OctetString();
        }
        return new OctetString(logFactory.getClass().getName());
    }

    public void lookupEvent(MOServerLookupEvent event) {
        if (event.getLookupResult() == this.snmp4jLogSysDescr) {
            this.snmp4jLogSysDescr.setValue((Variable)this.getLogSysDescr());
        }
        if (event.getLookupResult() == this.snmp4jLogFactory) {
            this.snmp4jLogFactory.setValue((Variable)this.getLogFactory());
        }
    }

    public void queryEvent(MOServerLookupEvent event) {
        if (event.getLookupResult() == this.snmp4jLogLoggerEntry && !DefaultMOQuery.isSameSource(event.getQuery(), this.lastLoggerUpdateSource)) {
            this.lastLoggerUpdateSource = event.getSource();
            this.updateLoggerTable();
        }
    }

    private static OID getLoggerIndex(LogAdapter logger) {
        return new OctetString(logger.getName()).toSubIndex(true);
    }

    private Snmp4jLogLoggerRow createLoggerRow(int n, LogAdapter logger, int storageType) {
        OID index = Snmp4jLogMib.getLoggerIndex(logger);
        Variable[] row = new Variable[5];
        int i = 0;
        row[i++] = new Integer32(n);
        row[i++] = new Integer32(logger.getLogLevel().getLevel());
        row[i++] = new Integer32(logger.getEffectiveLogLevel().getLevel());
        row[i++] = new Integer32(storageType);
        row[i++] = new Integer32(1);
        return new Snmp4jLogLoggerRow(index, row, n, logger);
    }

    private int getStorageType(LogAdapter logger) {
        Snmp4jLogLoggerRow row = (Snmp4jLogLoggerRow)this.snmp4jLogLoggerEntryModel.getRow(Snmp4jLogMib.getLoggerIndex(logger));
        if (row != null) {
            return row.getSnmp4jLogLoggerStorageType().getValue();
        }
        return 2;
    }

    public void updateLoggerTable() {
        this.snmp4jLogLoggerEntryModel.clear(NOT_ACTIVE_ROW_FILTER);
        if (LogFactory.getLogFactory() == null) {
            return;
        }
        Iterator loggers = LogFactory.getLogFactory().loggers();
        this.loggers = new HashMap();
        LogAdapter rootLogger = LogFactory.getLogFactory().getRootLogger();
        this.snmp4jLogLoggerEntryModel.addRow(this.createLoggerRow(1, rootLogger, this.getStorageType(rootLogger)));
        while (loggers.hasNext()) {
            LogAdapter l = (LogAdapter)loggers.next();
            int i = 1;
            Integer index = (Integer)this.loggerNames2Index.get(l.getName());
            if (index == null) {
                i = this.nextLoggerIndex++;
                this.loggerNames2Index.put(l.getName(), new Integer(i));
            } else {
                i = index;
            }
            this.loggers.put(new Integer(i + 1), l);
            this.snmp4jLogLoggerEntryModel.addRow(this.createLoggerRow(i + 1, l, this.getStorageType(l)));
        }
    }

    public void rowStatusChanged(RowStatusEvent event) {
        if (event.getTable().equals(this.snmp4jLogLoggerEntry) && (event.getNewStatus() == 1 || event.getNewStatus() == 4)) {
            Snmp4jLogLoggerRow r = (Snmp4jLogLoggerRow)event.getRow();
            OctetString loggerName = new OctetString(r.getIndex().toByteArray());
            LogAdapter logAdapter = LogFactory.getLogger((String)loggerName.toString());
            r.setLogAdapter(logAdapter);
            logAdapter.setLogLevel(new LogLevel(r.getSnmp4jLogLoggerLevel().getValue()));
        }
    }

    public void rowChanged(MOTableRowEvent event) {
        if (event.getTable().equals(this.snmp4jLogLoggerEntry)) {
            switch (event.getType()) {
                case 4: {
                    Snmp4jLogLoggerRow r = (Snmp4jLogLoggerRow)event.getRow();
                    if (r.getLogAdapter() == null) break;
                    r.getLogAdapter().setLogLevel(new LogLevel(r.getSnmp4jLogLoggerLevel().getValue()));
                    break;
                }
                case 2: {
                    Snmp4jLogLoggerRow r = (Snmp4jLogLoggerRow)event.getRow();
                    OctetString loggerName = new OctetString(r.getIndex().toByteArray());
                    LogAdapter logAdapter = LogFactory.getLogger((String)loggerName.toString());
                    r.setLogAdapter(logAdapter);
                    int level = r.getSnmp4jLogLoggerLevel().getValue();
                    logAdapter.setLogLevel(new LogLevel(level));
                    break;
                }
            }
        }
    }

    public class Snmp4jLogLoggerRow
    extends Snmp4jLogLoggerEntryRow {
        private LogAdapter logger;
        private int n;

        protected Snmp4jLogLoggerRow(OID index, Variable[] values, int n, LogAdapter logger) {
            super(index, values);
            this.n = n;
            this.logger = logger;
        }

        public void setLogAdapter(LogAdapter logAdapter) {
            this.logger = logAdapter;
        }

        public LogAdapter getLogAdapter() {
            return this.logger;
        }
    }

    class Snmp4jLogConsoleHandlerEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jLogConsoleHandlerEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Integer32 getSnmp4jLogConsoleHandlerTarget() {
            return (Integer32)this.getValue(0);
        }

        public void setSnmp4jLogConsoleHandlerTarget(Integer32 newValue) {
            this.setValue(0, (Variable)newValue);
        }
    }

    class Snmp4jLogConsoleHandlerEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jLogConsoleHandlerEntryRow row = new Snmp4jLogConsoleHandlerEntryRow(index, values);
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    class Snmp4jLogFileHandlerEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jLogFileHandlerEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmp4jLogFileHandlerPath() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmp4jLogFileHandlerPath(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogFileHandlerAppend() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmp4jLogFileHandlerAppend(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogFileHandlerBufferedIO() {
            return (Integer32)this.getValue(2);
        }

        public void setSnmp4jLogFileHandlerBufferedIO(Integer32 newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public UnsignedInteger32 getSnmp4jLogFileHandlerBufferSize() {
            return (UnsignedInteger32)this.getValue(3);
        }

        public void setSnmp4jLogFileHandlerBufferSize(UnsignedInteger32 newValue) {
            this.setValue(3, (Variable)newValue);
        }
    }

    class Snmp4jLogFileHandlerEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        Snmp4jLogFileHandlerEntryRowFactory() {
        }

        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jLogFileHandlerEntryRow row = new Snmp4jLogFileHandlerEntryRow(index, values);
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    class Snmp4jLogHandlerEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jLogHandlerEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OID getSnmp4jLogHandlerType() {
            return (OID)this.getValue(0);
        }

        public void setSnmp4jLogHandlerType(OID newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogHandlerStorageType() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmp4jLogHandlerStorageType(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogHandlerRowStatus() {
            return (Integer32)this.getValue(2);
        }

        public void setSnmp4jLogHandlerRowStatus(Integer32 newValue) {
            this.setValue(2, (Variable)newValue);
        }
    }

    class Snmp4jLogHandlerEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        Snmp4jLogHandlerEntryRowFactory() {
        }

        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jLogHandlerEntryRow row = new Snmp4jLogHandlerEntryRow(index, values);
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    class Snmp4jLogLoggerToHandlerEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jLogLoggerToHandlerEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Integer32 getSnmp4jLogLoggerToHandlerThreshold() {
            return (Integer32)this.getValue(0);
        }

        public void setSnmp4jLogLoggerToHandlerThreshold(Integer32 newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerToHandlerStorageType() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmp4jLogLoggerToHandlerStorageType(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerToHandlerRowStatus() {
            return (Integer32)this.getValue(2);
        }

        public void setSnmp4jLogLoggerToHandlerRowStatus(Integer32 newValue) {
            this.setValue(2, (Variable)newValue);
        }
    }

    class Snmp4jLogLoggerToHandlerEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        Snmp4jLogLoggerToHandlerEntryRowFactory() {
        }

        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jLogLoggerToHandlerEntryRow row = new Snmp4jLogLoggerToHandlerEntryRow(index, values);
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    class Snmp4jLogLoggerEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jLogLoggerEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Integer32 getSnmp4jLogLoggerIndex() {
            return (Integer32)this.getValue(0);
        }

        public void setSnmp4jLogLoggerIndex(Integer32 newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerLevel() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmp4jLogLoggerLevel(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerEffectiveLevel() {
            return (Integer32)this.getValue(2);
        }

        public void setSnmp4jLogLoggerEffectiveLevel(Integer32 newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerStorageType() {
            return (Integer32)this.getValue(3);
        }

        public void setSnmp4jLogLoggerStorageType(Integer32 newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public Integer32 getSnmp4jLogLoggerRowStatus() {
            return (Integer32)this.getValue(4);
        }

        public void setSnmp4jLogLoggerRowStatus(Integer32 newValue) {
            this.setValue(4, (Variable)newValue);
        }
    }

    class Snmp4jLogLoggerEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            int i = Snmp4jLogMib.this.nextLoggerIndex++;
            Snmp4jLogLoggerRow row = new Snmp4jLogLoggerRow(index, values, i, null);
            row.setSnmp4jLogLoggerIndex(new Integer32(i));
            Snmp4jLogMib.this.loggerNames2Index.put(new OctetString(index.toByteArray()).toString(), new Integer(i));
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    public static final class Snmp4jLogConsoleHandlerTargetEnum {
        public static final int systemOut = 1;
        public static final int systemErr = 2;
    }

    public static final class Snmp4jLogFileHandlerBufferedIOEnum {
        public static final int _true = 1;
        public static final int _false = 2;
    }

    public static final class Snmp4jLogFileHandlerAppendEnum {
        public static final int _true = 1;
        public static final int _false = 2;
    }

    public static final class Snmp4jLogLoggerToHandlerThresholdEnum {
        public static final int notSpecified = 0;
        public static final int off = 1;
        public static final int all = 2;
        public static final int trace = 3;
        public static final int debug = 4;
        public static final int info = 5;
        public static final int warn = 6;
        public static final int error = 7;
        public static final int fatal = 8;
    }

    static class Snmp4jLogConsoleHandlerTargetValidator
    implements MOValueValidationListener {
        Snmp4jLogConsoleHandlerTargetValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jLogFileHandlerBufferSizeValidator
    implements MOValueValidationListener {
        Snmp4jLogFileHandlerBufferSizeValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jLogFileHandlerBufferedIOValidator
    implements MOValueValidationListener {
        Snmp4jLogFileHandlerBufferedIOValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jLogFileHandlerAppendValidator
    implements MOValueValidationListener {
        Snmp4jLogFileHandlerAppendValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jLogFileHandlerPathValidator
    implements MOValueValidationListener {
        Snmp4jLogFileHandlerPathValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 1 || os.length() > 512) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class Snmp4jLogHandlerTypeValidator
    implements MOValueValidationListener {
        Snmp4jLogHandlerTypeValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jLogLevelValidator
    implements MOValueValidationListener {
        Snmp4jLogLevelValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            int v = ((Integer32)newValue).getValue();
            if (v < 1 || v > 8) {
                validationEvent.setValidationStatus(10);
            }
        }
    }

    class Snmp4jLogRootLevel
    extends MOScalar {
        Snmp4jLogRootLevel(OID oid, MOAccess access) {
            super(oid, access, (Variable)new Integer32());
        }

        public void commit(SubRequest request) {
            Variable vb = request.getVariableBinding().getVariable();
            int v = ((Integer32)vb).getValue();
            LogAdapter logAdapter = LogFactory.getLogFactory().getRootLogger();
            logAdapter.setLogLevel(new LogLevel(v));
            super.commit(request);
        }

        public void load(MOInput input) throws IOException {
            super.load(input);
            int v = ((Integer32)this.getValue()).getValue();
            LogAdapter logAdapter = LogFactory.getLogFactory().getRootLogger();
            if (v != 0) {
                logAdapter.setLogLevel(new LogLevel(v));
            }
        }
    }
}

