/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.DisplayString;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class Snmp4jConfigMib
implements MOGroup {
    private static final LogAdapter logger = LogFactory.getLogger((Class)Snmp4jConfigMib.class);
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    private static final OID oidSnmp4jCfgSecSrcAddrValidation = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 2, 1, 1, 1, 0});
    private MOScalar snmp4jCfgSecSrcAddrValidation;
    private static final OID oidSnmp4jCfgStorageEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 2, 1, 2, 1, 1});
    private static final int colSnmp4jCfgStoragePath = 2;
    private static final int colSnmp4jCfgStorageFormat = 3;
    private static final int colSnmp4jCfgStorageLastStore = 4;
    private static final int colSnmp4jCfgStorageLastRestore = 5;
    private static final int colSnmp4jCfgStorageRestoreMode = 6;
    private static final int colSnmp4jCfgStorageOperation = 7;
    private static final int colSnmp4jCfgStorageStorageType = 8;
    private static final int colSnmp4jCfgStorageStatus = 9;
    private static final int idxSnmp4jCfgStoragePath = 0;
    private static final int idxSnmp4jCfgStorageFormat = 1;
    private static final int idxSnmp4jCfgStorageLastStore = 2;
    private static final int idxSnmp4jCfgStorageLastRestore = 3;
    private static final int idxSnmp4jCfgStorageRestoreMode = 4;
    private static final int idxSnmp4jCfgStorageOperation = 5;
    private static final int idxSnmp4jCfgStorageStorageType = 6;
    private static final int idxSnmp4jCfgStorageStatus = 7;
    private static MOTableSubIndex[] snmp4jCfgStorageEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(4, 0, 255)};
    private static MOTableIndex snmp4jCfgStorageEntryIndex = moFactory.createIndex(snmp4jCfgStorageEntryIndexes, false);
    private MOTable snmp4jCfgStorageEntry;
    private MOMutableTableModel snmp4jCfgStorageEntryModel;
    public static final OID PRIMARY_INDEX = new OctetString("primary").toSubIndex(false);
    protected SnmpCommunityMIB snmpCommunityMIB;
    protected MOPersistenceProvider[] persistenceProvider = new MOPersistenceProvider[2];
    protected File defaultConfigFile;
    protected SysUpTime sysUpTime;
    private File configPathRoot;

    public Snmp4jConfigMib(SysUpTime sysUpTime) {
        this.sysUpTime = sysUpTime;
        this.snmp4jCfgSecSrcAddrValidation = new Snmp4jCfgSecSrcAddrValidation(oidSnmp4jCfgSecSrcAddrValidation, MOAccessImpl.ACCESS_READ_WRITE);
        this.createSnmp4jCfgStorageEntry();
        this.configPathRoot = new File(System.getProperty("user.dir", ""));
    }

    public MOTable getSnmp4jCfgStorageEntry() {
        return this.snmp4jCfgStorageEntry;
    }

    public File getDefaultConfigFile() {
        return this.defaultConfigFile;
    }

    private void createSnmp4jCfgStorageEntry() {
        MOColumn[] snmp4jCfgStorageEntryColumns = new MOColumn[8];
        snmp4jCfgStorageEntryColumns[0] = new DisplayString(2, MOAccessImpl.ACCESS_READ_CREATE, null, true, 0, 255);
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[0]).addMOValueValidationListener(new Snmp4jCfgStoragePathValidator());
        snmp4jCfgStorageEntryColumns[1] = new Enumerated(3, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2});
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[1]).addMOValueValidationListener(new Snmp4jCfgStorageFormatValidator());
        snmp4jCfgStorageEntryColumns[2] = new MOColumn(4, 67, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jCfgStorageEntryColumns[3] = new MOColumn(5, 67, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jCfgStorageEntryColumns[4] = new Enumerated(6, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2, 3, 4});
        snmp4jCfgStorageEntryColumns[5] = new Enumerated(7, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2, 3, 4});
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[5]).addMOValueValidationListener(new Snmp4jCfgStorageOperationValidator());
        snmp4jCfgStorageEntryColumns[6] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmp4jCfgStorageEntryColumns[7] = new RowStatus(9);
        this.snmp4jCfgStorageEntryModel = new DefaultMOMutableTableModel();
        this.snmp4jCfgStorageEntryModel.setRowFactory(new Snmp4jCfgStorageEntryRowFactory());
        this.snmp4jCfgStorageEntry = moFactory.createTable(oidSnmp4jCfgStorageEntry, snmp4jCfgStorageEntryIndex, snmp4jCfgStorageEntryColumns, this.snmp4jCfgStorageEntryModel);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmp4jCfgSecSrcAddrValidation, context);
        server.register(this.snmp4jCfgStorageEntry, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmp4jCfgSecSrcAddrValidation, context);
        server.unregister(this.snmp4jCfgStorageEntry, context);
    }

    public void setSnmpCommunityMIB(SnmpCommunityMIB snmpCommunityMIB) {
        this.snmpCommunityMIB = snmpCommunityMIB;
    }

    public void setDefaultConfigFile(File defaultConfigFile) {
        this.defaultConfigFile = defaultConfigFile;
        Snmp4jCfgStorageEntryRow primary = (Snmp4jCfgStorageEntryRow)this.snmp4jCfgStorageEntryModel.getRow(PRIMARY_INDEX);
        if (primary == null) {
            Variable[] vbs = this.snmp4jCfgStorageEntry.getDefaultValues();
            vbs[7] = new Integer32(1);
            primary = (Snmp4jCfgStorageEntryRow)this.snmp4jCfgStorageEntry.createRow(PRIMARY_INDEX, vbs);
            primary.setSnmp4jCfgStorageStorageType(new Integer32(4));
            primary.setSnmp4jCfgStorageOperation(new Integer32(1));
            this.snmp4jCfgStorageEntry.addRow(primary);
        }
        primary.setSnmp4jCfgStoragePath(new OctetString(defaultConfigFile.getPath()));
    }

    public void setPersistenceProvider(int format, MOPersistenceProvider provider) {
        this.persistenceProvider[format - 1] = provider;
    }

    public MOPersistenceProvider getPersistenceProvider(int format) {
        return this.persistenceProvider[format - 1];
    }

    public SnmpCommunityMIB getCoexistenceInfoProvider() {
        return this.snmpCommunityMIB;
    }

    private class Operation
    extends Thread {
        private Snmp4jCfgStorageEntryRow row;
        private int operation;
        private int restoreType;
        private MOPersistenceProvider provider;

        public Operation(Snmp4jCfgStorageEntryRow row, MOPersistenceProvider provider, int restoreType, int operation) {
            this.operation = operation;
            this.provider = provider;
            this.restoreType = restoreType;
            this.row = row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            switch (this.operation) {
                case 3: {
                    File f = new File(this.row.getValue(0).toString());
                    FileOutputStream fos = null;
                    fos = new FileOutputStream(f);
                    this.provider.saveConfig(fos);
                    fos.close();
                    this.row.setValue(2, (Variable)Snmp4jConfigMib.this.sysUpTime.get());
                    this.row.setValue(5, (Variable)new Integer32(1));
                    if (fos == null) break;
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        logger.warn((Object)ex);
                    }
                    break;
                    catch (Exception iox) {
                        try {
                            logger.warn((Object)("Failed to store config to '" + f + "': " + iox.getMessage()));
                            this.row.setValue(5, (Variable)new Integer32(1));
                            if (fos == null) break;
                        }
                        catch (Throwable throwable) {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException ex) {
                                    logger.warn((Object)ex);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            logger.warn((Object)ex);
                        }
                        break;
                    }
                }
                case 4: {
                    File f = new File(this.row.getValue(0).toString());
                    if (f.exists() && f.canRead()) {
                        FileInputStream fis = null;
                        fis = new FileInputStream(f);
                        this.provider.loadConfig(fis, this.restoreType);
                        fis.close();
                        this.row.setValue(3, (Variable)Snmp4jConfigMib.this.sysUpTime.get());
                        this.row.setValue(5, (Variable)new Integer32(1));
                        if (fis == null) break;
                        try {
                            fis.close();
                        }
                        catch (IOException ex) {
                            logger.warn((Object)ex);
                        }
                        break;
                        catch (Exception iox) {
                            try {
                                logger.warn((Object)("Failed to restore config from '" + f + "': " + iox.getMessage()));
                                this.row.setValue(5, (Variable)new Integer32(1));
                                if (fis == null) break;
                            }
                            catch (Throwable throwable) {
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (IOException ex) {
                                        logger.warn((Object)ex);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                fis.close();
                            }
                            catch (IOException ex) {
                                logger.warn((Object)ex);
                            }
                            break;
                        }
                    }
                    logger.warn((Object)("File '" + f + "' does not exists or is not readable"));
                    this.row.setValue(5, (Variable)new Integer32(1));
                    break;
                }
            }
        }
    }

    class Snmp4jCfgStorageEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jCfgStorageEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmp4jCfgStoragePath() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmp4jCfgStoragePath(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageFormat() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmp4jCfgStorageFormat(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public TimeTicks getSnmp4jCfgStorageLastStore() {
            return (TimeTicks)this.getValue(2);
        }

        public void setSnmp4jCfgStorageLastStore(TimeTicks newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public TimeTicks getSnmp4jCfgStorageLastRestore() {
            return (TimeTicks)this.getValue(3);
        }

        public void setSnmp4jCfgStorageLastRestore(TimeTicks newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageRestoreMode() {
            return (Integer32)this.getValue(4);
        }

        public void setSnmp4jCfgStorageRestoreMode(Integer32 newValue) {
            this.setValue(4, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageOperation() {
            return (Integer32)this.getValue(5);
        }

        public void setSnmp4jCfgStorageOperation(Integer32 newValue) {
            this.setValue(5, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageStorageType() {
            return (Integer32)this.getValue(6);
        }

        public void setSnmp4jCfgStorageStorageType(Integer32 newValue) {
            this.setValue(6, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageStatus() {
            return (Integer32)this.getValue(7);
        }

        public void setSnmp4jCfgStorageStatus(Integer32 newValue) {
            this.setValue(7, (Variable)newValue);
        }

        public void prepareRow(SubRequest subRequest, MOTableRow changeSet) {
            if (PRIMARY_INDEX.equals((Object)changeSet.getIndex()) && Snmp4jConfigMib.this.snmp4jCfgStorageEntryModel.getRow(PRIMARY_INDEX) == null) {
                subRequest.getRequest().setErrorStatus(11);
            }
        }

        public void commitRow(SubRequest subRequest, MOTableRow changeSet) {
            Integer32 operation = this.getSnmp4jCfgStorageOperation();
            Integer32 format = this.getSnmp4jCfgStorageFormat();
            if (format.getValue() == 1) {
                MOPersistenceProvider provider = Snmp4jConfigMib.this.getPersistenceProvider(format.getValue());
                if (provider == null) {
                    subRequest.getRequest().setErrorStatus(14);
                } else {
                    Operation op = new Operation(this, provider, this.getSnmp4jCfgStorageRestoreMode().getValue(), operation.getValue());
                    this.setValue(5, (Variable)new Integer32(2));
                    op.start();
                }
            } else {
                subRequest.getRequest().setErrorStatus(14);
            }
        }
    }

    class Snmp4jCfgStorageEntryRowFactory
    extends DefaultMOMutableRow2PCFactory {
        public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jCfgStorageEntryRow row = new Snmp4jCfgStorageEntryRow(index, values);
            ((Integer32)values[5]).setValue(1);
            return row;
        }

        public void freeRow(MOTableRow row) {
        }
    }

    public static final class Snmp4jCfgStorageOperationEnum {
        public static final int idle = 1;
        public static final int inProgress = 2;
        public static final int store = 3;
        public static final int restore = 4;
    }

    public static final class Snmp4jCfgStorageRestoreModeEnum {
        public static final int replaceAndCreate = 1;
        public static final int updateAndCreate = 2;
        public static final int updateOnly = 3;
        public static final int createOnly = 4;
    }

    public static final class Snmp4jCfgStorageFormatEnum {
        public static final int binary = 1;
        public static final int xml = 2;
    }

    public static final class Snmp4jCfgSecSrcAddrValidationEnum {
        public static final int enabled = 1;
        public static final int disabled = 2;
        public static final int notAvailable = 3;
    }

    static class Snmp4jCfgStorageOperationValidator
    implements MOValueValidationListener {
        Snmp4jCfgStorageOperationValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            switch (newValue.toInt()) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    validationEvent.setValidationStatus(10);
                }
            }
        }
    }

    static class Snmp4jCfgStorageFormatValidator
    implements MOValueValidationListener {
        Snmp4jCfgStorageFormatValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            if (((Integer32)newValue).getValue() != 1) {
                validationEvent.setValidationStatus(10);
            }
        }
    }

    static class Snmp4jCfgStoragePathValidator
    implements MOValueValidationListener {
        Snmp4jCfgStoragePathValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public class Snmp4jCfgSecSrcAddrValidation
    extends EnumeratedScalar {
        Snmp4jCfgSecSrcAddrValidation(OID oid, MOAccess access) {
            super(oid, access, new Integer32(), new int[]{1, 2, 3});
        }

        public Variable getValue() {
            if (Snmp4jConfigMib.this.snmpCommunityMIB != null) {
                if (Snmp4jConfigMib.this.snmpCommunityMIB.isSourceAddressFiltering()) {
                    this.setValue((Variable)new Integer32(1));
                } else {
                    this.setValue((Variable)new Integer32(2));
                }
            } else {
                this.setValue((Variable)new Integer32(3));
            }
            return (Variable)super.getValue().clone();
        }

        public void commit(SubRequest request) {
            Integer32 newValue = (Integer32)request.getVariableBinding().getVariable();
            switch (newValue.getValue()) {
                case 2: {
                    Snmp4jConfigMib.this.snmpCommunityMIB.setSourceAddressFiltering(false);
                    break;
                }
                case 1: {
                    Snmp4jConfigMib.this.snmpCommunityMIB.setSourceAddressFiltering(true);
                    break;
                }
                default: {
                    request.getRequest().setErrorStatus(14);
                }
            }
            super.commit(request);
        }

        public void cleanup(SubRequest request) {
            super.cleanup(request);
        }

        public int isValueOK(SubRequest request) {
            block5: {
                Variable newValue;
                block4: {
                    newValue = request.getVariableBinding().getVariable();
                    if (Snmp4jConfigMib.this.snmpCommunityMIB == null) break block4;
                    switch (((Integer32)newValue).getValue()) {
                        case 1: 
                        case 2: {
                            break block5;
                        }
                        default: {
                            return 10;
                        }
                    }
                }
                if (((Integer32)newValue).getValue() != 3) {
                    return 12;
                }
                return 10;
            }
            return super.isValueOK(request);
        }
    }
}

