/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java.generics;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeFactory;
import org.hibernate.reflection.java.generics.TypeSwitch;

class SimpleTypeEnvironment
implements TypeEnvironment {
    final Type[] formalArguments;
    final Type[] actualArguments;
    private final TypeSwitch<Type> substitute = new TypeSwitch<Type>(){

        @Override
        public Type caseClass(Class classType) {
            return classType;
        }

        @Override
        public Type caseGenericArrayType(GenericArrayType genericArrayType) {
            Type boundComponentType;
            Type originalComponentType = genericArrayType.getGenericComponentType();
            if (originalComponentType == (boundComponentType = SimpleTypeEnvironment.this.bind(originalComponentType))) {
                return genericArrayType;
            }
            return TypeFactory.createArrayType(boundComponentType);
        }

        @Override
        public Type caseParameterizedType(ParameterizedType parameterizedType) {
            Object[] boundArguments;
            Object[] originalArguments = parameterizedType.getActualTypeArguments();
            if (this.areSame(originalArguments, boundArguments = SimpleTypeEnvironment.this.substitute((Type[])originalArguments))) {
                return parameterizedType;
            }
            return TypeFactory.createParameterizedType(parameterizedType.getRawType(), (Type[])boundArguments, parameterizedType.getOwnerType());
        }

        private boolean areSame(Object[] array1, Object[] array2) {
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Type caseTypeVariable(TypeVariable typeVariable) {
            int idx = this.indexOf(SimpleTypeEnvironment.this.formalArguments, typeVariable);
            return idx >= 0 ? SimpleTypeEnvironment.this.actualArguments[idx] : typeVariable;
        }

        private int indexOf(Object[] array, Object o) {
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Type caseWildcardType(WildcardType wildcardType) {
            return wildcardType;
        }
    };

    public SimpleTypeEnvironment(Type[] formal, Type[] actual) {
        this.actualArguments = actual;
        this.formalArguments = formal;
    }

    public Type bind(Type type) {
        return this.substitute.doSwitch(type);
    }

    private Type[] substitute(Type[] types) {
        Type[] substTypes = new Type[types.length];
        for (int i = 0; i < substTypes.length; ++i) {
            substTypes[i] = this.bind(types[i]);
        }
        return substTypes;
    }
}

