/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

public final class ConfigFileConstants {
    private static final String[] FILE_ID_TO_NAME;
    public static final int DB_CONFIG_FILE_NAME;
    public static final int JMS_CONFIG_FILE_NAME;
    public static final int ACTIOND_CONFIG_FILE_NAME;
    public static final int CAPSD_CONFIG_FILE_NAME;
    public static final int DISCOVERY_CONFIG_FILE_NAME;
    public static final int EVENTD_CONFIG_FILE_NAME;
    public static final int REPORT_HTML_XSL;
    public static final int DHCPD_CONFIG_FILE_NAME;
    public static final int NOTIFD_CONFIG_FILE_NAME;
    public static final int OUTAGE_MANAGER_CONFIG_FILE_NAME;
    public static final int POLLER_CONFIG_FILE_NAME;
    public static final int POLL_OUTAGES_CONFIG_FILE_NAME;
    public static final int RTC_CONFIG_FILE_NAME;
    public static final int TRAPD_CONFIG_FILE_NAME;
    public static final int MANAGER_CONFIG_FILE_NAME;
    public static final int SERVICE_CONF_FILE_NAME;
    public static final int EVENTS_ARCHIVER_CONFIG_FILE_NAME;
    public static final int COLLECTD_CONFIG_FILE_NAME;
    public static final int THRESHD_CONFIG_FILE_NAME;
    public static final int VULNSCAND_CONFIG_FILE_NAME;
    public static final int SCRIPTD_CONFIG_FILE_NAME;
    public static final int VACUUMD_CONFIG_FILE_NAME;
    public static final int XMLRPCD_CONFIG_FILE_NAME;
    public static final int RRD_CONFIG_FILE_NAME;
    public static final int JAVA_MAIL_CONFIG_FILE_NAME;
    public static final int XMPP_CONFIG_FILE_NAME;
    public static final int CHART_CONFIG_FILE_NAME;
    public static final int TRANSLATOR_CONFIG_FILE_NAME;
    public static final int JMX_DATA_COLLECTION_CONF_FILE_NAME;
    public static final int SYSLOGD_CONFIG_FILE_NAME;
    public static final int ADMIN_PITXML_FILE_NAME;
    public static final int MAGIC_USERS_CONF_FILE_NAME;
    public static final int POLLER_CONF_FILE_NAME;
    public static final int EXCLUDE_UEI_FILE_NAME;
    public static final int USERS_CONF_FILE_NAME;
    public static final int VIEWS_CONF_FILE_NAME;
    public static final int CATEGORIES_CONF_FILE_NAME;
    public static final int GROUPS_CONF_FILE_NAME;
    public static final int VIEWS_DISPLAY_CONF_FILE_NAME;
    public static final int NOTIFICATIONS_CONF_FILE_NAME;
    public static final int NOTIF_COMMANDS_CONF_FILE_NAME;
    public static final int DESTINATION_PATHS_CONF_FILE_NAME;
    public static final int SNMP_CONF_FILE_NAME;
    public static final int EVENT_CONF_FILE_NAME;
    public static final int DB_SCHEMA_FILE_NAME;
    public static final int DATA_COLLECTION_CONF_FILE_NAME;
    public static final int BASE_CONFIGURATION_FILE_NAME;
    public static final int THRESHOLDING_CONF_FILE_NAME;
    public static final int WEBUI_COLORS_FILE_NAME;
    public static final int KSC_REPORT_FILE_NAME;
    public static final int OPENNMS_SERVER_CONFIG_FILE_NAME;
    public static final int SURVEILLANCE_VIEWS_FILE_NAME;
    public static final int SITE_STATUS_VIEWS_FILE_NAME;
    public static final int MONITORING_LOCATIONS_FILE_NAME;
    public static final int HTTP_COLLECTION_CONFIG_FILE_NAME;
    public static final int REPORT_PDF_XSL;
    public static final int REPORT_SVG_XSL;
    public static final int EVENT_REPORT;
    public static final int OUTAGE_REPORT;
    public static final int NOTIFY_REPORT;
    public static final int LINKD_CONFIG_FILE_NAME;
    public static final int OPENNMS_DATASOURCE_CONFIG_FILE_NAME;
    public static final int MAP_PROPERTIES_FILE_NAME;
    public static final int EVENT_REPORT_DTD;
    public static final int OUTAGE_REPORT_DTD;
    public static final int NOTIFY_REPORT_DTD;
    public static final int NSCLIENT_COLLECTION_CONFIG_FILE_NAME;
    public static final int NSCLIENT_CONFIG_FILE_NAME;

    public static final String getFileName(int id) {
        return FILE_ID_TO_NAME[id];
    }

    public static final File getFile(int id) throws IOException {
        File frfileNoEtc;
        String home = ConfigFileConstants.getHome();
        File fhome = new File(home);
        if (!fhome.exists()) {
            ConfigFileConstants.log().warn((Object)"getFile: The specified home directory does not exist");
            throw new FileNotFoundException("The OpenNMS home directory \"" + home + "\" does not exist");
        }
        String rfile = ConfigFileConstants.getFileName(id);
        File frfile = new File(home + File.separator + "etc" + File.separator + rfile);
        if (!frfile.exists() && !(frfileNoEtc = new File(home + File.separator + rfile)).exists()) {
            throw new FileNotFoundException("The requested file '" + rfile + "' could not be found at '" + frfile.getAbsolutePath() + "' or '" + frfileNoEtc.getAbsolutePath() + "'");
        }
        return frfile;
    }

    private static Category log() {
        return ThreadCategory.getInstance(ConfigFileConstants.class);
    }

    public static final File getConfigFileByName(String fname) throws IOException {
        File frfileNoEtc;
        String home = ConfigFileConstants.getHome();
        File fhome = new File(home);
        if (!fhome.exists()) {
            ConfigFileConstants.log().warn((Object)"getConfigFileByName: The specified home directory does not exist");
            throw new FileNotFoundException("The OpenNMS home directory \"" + home + "\" does not exist");
        }
        File frfile = new File(home + File.separator + "etc" + File.separator + fname);
        if (!frfile.exists() && !(frfileNoEtc = new File(home + File.separator + fname)).exists()) {
            throw new FileNotFoundException("The requested file '" + fname + "' could not be found at '" + frfile.getAbsolutePath() + "' or '" + frfileNoEtc.getAbsolutePath() + "'");
        }
        return frfile;
    }

    public static final String getHome() {
        String home = System.getProperty("opennms.home");
        if (home == null) {
            ConfigFileConstants.log().warn((Object)"getConfigFileByName: The \"opennms.home\" property was not set, falling back to /opt/opennms");
            home = File.separator + "opt" + File.separator + "opennms";
        }
        if (home.endsWith("/") || home.endsWith(File.separator)) {
            home = home.substring(0, home.length() - 1);
        }
        return home;
    }

    public static final String getIncludeFileString() {
        return "file:" + ConfigFileConstants.getHome() + File.separator + "etc" + File.separator + "include";
    }

    public static final String getFilePathString() {
        return ConfigFileConstants.getHome() + File.separator + "etc" + File.separator;
    }

    public static final String getTimezoneFileDir() {
        return File.separator + "usr" + File.separator + "share" + File.separator + "zoneinfo" + File.separator + "US";
    }

    static {
        DB_CONFIG_FILE_NAME = 0;
        JMS_CONFIG_FILE_NAME = 1;
        ACTIOND_CONFIG_FILE_NAME = 2;
        CAPSD_CONFIG_FILE_NAME = 3;
        DISCOVERY_CONFIG_FILE_NAME = 4;
        EVENTD_CONFIG_FILE_NAME = 5;
        NOTIFD_CONFIG_FILE_NAME = 6;
        OUTAGE_MANAGER_CONFIG_FILE_NAME = 7;
        POLLER_CONFIG_FILE_NAME = 8;
        POLL_OUTAGES_CONFIG_FILE_NAME = 9;
        RTC_CONFIG_FILE_NAME = 10;
        TRAPD_CONFIG_FILE_NAME = 11;
        MANAGER_CONFIG_FILE_NAME = 12;
        SERVICE_CONF_FILE_NAME = 13;
        EVENTS_ARCHIVER_CONFIG_FILE_NAME = 14;
        ADMIN_PITXML_FILE_NAME = 15;
        MAGIC_USERS_CONF_FILE_NAME = 16;
        POLLER_CONF_FILE_NAME = 17;
        EXCLUDE_UEI_FILE_NAME = 18;
        USERS_CONF_FILE_NAME = 19;
        VIEWS_CONF_FILE_NAME = 20;
        CATEGORIES_CONF_FILE_NAME = 21;
        GROUPS_CONF_FILE_NAME = 22;
        NOTIFICATIONS_CONF_FILE_NAME = 23;
        NOTIF_COMMANDS_CONF_FILE_NAME = 24;
        DESTINATION_PATHS_CONF_FILE_NAME = 25;
        SNMP_CONF_FILE_NAME = 26;
        EVENT_CONF_FILE_NAME = 27;
        DB_SCHEMA_FILE_NAME = 28;
        DATA_COLLECTION_CONF_FILE_NAME = 29;
        REPORT_PDF_XSL = 30;
        REPORT_SVG_XSL = 31;
        EVENT_REPORT = 32;
        OUTAGE_REPORT = 33;
        EVENT_REPORT_DTD = 34;
        OUTAGE_REPORT_DTD = 35;
        NOTIFY_REPORT_DTD = 36;
        NOTIFY_REPORT = 37;
        COLLECTD_CONFIG_FILE_NAME = 38;
        BASE_CONFIGURATION_FILE_NAME = 39;
        VULNSCAND_CONFIG_FILE_NAME = 40;
        THRESHD_CONFIG_FILE_NAME = 41;
        THRESHOLDING_CONF_FILE_NAME = 42;
        VIEWS_DISPLAY_CONF_FILE_NAME = 43;
        REPORT_HTML_XSL = 44;
        WEBUI_COLORS_FILE_NAME = 45;
        KSC_REPORT_FILE_NAME = 46;
        SCRIPTD_CONFIG_FILE_NAME = 47;
        OPENNMS_SERVER_CONFIG_FILE_NAME = 48;
        XMLRPCD_CONFIG_FILE_NAME = 49;
        DHCPD_CONFIG_FILE_NAME = 50;
        RRD_CONFIG_FILE_NAME = 51;
        JAVA_MAIL_CONFIG_FILE_NAME = 52;
        VACUUMD_CONFIG_FILE_NAME = 53;
        XMPP_CONFIG_FILE_NAME = 54;
        CHART_CONFIG_FILE_NAME = 55;
        JMX_DATA_COLLECTION_CONF_FILE_NAME = 56;
        TRANSLATOR_CONFIG_FILE_NAME = 57;
        SYSLOGD_CONFIG_FILE_NAME = 58;
        LINKD_CONFIG_FILE_NAME = 59;
        MAP_PROPERTIES_FILE_NAME = 60;
        SURVEILLANCE_VIEWS_FILE_NAME = 61;
        SITE_STATUS_VIEWS_FILE_NAME = 62;
        MONITORING_LOCATIONS_FILE_NAME = 63;
        HTTP_COLLECTION_CONFIG_FILE_NAME = 64;
        NSCLIENT_COLLECTION_CONFIG_FILE_NAME = 65;
        NSCLIENT_CONFIG_FILE_NAME = 66;
        OPENNMS_DATASOURCE_CONFIG_FILE_NAME = 67;
        FILE_ID_TO_NAME = new String[68];
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DB_CONFIG_FILE_NAME] = "opennms-database.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.JMS_CONFIG_FILE_NAME] = "opennms-jms.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.ACTIOND_CONFIG_FILE_NAME] = "actiond-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.CAPSD_CONFIG_FILE_NAME] = "capsd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME] = "discovery-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EVENTD_CONFIG_FILE_NAME] = "eventd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NOTIFD_CONFIG_FILE_NAME] = "notifd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.OUTAGE_MANAGER_CONFIG_FILE_NAME] = "outage-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.POLLER_CONFIG_FILE_NAME] = "poller-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME] = "poll-outages.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.RTC_CONFIG_FILE_NAME] = "rtc-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.TRAPD_CONFIG_FILE_NAME] = "trapd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.MANAGER_CONFIG_FILE_NAME] = "manager-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SERVICE_CONF_FILE_NAME] = "service-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EVENTS_ARCHIVER_CONFIG_FILE_NAME] = "events-archiver-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.ADMIN_PITXML_FILE_NAME] = "pitXML.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.MAGIC_USERS_CONF_FILE_NAME] = "magic-users.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.POLLER_CONF_FILE_NAME] = "poller-config.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EXCLUDE_UEI_FILE_NAME] = "exclude-ueis.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.USERS_CONF_FILE_NAME] = "users.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.VIEWS_CONF_FILE_NAME] = "views.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.CATEGORIES_CONF_FILE_NAME] = "categories.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.GROUPS_CONF_FILE_NAME] = "groups.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NOTIFICATIONS_CONF_FILE_NAME] = "notifications.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NOTIF_COMMANDS_CONF_FILE_NAME] = "notificationCommands.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DESTINATION_PATHS_CONF_FILE_NAME] = "destinationPaths.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SNMP_CONF_FILE_NAME] = "snmp-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EVENT_CONF_FILE_NAME] = "eventconf.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DB_SCHEMA_FILE_NAME] = "database-schema.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME] = "datacollection-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.REPORT_PDF_XSL] = "PDFAvailReport.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.REPORT_SVG_XSL] = "SVGAvailReport.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.REPORT_HTML_XSL] = "AvailabilityReports.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EVENT_REPORT] = "EventReport.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.OUTAGE_REPORT] = "OutageReport.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.EVENT_REPORT_DTD] = "eventreport.dtd";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.OUTAGE_REPORT_DTD] = "outagereport.dtd";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NOTIFY_REPORT_DTD] = "notifications.dtd";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NOTIFY_REPORT] = "NotifyReport.xsl";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.BASE_CONFIGURATION_FILE_NAME] = "baseConfiguration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME] = "collectd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.THRESHD_CONFIG_FILE_NAME] = "threshd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME] = "thresholds.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.VULNSCAND_CONFIG_FILE_NAME] = "vulnscand-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.VIEWS_DISPLAY_CONF_FILE_NAME] = "viewsdisplay.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.WEBUI_COLORS_FILE_NAME] = "webui-colors.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.KSC_REPORT_FILE_NAME] = "ksc-performance-reports.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SCRIPTD_CONFIG_FILE_NAME] = "scriptd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.OPENNMS_SERVER_CONFIG_FILE_NAME] = "opennms-server.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.XMLRPCD_CONFIG_FILE_NAME] = "xmlrpcd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.DHCPD_CONFIG_FILE_NAME] = "dhcpd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.RRD_CONFIG_FILE_NAME] = "rrd-configuration.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.JAVA_MAIL_CONFIG_FILE_NAME] = "javamail-configuration.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.VACUUMD_CONFIG_FILE_NAME] = "vacuumd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.XMPP_CONFIG_FILE_NAME] = "xmpp-configuration.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.CHART_CONFIG_FILE_NAME] = "chart-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.JMX_DATA_COLLECTION_CONF_FILE_NAME] = "jmx-datacollection-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.TRANSLATOR_CONFIG_FILE_NAME] = "translator-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME] = "syslogd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.LINKD_CONFIG_FILE_NAME] = "linkd-configuration.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.MAP_PROPERTIES_FILE_NAME] = "map.properties";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME] = "surveillance-views.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.SITE_STATUS_VIEWS_FILE_NAME] = "site-status-views.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.MONITORING_LOCATIONS_FILE_NAME] = "monitoring-locations.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.HTTP_COLLECTION_CONFIG_FILE_NAME] = "http-datacollection-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NSCLIENT_COLLECTION_CONFIG_FILE_NAME] = "nsclient-datacollection-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.NSCLIENT_CONFIG_FILE_NAME] = "nsclient-config.xml";
        ConfigFileConstants.FILE_ID_TO_NAME[ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME] = "opennms-datasources.xml";
    }
}

