/*
 * Decompiled with CFR 0.152.
 */
package org.castor.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingLoaderFactory;
import org.castor.util.Configuration;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;

public final class MappingLoaderRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$mapping$MappingLoaderRegistry == null ? (class$org$castor$mapping$MappingLoaderRegistry = MappingLoaderRegistry.class$("org.castor.mapping.MappingLoaderRegistry")) : class$org$castor$mapping$MappingLoaderRegistry));
    private final List _mappingLoaderFactories = new ArrayList();
    private final List _mappingLoaders = new ArrayList();
    static /* synthetic */ Class class$org$castor$mapping$MappingLoaderRegistry;

    public MappingLoaderRegistry(Configuration config) {
        String prop = config.getProperty("org.castor.mapping.loaderFactories", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> cls = loader.loadClass(classname);
                Object obj = cls.getConstructor(null).newInstance(null);
                this._mappingLoaderFactories.add(obj);
            }
            catch (Exception ex) {
                LOG.error((Object)("Problem instantiating mapping loader factory implementation: " + classname), (Throwable)ex);
            }
        }
    }

    public void clear() {
        Iterator iter = this._mappingLoaders.iterator();
        while (iter.hasNext()) {
            ((MappingLoader)iter.next()).clear();
        }
    }

    public MappingLoader getMappingLoader(String sourceType, BindingType bindingType) throws MappingException {
        Iterator iter = this._mappingLoaderFactories.iterator();
        while (iter.hasNext()) {
            MappingLoaderFactory loaderFactory = (MappingLoaderFactory)iter.next();
            if (!loaderFactory.getSourceType().equals(sourceType) || loaderFactory.getBindingType() != bindingType) continue;
            MappingLoader mappingLoader = loaderFactory.getMappingLoader();
            this._mappingLoaders.add(mappingLoader);
            return mappingLoader;
        }
        String msg = "No mapping loader/factory for: SourceType=" + sourceType + " / BindingType=" + bindingType;
        LOG.error((Object)msg);
        throw new MappingException(msg);
    }

    public Collection getMappingLoaderFactories() {
        return Collections.unmodifiableCollection(this._mappingLoaderFactories);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

